/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class ParametersPropertySource implements IPropertySource {
  private final IQuerySpecificationRegistryEntry entry;

  public ParametersPropertySource(final IQuerySpecificationRegistryEntry adaptableObject) {
    this.entry = adaptableObject;
  }

  @Override
  public Object getEditableValue() {
    return this;
  }

  @Override
  public String toString() {
    return "";
  }

  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final String category = "Parameters";
    final List<IPropertyDescriptor> parameters = Lists.<IPropertyDescriptor>newArrayList();
    final IQuerySpecification<?> specification = this.entry.get();
    final Consumer<PParameter> _function = (PParameter param) -> {
      String _name = param.getName();
      String _name_1 = param.getName();
      final PropertyDescriptor property = new PropertyDescriptor(_name, _name_1);
      property.setCategory(category);
      parameters.add(property);
    };
    specification.getParameters().forEach(_function);
    return parameters.<IPropertyDescriptor>toArray(new IPropertyDescriptor[0]);
  }

  @Override
  public Object getPropertyValue(final Object id) {
    final IQuerySpecification<?> specification = this.entry.get();
    final Function1<PParameter, Boolean> _function = (PParameter it) -> {
      String _name = it.getName();
      return Boolean.valueOf(Objects.equals(_name, id));
    };
    final PParameter param = IterableExtensions.<PParameter>findFirst(specification.getParameters(), _function);
    return param.getTypeName();
  }

  @Override
  public boolean isPropertySet(final Object id) {
    return false;
  }

  @Override
  public void resetPropertyValue(final Object id) {
  }

  @Override
  public void setPropertyValue(final Object id, final Object value) {
  }
}
