/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.IIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public abstract class AbstractIndexTable
implements IIndexTable {
    private IInputKey inputKey;
    protected ITableContext tableContext;
    protected final TupleMask emptyMask;
    protected final Tuple emptyTuple;
    protected boolean emitNotifications = false;
    protected List<IListenersWithSameMask> listenerGroups = CollectionsFactory.createObserverList();

    public AbstractIndexTable(IInputKey inputKey, ITableContext tableContext) {
        this.inputKey = inputKey;
        this.tableContext = tableContext;
        this.emptyMask = TupleMask.empty(this.getInputKey().getArity());
        this.emptyTuple = Tuples.flatTupleOf(new Object[inputKey.getArity()]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.inputKey.getPrettyPrintableName();
    }

    @Override
    public IInputKey getInputKey() {
        return this.inputKey;
    }

    protected void logError(String message) {
        this.tableContext.logError(message);
    }

    protected void deliverChangeNotifications(Tuple updateTuple, boolean isInsertion) {
        for (IListenersWithSameMask listenersForSeed : this.listenerGroups) {
            listenersForSeed.deliver(updateTuple, isInsertion);
        }
    }

    @Override
    public void addUpdateListener(Tuple seed, IQueryRuntimeContextListener listener) {
        TupleMask seedMask;
        if (seed == null) {
            seed = this.emptyTuple;
            seedMask = this.emptyMask;
        } else {
            seedMask = TupleMask.fromNonNullIndices(seed);
        }
        IListenersWithSameMask listenerGroup = this.getListenerGroup(seedMask);
        if (listenerGroup == null) {
            switch (seedMask.getSize()) {
                case 0: {
                    listenerGroup = new UniversalListeners();
                    break;
                }
                case 1: {
                    listenerGroup = new ColumnBoundListeners(seedMask.indices[0]);
                    break;
                }
                default: {
                    listenerGroup = new GenericBoundListeners(seedMask);
                }
            }
            this.listenerGroups.add(listenerGroup);
            this.emitNotifications = true;
        }
        listenerGroup.addUpdateListener(seed, listener);
    }

    @Override
    public void removeUpdateListener(Tuple seed, IQueryRuntimeContextListener listener) {
        TupleMask seedMask;
        if (seed == null) {
            seed = this.emptyTuple;
            seedMask = this.emptyMask;
        } else {
            seedMask = TupleMask.fromNonNullIndices(seed);
        }
        IListenersWithSameMask listenerGroup = this.getListenerGroup(seedMask);
        if (listenerGroup == null) {
            throw new IllegalStateException("no listener subscribed with mask" + String.valueOf(seedMask));
        }
        if (listenerGroup.removeUpdateListener(seed, listener)) {
            this.listenerGroups.remove(listenerGroup);
            this.emitNotifications = !this.listenerGroups.isEmpty();
        }
    }

    protected IListenersWithSameMask getListenerGroup(TupleMask seedMask) {
        for (IListenersWithSameMask candidateGroup : this.listenerGroups) {
            if (!seedMask.equals(candidateGroup.getSeedMask())) continue;
            return candidateGroup;
        }
        return null;
    }

    protected final class ColumnBoundListeners
    implements IListenersWithSameMask {
        private int seedPosition;
        protected final TupleMask mask;
        protected IMultiLookup<Object, IQueryRuntimeContextListener> listeners = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);

        public ColumnBoundListeners(int seedPosition) {
            this.seedPosition = seedPosition;
            this.mask = TupleMask.selectSingle(seedPosition, AbstractIndexTable.this.inputKey.getArity());
        }

        @Override
        public TupleMask getSeedMask() {
            return this.mask;
        }

        @Override
        public void deliver(Tuple updateTuple, boolean isInsertion) {
            IInputKey key = AbstractIndexTable.this.inputKey;
            Object projectedSeed = updateTuple.get(this.seedPosition);
            for (IQueryRuntimeContextListener listener : this.listeners.lookupOrEmpty(projectedSeed)) {
                listener.update(key, updateTuple, isInsertion);
            }
        }

        @Override
        public void addUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            Object projectedSeed = originalSeed.get(this.seedPosition);
            this.listeners.addPair(projectedSeed, listener);
        }

        @Override
        public boolean removeUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            Object projectedSeed = originalSeed.get(this.seedPosition);
            this.listeners.removePair(projectedSeed, listener);
            return this.listeners.countKeys() == 0;
        }
    }

    protected final class GenericBoundListeners
    implements IListenersWithSameMask {
        protected final TupleMask mask;
        protected IMultiLookup<Tuple, IQueryRuntimeContextListener> listeners = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);

        public GenericBoundListeners(TupleMask mask) {
            this.mask = mask;
        }

        @Override
        public TupleMask getSeedMask() {
            return this.mask;
        }

        @Override
        public void deliver(Tuple updateTuple, boolean isInsertion) {
            IInputKey key = AbstractIndexTable.this.inputKey;
            Tuple projectedSeed = this.mask.transform(updateTuple);
            for (IQueryRuntimeContextListener listener : this.listeners.lookupOrEmpty(projectedSeed)) {
                listener.update(key, updateTuple, isInsertion);
            }
        }

        @Override
        public void addUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            Tuple projectedSeed = this.mask.transform(originalSeed);
            this.listeners.addPair(projectedSeed, listener);
        }

        @Override
        public boolean removeUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            Tuple projectedSeed = this.mask.transform(originalSeed);
            this.listeners.removePair(projectedSeed, listener);
            return this.listeners.countKeys() == 0;
        }
    }

    protected static interface IListenersWithSameMask {
        public TupleMask getSeedMask();

        public void deliver(Tuple var1, boolean var2);

        public void addUpdateListener(Tuple var1, IQueryRuntimeContextListener var2);

        public boolean removeUpdateListener(Tuple var1, IQueryRuntimeContextListener var2);
    }

    protected final class UniversalListeners
    implements IListenersWithSameMask {
        private final TupleMask mask;
        private List<IQueryRuntimeContextListener> listeners;

        protected UniversalListeners() {
            this.mask = TupleMask.empty(AbstractIndexTable.this.inputKey.getArity());
            this.listeners = CollectionsFactory.createObserverList();
        }

        @Override
        public TupleMask getSeedMask() {
            return this.mask;
        }

        @Override
        public void deliver(Tuple updateTuple, boolean isInsertion) {
            IInputKey key = AbstractIndexTable.this.inputKey;
            for (IQueryRuntimeContextListener listener : this.listeners) {
                listener.update(key, updateTuple, isInsertion);
            }
        }

        @Override
        public void addUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public boolean removeUpdateListener(Tuple originalSeed, IQueryRuntimeContextListener listener) {
            this.listeners.remove(listener);
            return this.listeners.isEmpty();
        }
    }
}

