/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.DefaultUnitConverter;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.actions.assistant.AbstractAssistantPage;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.grid.GridAlignmentHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsAssistantPage;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.DimensionsProperty;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutConverter;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.IPreferenceConstants;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.FormLayout.model.SelectionActionsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ColumnsDialog;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.RowsDialog;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutAssistantSupport;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

public final class FormLayoutInfo
extends LayoutInfo
implements IPreferenceConstants {
    private final List<FormColumnInfo> m_columns = new ArrayList<FormColumnInfo>();
    private final List<FormRowInfo> m_rows = new ArrayList<FormRowInfo>();
    private final List<List<FormColumnInfo>> m_columnGroups = new ArrayList<List<FormColumnInfo>>();
    private final List<List<FormRowInfo>> m_rowGroups = new ArrayList<List<FormRowInfo>>();
    private final Map<ComponentInfo, CellConstraintsSupport> m_constraints = new HashMap<ComponentInfo, CellConstraintsSupport>();
    private static final int DEFAULT_SIZE = 5;
    private int m_defaultColumnSize;
    private int m_gapColumnSize;
    private int m_defaultRowSize;
    private int m_gapRowSize;
    private IGridInfo m_gridInfo;
    public static final BidiMap<GeneralLayoutData.HorizontalAlignment, CellConstraints.Alignment> m_horizontalAlignmentMap;
    public static final BidiMap<GeneralLayoutData.VerticalAlignment, CellConstraints.Alignment> m_verticalAlignmentMap;

    static {
        DualHashBidiMap horizontalAlignmentMap = new DualHashBidiMap();
        horizontalAlignmentMap.put((Object)GeneralLayoutData.HorizontalAlignment.LEFT, (Object)CellConstraints.LEFT);
        horizontalAlignmentMap.put((Object)GeneralLayoutData.HorizontalAlignment.CENTER, (Object)CellConstraints.CENTER);
        horizontalAlignmentMap.put((Object)GeneralLayoutData.HorizontalAlignment.RIGHT, (Object)CellConstraints.RIGHT);
        horizontalAlignmentMap.put((Object)GeneralLayoutData.HorizontalAlignment.FILL, (Object)CellConstraints.FILL);
        horizontalAlignmentMap.put((Object)GeneralLayoutData.HorizontalAlignment.NONE, (Object)CellConstraints.DEFAULT);
        m_horizontalAlignmentMap = UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)horizontalAlignmentMap);
        DualHashBidiMap verticalAlignmentMap = new DualHashBidiMap();
        verticalAlignmentMap.put((Object)GeneralLayoutData.VerticalAlignment.TOP, (Object)CellConstraints.TOP);
        verticalAlignmentMap.put((Object)GeneralLayoutData.VerticalAlignment.CENTER, (Object)CellConstraints.CENTER);
        verticalAlignmentMap.put((Object)GeneralLayoutData.VerticalAlignment.BOTTOM, (Object)CellConstraints.BOTTOM);
        verticalAlignmentMap.put((Object)GeneralLayoutData.VerticalAlignment.FILL, (Object)CellConstraints.FILL);
        verticalAlignmentMap.put((Object)GeneralLayoutData.VerticalAlignment.NONE, (Object)CellConstraints.DEFAULT);
        m_verticalAlignmentMap = UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)verticalAlignmentMap);
    }

    public FormLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void initialize() throws Exception {
        super.initialize();
        if (this.m_columns.isEmpty() && this.m_rows.isEmpty()) {
            ColumnSpec spec;
            FormLayout layout = (FormLayout)this.getObject();
            int columnCount = layout.getColumnCount();
            int column = 1;
            while (column <= columnCount) {
                spec = layout.getColumnSpec(column);
                this.m_columns.add(new FormColumnInfo(spec));
                ++column;
            }
            int rowCount = layout.getRowCount();
            int row = 1;
            while (row <= rowCount) {
                spec = layout.getRowSpec(row);
                this.m_rows.add(new FormRowInfo((RowSpec)spec));
                ++row;
            }
        }
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                FormLayout layout = (FormLayout)FormLayoutInfo.this.getObject();
                FormLayoutInfo.fillDimensionGroups(layout.getColumnGroups(), FormLayoutInfo.this.m_columns, FormLayoutInfo.this.m_columnGroups);
                FormLayoutInfo.fillDimensionGroups(layout.getRowGroups(), FormLayoutInfo.this.m_rows, FormLayoutInfo.this.m_rowGroups);
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                FormLayoutInfo.this.addContextMenuActions(object, manager);
            }
        });
        this.addBroadcastListener(new JavaInfoAddProperties(){

            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                if (FormLayoutInfo.this.isManagedObject(javaInfo)) {
                    ComponentInfo component = (ComponentInfo)javaInfo;
                    CellConstraintsSupport support = FormLayoutInfo.getConstraints(component);
                    properties.add((Property)support.getCellProperty());
                }
            }
        });
        new SelectionActionsSupport(this);
        new LayoutAssistantSupport(this){

            protected AbstractAssistantPage createConstraintsPage(Composite parent, List<ObjectInfo> objects) {
                return new CellConstraintsAssistantPage(parent, FormLayoutInfo.this, objects);
            }
        };
    }

    protected void removeComponentConstraints(ContainerInfo container, ComponentInfo component) throws Exception {
        this.m_constraints.remove(component);
        super.removeComponentConstraints(container, component);
    }

    private void addContextMenuActions(ObjectInfo object, IMenuManager manager) throws Exception {
        if (object == this.getContainer()) {
            manager.appendToGroup("org.eclipse.wb.popup.group.top", (IAction)new EditDimensionsAction(ModelMessages.FormLayoutInfo_editColumns, true));
            manager.appendToGroup("org.eclipse.wb.popup.group.top", (IAction)new EditDimensionsAction(ModelMessages.FormLayoutInfo_editRows, false));
        }
        if (object instanceof ComponentInfo) {
            ComponentInfo component = (ComponentInfo)object;
            if (object.getParent() == this.getContainer()) {
                CellConstraintsSupport support = FormLayoutInfo.getConstraints(component);
                support.addContextMenu(manager);
            }
        }
    }

    protected List<Property> getPropertyList() throws Exception {
        List properties = super.getPropertyList();
        properties.add(new DimensionsProperty(this, true));
        properties.add(new DimensionsProperty(this, false));
        return properties;
    }

    public static CellConstraintsSupport getConstraints(ComponentInfo component) {
        ContainerInfo container = (ContainerInfo)component.getParent();
        Assert.isTrue((boolean)container.getChildrenComponents().contains(component));
        Assert.instanceOf(FormLayoutInfo.class, (Object)container.getLayout());
        FormLayoutInfo layout = (FormLayoutInfo)container.getLayout();
        CellConstraintsSupport support = layout.m_constraints.get(component);
        if (support == null) {
            support = new CellConstraintsSupport(layout, component);
            layout.m_constraints.put(component, support);
        }
        return support;
    }

    public void onSet() throws Exception {
        super.onSet();
        FormLayoutConverter.convert(this.getContainer(), this);
    }

    public List<FormColumnInfo> getColumns() {
        return this.m_columns;
    }

    public List<FormRowInfo> getRows() {
        return this.m_rows;
    }

    public void setColumns(List<FormColumnInfo> columns) throws Exception {
        this.m_columns.clear();
        this.m_columns.addAll(columns);
        this.writeDimensions();
    }

    public void setRows(List<FormRowInfo> rows) throws Exception {
        this.m_rows.clear();
        this.m_rows.addAll(rows);
        this.writeDimensions();
    }

    public Dimension getMinimumSize() {
        final Dimension size = new Dimension(0, 0);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo.this.visitComponents(new FormComponentVisitor(){

                    @Override
                    public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                        size.width = Math.max(size.width, cell.x + cell.width - 1);
                        size.height = Math.max(size.height, cell.y + cell.height - 1);
                    }
                });
            }
        });
        return size;
    }

    public int[] getColumnComponentsCounts() throws Exception {
        final int[] counts = new int[this.m_columns.size()];
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo.this.visitComponents(new FormComponentVisitor(){

                    @Override
                    public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                        int n = cell.x - 1;
                        counts[n] = counts[n] + 1;
                    }
                });
            }
        });
        return counts;
    }

    public int[] getRowComponentsCounts() throws Exception {
        final int[] counts = new int[this.m_rows.size()];
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo.this.visitComponents(new FormComponentVisitor(){

                    @Override
                    public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                        int n = cell.y - 1;
                        counts[n] = counts[n] + 1;
                    }
                });
            }
        });
        return counts;
    }

    public void normalizeSpanning() throws Exception {
        boolean columnRowDeleted = true;
        block0: while (columnRowDeleted) {
            columnRowDeleted = false;
            final boolean[] filledColumns = new boolean[this.m_columns.size()];
            final boolean[] filledRows = new boolean[this.m_rows.size()];
            this.visitComponents(new FormComponentVisitor(){

                @Override
                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    filledColumns[constraints.x - 1] = true;
                    filledRows[constraints.y - 1] = true;
                }
            });
            int column = filledColumns.length - 1;
            while (column >= 0) {
                if (!filledColumns[column] && !this.m_columns.get(column).isGap()) {
                    this.deleteColumn(column);
                    columnRowDeleted = true;
                    break;
                }
                --column;
            }
            int row = filledRows.length - 1;
            while (row >= 0) {
                if (!filledRows[row] && !this.m_rows.get(row).isGap()) {
                    this.deleteRow(row);
                    columnRowDeleted = true;
                    continue block0;
                }
                --row;
            }
        }
        this.writeDimensions();
    }

    public boolean canChangeDimensions() {
        return this.getCreationSupport() instanceof ConstructorCreationSupport;
    }

    public void writeDimensions() throws Exception {
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.getCreationSupport();
        ClassInstanceCreation creation = creationSupport.getCreation();
        String[] columnsSource = FormLayoutInfo.getDimenstionsSource(this.m_columns, "com.jgoodies.forms.layout.ColumnSpec");
        String[] rowsSource = FormLayoutInfo.getDimenstionsSource(this.m_rows, "com.jgoodies.forms.layout.RowSpec");
        int n = columnsSource.length - 1;
        columnsSource[n] = String.valueOf(columnsSource[n]) + ",";
        this.getEditor().replaceCreationArguments(creation, List.of(CodeUtils.join((String[])columnsSource, (String[])rowsSource)));
        this.writeDimensionsGroups("setColumnGroups", this.m_columns, this.m_columnGroups);
        this.writeDimensionsGroups("setRowGroups", this.m_rows, this.m_rowGroups);
    }

    private static String[] getDimenstionsSource(List<? extends FormDimensionInfo> dimensions, String typeSource) throws Exception {
        if (dimensions.isEmpty()) {
            return new String[]{"\tnew " + typeSource + "[] {}"};
        }
        String[] lines = new String[1 + dimensions.size()];
        lines[0] = "\tnew " + typeSource + "[] {";
        int i = 0;
        while (i < dimensions.size()) {
            FormDimensionInfo dimension = dimensions.get(i);
            lines[1 + i] = "\t\t" + dimension.getSource() + ",";
            ++i;
        }
        int n = lines.length - 1;
        lines[n] = String.valueOf(lines[n]) + "}";
        return lines;
    }

    public int getDimensionGroupIndex(FormDimensionInfo dimension) {
        if (dimension instanceof FormColumnInfo) {
            FormColumnInfo column = (FormColumnInfo)dimension;
            return this.m_columnGroups.indexOf(this.getColumnGroup(column));
        }
        FormRowInfo row = (FormRowInfo)dimension;
        return this.m_rowGroups.indexOf(this.getRowGroup(row));
    }

    public List<FormColumnInfo> getColumnGroup(FormColumnInfo column) {
        return FormLayoutInfo.getDimensionGroup(column, this.m_columnGroups);
    }

    public List<FormRowInfo> getRowGroup(FormRowInfo row) {
        return FormLayoutInfo.getDimensionGroup(row, this.m_rowGroups);
    }

    private static <T extends FormDimensionInfo> List<T> getDimensionGroup(T dimension, List<List<T>> groups) {
        for (List<T> group : groups) {
            if (!group.contains(dimension)) continue;
            return group;
        }
        return null;
    }

    private static <T extends FormDimensionInfo> void fillDimensionGroups(int[][] intGroups, List<T> dimensions, List<List<T>> groups) {
        int groupIndex = 0;
        while (groupIndex < intGroups.length) {
            int[] intGroup = intGroups[groupIndex];
            ArrayList<FormDimensionInfo> group = new ArrayList<FormDimensionInfo>();
            groups.add(group);
            int groupElementIndex = 0;
            while (groupElementIndex < intGroup.length) {
                int dimensionIndex = intGroup[groupElementIndex];
                FormDimensionInfo dimension = (FormDimensionInfo)dimensions.get(dimensionIndex - 1);
                group.add(dimension);
                ++groupElementIndex;
            }
            ++groupIndex;
        }
    }

    private <T extends FormDimensionInfo> void writeDimensionsGroups(String methodName, List<T> dimensions, List<List<T>> groups) throws Exception {
        Iterator<List<T>> I = groups.iterator();
        while (I.hasNext()) {
            List<T> group = I.next();
            Iterator<T> J = group.iterator();
            while (J.hasNext()) {
                FormDimensionInfo dimensionInGroup = (FormDimensionInfo)J.next();
                if (dimensions.contains(dimensionInGroup)) continue;
                J.remove();
            }
            if (group.size() >= 2) continue;
            I.remove();
        }
        String methodSignature = methodName + "(int[][])";
        MethodInvocation invocation = this.getMethodInvocation(methodSignature);
        if (!groups.isEmpty()) {
            Object groupsSource = "new int[][]{";
            ListIterator<List<T>> I2 = groups.listIterator();
            while (I2.hasNext()) {
                List<T> group = I2.next();
                if (I2.previousIndex() != 0) {
                    groupsSource = (String)groupsSource + ", ";
                }
                groupsSource = (String)groupsSource + "new int[]{";
                ListIterator<T> J = group.listIterator();
                while (J.hasNext()) {
                    FormDimensionInfo dimensionInGroup = (FormDimensionInfo)J.next();
                    if (J.previousIndex() != 0) {
                        groupsSource = (String)groupsSource + ", ";
                    }
                    groupsSource = (String)groupsSource + (1 + dimensions.indexOf(dimensionInGroup));
                }
                groupsSource = (String)groupsSource + "}";
            }
            groupsSource = (String)groupsSource + "}";
            if (invocation != null) {
                Expression groupsExpression = (Expression)invocation.arguments().get(0);
                this.getEditor().replaceExpression(groupsExpression, (String)groupsSource);
            } else {
                this.addMethodInvocation(methodSignature, (String)groupsSource);
            }
        } else if (invocation != null) {
            this.getEditor().removeEnclosingStatement((ASTNode)invocation);
        }
    }

    public void unGroupColumns(List<FormColumnInfo> columns) throws Exception {
        FormLayoutInfo.unGroupDimensions(columns, this.m_columnGroups);
        this.writeDimensionsGroups("setColumnGroups", this.m_columns, this.m_columnGroups);
    }

    public void unGroupRows(List<FormRowInfo> rows) throws Exception {
        FormLayoutInfo.unGroupDimensions(rows, this.m_rowGroups);
        this.writeDimensionsGroups("setRowGroups", this.m_rows, this.m_rowGroups);
    }

    private static <T extends FormDimensionInfo> void unGroupDimensions(List<T> dimensions, List<List<T>> groups) throws Exception {
        for (List<T> group : groups) {
            group.removeAll(dimensions);
        }
    }

    public void groupColumns(List<FormColumnInfo> columns) throws Exception {
        FormLayoutInfo.groupDimensions(columns, this.m_columnGroups);
        this.writeDimensionsGroups("setColumnGroups", this.m_columns, this.m_columnGroups);
    }

    public void groupRows(List<FormRowInfo> rows) throws Exception {
        FormLayoutInfo.groupDimensions(rows, this.m_rowGroups);
        this.writeDimensionsGroups("setRowGroups", this.m_rows, this.m_rowGroups);
    }

    private static <T extends FormDimensionInfo> void groupDimensions(List<T> dimensions, List<List<T>> groups) {
        Iterator<T> I = dimensions.iterator();
        while (I.hasNext()) {
            FormDimensionInfo dimension = (FormDimensionInfo)I.next();
            if (!dimension.isGap()) continue;
            I.remove();
        }
        if (dimensions.size() < 2) {
            return;
        }
        List<FormDimensionInfo> targetGroup = null;
        for (List<T> group : groups) {
            for (FormDimensionInfo dimension : dimensions) {
                if (!group.contains(dimension)) continue;
                if (targetGroup == null) {
                    targetGroup = group;
                    continue;
                }
                if (targetGroup == group) continue;
                return;
            }
        }
        if (targetGroup == null) {
            targetGroup = new ArrayList<FormDimensionInfo>();
            groups.add(targetGroup);
        }
        for (FormDimensionInfo dimension : dimensions) {
            if (targetGroup.contains(dimension)) continue;
            targetGroup.add(dimension);
        }
    }

    public void insertColumn(int targetIndex) throws Exception {
        boolean targetLast = targetIndex == this.m_columns.size();
        boolean targetGap = !targetLast && this.m_columns.get(targetIndex).isGap();
        this.moveComponentsForInsert(1 + targetIndex, true, -1, false);
        this.moveComponentsForInsert(1 + targetIndex, true, -1, false);
        if (targetGap) {
            this.m_columns.add(targetIndex, new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
            this.m_columns.add(targetIndex + 1, new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC));
        } else if (targetLast) {
            if (!this.m_columns.isEmpty() && !this.m_columns.get(targetIndex - 1).isGap()) {
                this.m_columns.add(targetIndex++, new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
            }
            this.m_columns.add(targetIndex, new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC));
        } else {
            this.m_columns.add(targetIndex, new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC));
            this.m_columns.add(targetIndex + 1, new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
        }
        this.writeDimensions();
    }

    public void deleteColumn(int index) throws Exception {
        boolean isNextGap;
        boolean isFirst = index == 0;
        boolean isLast = index == this.m_columns.size() - 1;
        boolean isGap = this.m_columns.get(index).isGap();
        boolean isPrevGap = !isFirst && this.m_columns.get(index - 1).isGap();
        boolean bl = isNextGap = !isLast && this.m_columns.get(index + 1).isGap();
        if (isGap) {
            this.deleteSingleColumn(index);
        } else {
            this.deleteSingleColumn(index);
            if (isPrevGap) {
                this.deleteSingleColumn(index - 1);
            } else if (isNextGap) {
                this.deleteSingleColumn(index);
            }
        }
        this.writeDimensions();
    }

    private void deleteSingleColumn(final int index) throws Exception {
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.x == 1 + index) {
                    component.delete();
                } else if (cell.x > 1 + index) {
                    --cell.x;
                } else if (cell.x + cell.width > 1 + index) {
                    --cell.width;
                }
                cell.write();
            }
        });
        this.m_columns.remove(index);
    }

    public void deleteColumnContents(final int index) throws Exception {
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.x == 1 + index) {
                    component.delete();
                }
            }
        });
    }

    public void splitColumn(final int index) throws Exception {
        FormColumnInfo column = this.m_columns.get(index);
        this.m_columns.add(index + 1, new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
        this.m_columns.add(index + 2, column.copy());
        this.writeDimensions();
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.x > 1 + index) {
                    cell.x += 2;
                } else if (cell.x + cell.width > 1 + index) {
                    cell.width += 2;
                }
                cell.write();
            }
        });
    }

    public void command_MOVE_COLUMN(int index, int targetIndex) throws Exception {
        boolean targetGap;
        boolean isFirst = index == 0;
        boolean isLast = index == this.m_columns.size() - 1;
        boolean isGap = this.m_columns.get(index).isGap();
        boolean isPrevGap = !isFirst && this.m_columns.get(index - 1).isGap();
        boolean isNextGap = !isLast && this.m_columns.get(index + 1).isGap();
        boolean targetFirst = targetIndex == 0;
        boolean targetLast = targetIndex == this.m_columns.size();
        boolean bl = targetGap = !targetLast && this.m_columns.get(targetIndex).isGap();
        if (index < targetIndex) {
            if (isGap) {
                this.moveSingleColumn(index, targetIndex);
            } else if (isPrevGap) {
                this.moveSingleColumn(index - 1, targetIndex);
                this.moveSingleColumn(index - 1, targetIndex);
            } else if (isFirst && isNextGap) {
                if (targetLast) {
                    this.moveSingleColumn(1, targetIndex);
                    this.moveSingleColumn(0, targetIndex);
                } else {
                    if (targetGap) {
                        ++targetIndex;
                    }
                    this.moveSingleColumn(0, targetIndex);
                    this.moveSingleColumn(0, targetIndex);
                }
            } else {
                this.moveSingleColumn(index, targetIndex);
            }
        } else if (isGap) {
            this.moveSingleColumn(index, targetIndex);
        } else if (isPrevGap && targetFirst && !targetGap) {
            this.moveSingleColumn(index, 0);
            this.moveSingleColumn(index, 1);
        } else if (isPrevGap) {
            this.moveSingleColumn(index, targetIndex);
            this.moveSingleColumn(index, targetIndex);
        } else {
            this.moveSingleColumn(index, targetIndex);
        }
        this.writeDimensions();
    }

    private void moveSingleColumn(final int index, final int targetIndex) throws Exception {
        FormColumnInfo column = this.m_columns.remove(index);
        if (index < targetIndex) {
            this.m_columns.add(targetIndex - 1, column);
            this.visitComponents(new FormComponentVisitor(){

                @Override
                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int x = constraints.x;
                    int w = constraints.width;
                    if (x < 1 + index) {
                        if (x + w - 1 >= 1 + index && x + w - 1 < 1 + targetIndex) {
                            constraints.width = w - 1;
                        }
                    } else if (x == 1 + index) {
                        constraints.x = targetIndex;
                        constraints.width = 1;
                    } else if (x > 1 + index && x < 1 + targetIndex) {
                        constraints.x = x - 1;
                        if (x + w - 1 >= 1 + targetIndex) {
                            constraints.width = w + 1;
                        }
                    }
                    constraints.write();
                }
            });
        } else {
            this.m_columns.add(targetIndex, column);
            this.visitComponents(new FormComponentVisitor(){

                @Override
                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int x = constraints.x;
                    int w = constraints.width;
                    if (x < 1 + targetIndex) {
                        if (x + w - 1 >= 1 + targetIndex && x + w - 1 < 1 + index) {
                            constraints.width = w + 1;
                        }
                    } else if (x < 1 + index) {
                        constraints.x = x + 1;
                        if (x + w - 1 >= 1 + index) {
                            constraints.width = w - 1;
                        }
                    } else if (x == 1 + index) {
                        constraints.x = 1 + targetIndex;
                        constraints.width = 1;
                    }
                    constraints.write();
                }
            });
        }
    }

    public void insertRow(int targetIndex) throws Exception {
        boolean targetLast = targetIndex == this.m_rows.size();
        boolean targetGap = !targetLast && this.m_rows.get(targetIndex).isGap();
        this.moveComponentsForInsert(-1, false, 1 + targetIndex, true);
        this.moveComponentsForInsert(-1, false, 1 + targetIndex, true);
        if (targetGap) {
            this.m_rows.add(targetIndex, new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
            this.m_rows.add(targetIndex + 1, new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC));
        } else if (targetLast) {
            if (!this.m_rows.isEmpty() && !this.m_rows.get(targetIndex - 1).isGap()) {
                this.m_rows.add(targetIndex++, new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
            }
            this.m_rows.add(targetIndex, new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC));
        } else {
            this.m_rows.add(targetIndex, new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC));
            this.m_rows.add(targetIndex + 1, new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
        }
        this.writeDimensions();
    }

    public void deleteRow(int index) throws Exception {
        boolean isNextGap;
        boolean isFirst = index == 0;
        boolean isLast = index == this.m_rows.size() - 1;
        boolean isGap = this.m_rows.get(index).isGap();
        boolean isPrevGap = !isFirst && this.m_rows.get(index - 1).isGap();
        boolean bl = isNextGap = !isLast && this.m_rows.get(index + 1).isGap();
        if (isGap) {
            this.deleteSingleRow(index);
        } else {
            this.deleteSingleRow(index);
            if (isPrevGap) {
                this.deleteSingleRow(index - 1);
            } else if (isNextGap) {
                this.deleteSingleRow(index);
            }
        }
        this.writeDimensions();
    }

    private void deleteSingleRow(final int index) throws Exception {
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.y == 1 + index) {
                    component.delete();
                } else if (cell.y > 1 + index) {
                    --cell.y;
                } else if (cell.y + cell.height > 1 + index) {
                    --cell.height;
                }
                cell.write();
            }
        });
        this.m_rows.remove(index);
    }

    public void deleteRowContents(final int index) throws Exception {
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.y == 1 + index) {
                    component.delete();
                }
            }
        });
    }

    public void splitRow(final int index) throws Exception {
        FormRowInfo row = this.m_rows.get(index);
        this.m_rows.add(index + 1, new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
        this.m_rows.add(index + 2, row.copy());
        this.writeDimensions();
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (cell.y > 1 + index) {
                    cell.y += 2;
                } else if (cell.y + cell.height > 1 + index) {
                    cell.height += 2;
                }
                cell.write();
            }
        });
    }

    public void command_MOVE_ROW(int index, int targetIndex) throws Exception {
        boolean targetGap;
        boolean isFirst = index == 0;
        boolean isLast = index == this.m_rows.size() - 1;
        boolean isGap = this.m_rows.get(index).isGap();
        boolean isPrevGap = !isFirst && this.m_rows.get(index - 1).isGap();
        boolean isNextGap = !isLast && this.m_rows.get(index + 1).isGap();
        boolean targetFirst = targetIndex == 0;
        boolean targetLast = targetIndex == this.m_rows.size();
        boolean bl = targetGap = !targetLast && this.m_rows.get(targetIndex).isGap();
        if (index < targetIndex) {
            if (isGap) {
                this.moveSingleRow(index, targetIndex);
            } else if (isPrevGap) {
                this.moveSingleRow(index - 1, targetIndex);
                this.moveSingleRow(index - 1, targetIndex);
            } else if (isFirst && isNextGap) {
                if (targetLast) {
                    this.moveSingleRow(1, targetIndex);
                    this.moveSingleRow(0, targetIndex);
                } else {
                    if (targetGap) {
                        ++targetIndex;
                    }
                    this.moveSingleRow(0, targetIndex);
                    this.moveSingleRow(0, targetIndex);
                }
            } else {
                this.moveSingleRow(index, targetIndex);
            }
        } else if (isGap) {
            this.moveSingleRow(index, targetIndex);
        } else if (isPrevGap && targetFirst && !targetGap) {
            this.moveSingleRow(index, 0);
            this.moveSingleRow(index, 1);
        } else if (isPrevGap) {
            this.moveSingleRow(index, targetIndex);
            this.moveSingleRow(index, targetIndex);
        } else {
            this.moveSingleRow(index, targetIndex);
        }
        this.writeDimensions();
    }

    private void moveSingleRow(final int index, final int targetIndex) throws Exception {
        FormRowInfo row = this.m_rows.remove(index);
        if (index < targetIndex) {
            this.m_rows.add(targetIndex - 1, row);
            this.visitComponents(new FormComponentVisitor(){

                @Override
                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int y = constraints.y;
                    int h = constraints.height;
                    if (y < 1 + index) {
                        if (y + h - 1 >= 1 + index && y + h - 1 < 1 + targetIndex) {
                            constraints.height = h - 1;
                        }
                    } else if (y == 1 + index) {
                        constraints.y = targetIndex;
                        constraints.height = 1;
                    } else if (y > 1 + index && y < 1 + targetIndex) {
                        constraints.y = y - 1;
                        if (y + h - 1 >= 1 + targetIndex) {
                            constraints.height = h + 1;
                        }
                    }
                    constraints.write();
                }
            });
        } else {
            this.m_rows.add(targetIndex, row);
            this.visitComponents(new FormComponentVisitor(){

                @Override
                public void visit(ComponentInfo bean, CellConstraintsSupport constraints) throws Exception {
                    int y = constraints.y;
                    int h = constraints.height;
                    if (y < 1 + targetIndex) {
                        if (y + h - 1 >= 1 + targetIndex && y + h - 1 < 1 + index) {
                            constraints.height = h + 1;
                        }
                    } else if (y < 1 + index) {
                        constraints.y = y + 1;
                        if (y + h - 1 >= 1 + index) {
                            constraints.height = h - 1;
                        }
                    } else if (y == 1 + index) {
                        constraints.y = 1 + targetIndex;
                        constraints.height = 1;
                    }
                    constraints.write();
                }
            });
        }
    }

    public void command_CREATE(ComponentInfo newComponent, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        Point cell = this.prepareCell(column, insertColumn, row, insertRow);
        ComponentInfo nextComponent = this.getReference(column, row, null);
        this.add(newComponent, "\"" + cell.x + ", " + cell.y + "\"", nextComponent);
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(newComponent);
        constraints.x = cell.x;
        constraints.y = cell.y;
        this.doAutomaticAlignment(newComponent);
    }

    public void command_MOVE(ComponentInfo component, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        Point cell = this.prepareCell(column, insertColumn, row, insertRow);
        ComponentInfo nextComponent = this.getReference(column, row, component);
        this.move(component, null, nextComponent);
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
        constraints.x = cell.x;
        constraints.y = cell.y;
        constraints.width = 1;
        constraints.height = 1;
        constraints.write();
    }

    public void command_ADD(ComponentInfo component, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        Point cell = this.prepareCell(column, insertColumn, row, insertRow);
        ComponentInfo nextComponent = this.getReference(column, row, component);
        this.move(component, "\"" + cell.x + ", " + cell.y + "\"", nextComponent);
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
        constraints.x = cell.x;
        constraints.y = cell.y;
        constraints.write();
    }

    private ComponentInfo getReference(int column, int row, ComponentInfo exclude) throws Exception {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            if (component == exclude) continue;
            CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
            if (constraints.y <= row && (constraints.y != row || constraints.x < column)) continue;
            return component;
        }
        return null;
    }

    private Point prepareCell(int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        int addRows;
        int i;
        int addColumns;
        boolean writeDimensions = false;
        if (insertColumn || insertRow) {
            this.moveComponentsForInsert(column, insertColumn, row, insertRow);
            this.moveComponentsForInsert(column, insertColumn, row, insertRow);
            if (insertColumn) {
                this.m_columns.add(column - 1, new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
                this.m_columns.add(column - 1 + 1, new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC));
                ++column;
            }
            if (insertRow) {
                this.m_rows.add(row - 1, new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
                this.m_rows.add(row - 1 + 1, new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC));
                ++row;
            }
            writeDimensions = true;
        }
        if ((addColumns = column - this.m_columns.size()) > 0) {
            Assert.isTrue((addColumns % 2 == 0 ? 1 : 0) != 0, (String)MessageFormat.format(ModelMessages.FormLayoutInfo_evenDiffNumColumns, addColumns));
            i = 0;
            while (i < addColumns / 2) {
                this.m_columns.add(new FormColumnInfo(FormSpecs.RELATED_GAP_COLSPEC));
                this.m_columns.add(new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC));
                ++i;
            }
            writeDimensions = true;
        }
        if ((addRows = row - this.m_rows.size()) > 0) {
            Assert.isTrue((addRows % 2 == 0 ? 1 : 0) != 0, (String)MessageFormat.format(ModelMessages.FormLayoutInfo_evenDiffNumRows, addRows));
            i = 0;
            while (i < addRows / 2) {
                this.m_rows.add(new FormRowInfo(FormSpecs.RELATED_GAP_ROWSPEC));
                this.m_rows.add(new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC));
                ++i;
            }
            writeDimensions = true;
        }
        if (writeDimensions) {
            this.writeDimensions();
        }
        return new Point(column, row);
    }

    private void moveComponentsForInsert(final int column, final boolean insertColumn, final int row, final boolean insertRow) throws Exception {
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport cell) throws Exception {
                if (insertColumn) {
                    if (cell.x >= column) {
                        ++cell.x;
                    } else if (cell.x + cell.width > column) {
                        ++cell.width;
                    }
                }
                if (insertRow) {
                    if (cell.y >= row) {
                        ++cell.y;
                    } else if (cell.y + cell.height > row) {
                        ++cell.height;
                    }
                }
                cell.write();
            }
        });
    }

    private void visitComponents(FormComponentVisitor visitor) throws Exception {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport cell = FormLayoutInfo.getConstraints(component);
            visitor.visit(component, cell);
        }
    }

    private void doAutomaticAlignment(ComponentInfo component) throws Exception {
        final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        GridAlignmentHelper.doAutomaticAlignment((IAbstractComponentInfo)component, (GridAlignmentHelper.IAlignmentProcessor)new GridAlignmentHelper.IAlignmentProcessor<ComponentInfo>(){

            public boolean grabEnabled() {
                return preferences.getBoolean("FormLayout.enableGrab");
            }

            public boolean rightEnabled() {
                return preferences.getBoolean("FormLayout.enableRightAlignment");
            }

            public ComponentInfo getComponentAtLeft(ComponentInfo component) {
                CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
                int x = constraints.x - 1;
                if (x > 0 && FormLayoutInfo.this.m_columns.get(x - 1).isGap()) {
                    --x;
                }
                return FormLayoutInfo.this.getComponentAt(x, constraints.y);
            }

            public ComponentInfo getComponentAtRight(ComponentInfo component) {
                CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
                int x = constraints.x + 1;
                if (x < FormLayoutInfo.this.m_columns.size() && FormLayoutInfo.this.m_columns.get(x - 1).isGap()) {
                    ++x;
                }
                return FormLayoutInfo.this.getComponentAt(x, constraints.y);
            }

            public void setGrabFill(ComponentInfo component, boolean horizontal) throws Exception {
                boolean canChangeDimensions = FormLayoutInfo.this.canChangeDimensions();
                CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
                if (horizontal) {
                    if (canChangeDimensions) {
                        FormLayoutInfo.this.getColumns().get(constraints.x - 1).setWeight(1.0);
                    }
                    constraints.setAlignH(CellConstraints.FILL);
                } else {
                    if (canChangeDimensions) {
                        FormLayoutInfo.this.getRows().get(constraints.y - 1).setWeight(1.0);
                    }
                    constraints.setAlignV(CellConstraints.FILL);
                }
                if (canChangeDimensions) {
                    FormLayoutInfo.this.writeDimensions();
                }
                constraints.write();
            }

            public void setRightAlignment(ComponentInfo component) throws Exception {
                CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
                constraints.setAlignH(CellConstraints.RIGHT);
                constraints.write();
            }
        });
    }

    private ComponentInfo getComponentAt(int x, int y) {
        for (ComponentInfo component : this.getContainer().getChildrenComponents()) {
            CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
            if (constraints.x != x || constraints.y != y) continue;
            return component;
        }
        return null;
    }

    public void refresh_dispose() throws Exception {
        this.m_gridInfo = null;
        super.refresh_dispose();
    }

    protected void refresh_afterCreate2() throws Exception {
        ColumnSpec spec;
        super.refresh_afterCreate2();
        FormLayout layout = (FormLayout)this.getObject();
        Container container = this.getContainer().getContainer();
        FormLayout.LayoutInfo layoutInfo = layout.getLayoutInfo(container);
        int[] columnOrigins = layoutInfo.columnOrigins;
        int[] rowOrigins = layoutInfo.rowOrigins;
        DefaultUnitConverter converter = DefaultUnitConverter.getInstance();
        this.m_defaultColumnSize = converter.millimeterAsPixel(5.0, (Component)container);
        this.m_defaultRowSize = converter.millimeterAsPixel(5.0, (Component)container);
        this.m_gapColumnSize = new FormSizeInfo(FormSpecs.RELATED_GAP_COLSPEC.getSize(), true).getConstantSize().getAsPixels();
        this.m_gapRowSize = new FormSizeInfo(FormSpecs.RELATED_GAP_ROWSPEC.getSize(), false).getConstantSize().getAsPixels();
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        int column = 1;
        while (column <= columnCount) {
            spec = layout.getColumnSpec(column);
            if (columnOrigins[column] - columnOrigins[column - 1] == 0) {
                spec = ColumnSpec.decode((String)"5mm");
                layout.setColumnSpec(column, spec);
            }
            ++column;
        }
        int row = 1;
        while (row <= rowCount) {
            spec = layout.getRowSpec(row);
            if (rowOrigins[row] - rowOrigins[row - 1] == 0) {
                spec = RowSpec.decode((String)"5mm");
                layout.setRowSpec(row, (RowSpec)spec);
            }
            ++row;
        }
        container.doLayout();
    }

    public IGridInfo getGridInfo() {
        if (this.m_gridInfo == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    FormLayoutInfo.this.createGridInfo();
                }
            });
        }
        return this.m_gridInfo;
    }

    private void createGridInfo() throws Exception {
        FormLayout layout = (FormLayout)this.getObject();
        Container container = this.getContainer().getContainer();
        FormLayout.LayoutInfo layoutInfo = layout.getLayoutInfo(container);
        int[] columnOrigins = layoutInfo.columnOrigins;
        int[] rowOrigins = layoutInfo.rowOrigins;
        final Interval[] columnIntervals = FormLayoutInfo.getIntervalsForOrigins(columnOrigins);
        final Interval[] rowIntervals = FormLayoutInfo.getIntervalsForOrigins(rowOrigins);
        final HashMap componentToCells = new HashMap();
        final HashMap occupiedCells = new HashMap();
        this.visitComponents(new FormComponentVisitor(){

            @Override
            public void visit(ComponentInfo component, CellConstraintsSupport support) throws Exception {
                Rectangle cells = new Rectangle(support.x - 1, support.y - 1, support.width, support.height);
                componentToCells.put(component, cells);
                int x = cells.x;
                while (x < cells.right()) {
                    int y = cells.y;
                    while (y < cells.bottom()) {
                        occupiedCells.put(new Point(x, y), component);
                        ++y;
                    }
                    ++x;
                }
            }
        });
        this.m_gridInfo = new IGridInfo(){

            public int getColumnCount() {
                return columnIntervals.length;
            }

            public int getRowCount() {
                return rowIntervals.length;
            }

            public Interval[] getColumnIntervals() {
                return columnIntervals;
            }

            public Interval[] getRowIntervals() {
                return rowIntervals;
            }

            public Rectangle getComponentCells(IAbstractComponentInfo component) {
                Assert.instanceOf(ComponentInfo.class, (Object)component);
                return (Rectangle)componentToCells.get(component);
            }

            public Rectangle getCellsRectangle(Rectangle cells) {
                int x = columnIntervals[cells.x].begin();
                int y = rowIntervals[cells.y].begin();
                int w = columnIntervals[cells.right() - 1].end() - x;
                int h = rowIntervals[cells.bottom() - 1].end() - y;
                return new Rectangle(x, y, w + 1, h + 1);
            }

            public boolean isRTL() {
                return false;
            }

            public Insets getInsets() {
                return FormLayoutInfo.this.getContainer().getInsets();
            }

            public boolean hasVirtualColumns() {
                return true;
            }

            public int getVirtualColumnSize() {
                return FormLayoutInfo.this.m_defaultColumnSize;
            }

            public int getVirtualColumnGap() {
                return FormLayoutInfo.this.m_gapColumnSize;
            }

            public boolean hasVirtualRows() {
                return true;
            }

            public int getVirtualRowSize() {
                return FormLayoutInfo.this.m_defaultRowSize;
            }

            public int getVirtualRowGap() {
                return FormLayoutInfo.this.m_gapRowSize;
            }

            public ComponentInfo getOccupied(int column, int row) {
                return (ComponentInfo)occupiedCells.get(new Point(column, row));
            }
        };
    }

    protected void storeLayoutData(ComponentInfo component) throws Exception {
        CellConstraintsSupport gridData = FormLayoutInfo.getConstraints(component);
        if (gridData != null) {
            GeneralLayoutData generalLayoutData = new GeneralLayoutData();
            int x = gridData.x - 1;
            int y = gridData.y - 1;
            int width = gridData.width;
            int height = gridData.height;
            int dx = 0;
            int dy = 0;
            int i = 0;
            while (i < x) {
                if (this.m_columns.get(i).isGap()) {
                    --dx;
                }
                ++i;
            }
            int j = 0;
            while (j < y) {
                if (this.m_rows.get(j).isGap()) {
                    --dy;
                }
                ++j;
            }
            i = 1;
            while (i < width) {
                if (this.m_columns.get(x + i).isGap()) {
                    --width;
                }
                ++i;
            }
            j = 1;
            while (j < height) {
                if (this.m_rows.get(y + j).isGap()) {
                    --height;
                }
                ++j;
            }
            generalLayoutData.gridX = x + dx;
            generalLayoutData.gridY = y + dy;
            generalLayoutData.spanX = width;
            generalLayoutData.spanY = height;
            generalLayoutData.horizontalGrab = this.m_columns.get(gridData.x - 1).hasGrow();
            generalLayoutData.verticalGrab = this.m_rows.get(gridData.y - 1).hasGrow();
            generalLayoutData.horizontalAlignment = (GeneralLayoutData.HorizontalAlignment)GeneralLayoutData.getGeneralValue(m_horizontalAlignmentMap, (Object)gridData.alignH);
            generalLayoutData.verticalAlignment = (GeneralLayoutData.VerticalAlignment)GeneralLayoutData.getGeneralValue(m_verticalAlignmentMap, (Object)gridData.alignV);
            generalLayoutData.putToInfo((ObjectInfo)component);
        }
    }

    private static Interval[] getIntervalsForOrigins(int[] origins) {
        Assert.isTrue((origins.length != 0 ? 1 : 0) != 0);
        Interval[] intervals = new Interval[origins.length - 1];
        int i = 0;
        while (i < intervals.length) {
            int begin = origins[i];
            int end = origins[i + 1];
            intervals[i] = new Interval(begin, end - begin);
            ++i;
        }
        return intervals;
    }

    private final class EditDimensionsAction
    extends Action {
        private final boolean m_horizontal;

        public EditDimensionsAction(String text, boolean horizontal) {
            super(text);
            this.m_horizontal = horizontal;
        }

        public void run() {
            Shell shell = DesignerPlugin.getShell();
            if (this.m_horizontal) {
                new ColumnsDialog(shell, FormLayoutInfo.this).open();
            } else {
                new RowsDialog(shell, FormLayoutInfo.this).open();
            }
        }
    }

    private static interface FormComponentVisitor {
        public void visit(ComponentInfo var1, CellConstraintsSupport var2) throws Exception;
    }
}

