/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.reviews.ui.IActiveReviewListener;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public class ActiveReviewManager {
    private IReview review = null;
    private TaskEditor currentPart;
    private final List<IActiveReviewListener> reviewListeners = new ArrayList<IActiveReviewListener>();
    private final IPartListener editorPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == ActiveReviewManager.this.currentPart) {
                ActiveReviewManager.this.currentPart = null;
                ActiveReviewManager.this.setReview(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof TaskEditor) {
                IFormPage page;
                TaskEditor editor = (TaskEditor)part;
                if (ActiveReviewManager.this.currentPart != part && (page = editor.getActivePageInstance()) instanceof AbstractReviewTaskEditorPage) {
                    ActiveReviewManager.this.currentPart = editor;
                    AbstractReviewTaskEditorPage reviewPage = (AbstractReviewTaskEditorPage)page;
                    ActiveReviewManager.this.setReview(reviewPage.getReview());
                }
            }
        }
    };
    private final IPageListener pageListener = new IPageListener(){
        private IWorkbenchPage activePage;

        public void pageOpened(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            this.pageActivated(null);
        }

        public void pageActivated(IWorkbenchPage page) {
            if (page != this.activePage) {
                if (this.activePage != null) {
                    this.activePage.removePartListener(ActiveReviewManager.this.editorPartListener);
                }
                if (page != null) {
                    page.addPartListener(ActiveReviewManager.this.editorPartListener);
                    ActiveReviewManager.this.editorPartListener.partActivated((IWorkbenchPart)page.getActiveEditor());
                }
                this.activePage = page;
            }
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            window.removePageListener(ActiveReviewManager.this.pageListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            window.addPageListener(ActiveReviewManager.this.pageListener);
            ActiveReviewManager.this.pageListener.pageActivated(window.getActivePage());
        }
    };

    public ActiveReviewManager() {
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.addPageListener(this.pageListener);
            this.windowListener.windowActivated(activeWorkbenchWindow);
        }
    }

    public void setReview(IReview review) {
        block4: {
            if (this.review == review) break block4;
            this.review = review;
            if (review != null) {
                for (IActiveReviewListener reviewListener : this.reviewListeners) {
                    reviewListener.reviewActivated(review);
                }
            } else {
                for (IActiveReviewListener reviewListener : this.reviewListeners) {
                    reviewListener.reviewDeactivated();
                }
            }
        }
    }

    public void addReviewListener(IActiveReviewListener listener) {
        this.reviewListeners.add(listener);
    }

    public void removeReviewListener(IActiveReviewListener listener) {
        this.reviewListeners.remove(listener);
    }

    public IReview getReview() {
        return this.review;
    }

    public TaskEditor getCurrentPart() {
        return this.currentPart;
    }
}

