/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.RepositoryNotFoundException;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.NotAuthenticatedException;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public class OpenSessionIndication
extends CDOServerIndicationWithMonitoring {
    private String repositoryName;
    private int sessionID;
    private String userID;
    private byte[] oneTimeLoginToken;
    private boolean loginPeek;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode;
    private boolean subscribed;
    private AuthorizableOperation[] operations;
    private InternalRepository repository;
    private InternalSession session;

    public OpenSessionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)1);
    }

    protected boolean closeChannelAfterException() {
        return true;
    }

    @Override
    protected InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    protected InternalSession getSession() {
        return this.session;
    }

    protected int getIndicatingWorkPercent() {
        return 10;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.repositoryName = in.readString();
        this.sessionID = in.readXInt();
        this.userID = in.readString();
        this.oneTimeLoginToken = in.readByteArray();
        this.loginPeek = in.readBoolean();
        this.passiveUpdateEnabled = in.readBoolean();
        this.passiveUpdateMode = (CDOCommonSession.Options.PassiveUpdateMode)in.readEnum(CDOCommonSession.Options.PassiveUpdateMode.class);
        this.lockNotificationMode = (CDOCommonSession.Options.LockNotificationMode)in.readEnum(CDOCommonSession.Options.LockNotificationMode.class);
        this.subscribed = in.readBoolean();
        int size = in.readXInt();
        this.operations = new AuthorizableOperation[size];
        int i = 0;
        while (i < this.operations.length) {
            this.operations[i] = AuthorizableOperation.read((ExtendedDataInput)in);
            ++i;
        }
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            final CDOServerProtocol protocol = this.getProtocol();
            IRepositoryProvider repositoryProvider = protocol.getRepositoryProvider();
            try {
                this.repository = (InternalRepository)repositoryProvider.getRepository(this.repositoryName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.repository == null) {
                throw new RepositoryNotFoundException(this.repositoryName);
            }
            boolean supportingLoginPeeks = this.repository.isSupportingLoginPeeks();
            if (this.loginPeek && !supportingLoginPeeks) {
                out.writeBoolean(true);
                return;
            }
            out.writeBoolean(false);
            try {
                InternalSessionManager sessionManager = this.repository.getSessionManager();
                this.session = sessionManager.openSession((ISessionProtocol)protocol, this.sessionID, s -> {
                    if (s.getUserID() == null && this.userID != null) {
                        s.setUserID(this.userID);
                    }
                    s.setPassiveUpdateEnabled(this.passiveUpdateEnabled);
                    s.setPassiveUpdateMode(this.passiveUpdateMode);
                    s.setLockNotificationMode(this.lockNotificationMode);
                    s.setSubscribed(this.subscribed);
                }, this.oneTimeLoginToken);
            }
            catch (NotAuthenticatedException ex) {
                out.writeXInt(0);
                this.flush();
                protocol.getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        ConcurrencyUtil.sleep((long)500L);
                        protocol.getChannel().close();
                    }
                });
                async.stop();
                monitor.done();
                return;
            }
            protocol.setInfraStructure(this.session);
            out.writeXInt(this.session.getSessionID());
            out.writeString(this.session.getUserID());
            out.writeString(this.repository.getUUID());
            out.writeString(this.repository.getName());
            out.writeEnum((Enum)this.repository.getType());
            out.writeEnum((Enum)this.repository.getState());
            out.writeString(this.repository.getStoreType());
            Set objectIDTypes = this.repository.getObjectIDTypes();
            int types = objectIDTypes.size();
            out.writeXInt(types);
            for (CDOID.ObjectType objectIDType : objectIDTypes) {
                out.writeEnum((Enum)objectIDType);
            }
            out.writeXLong(this.repository.getCreationTime());
            out.writeXLong(this.session.getFirstUpdateTime());
            out.writeXLong(this.session.getOpeningTime());
            out.writeXInt(this.repository.getBranchManager().getTagModCount());
            out.writeCDOID(this.repository.getRootResourceID());
            out.writeBoolean(this.repository.isAuthenticating());
            out.writeBoolean(supportingLoginPeeks);
            out.writeBoolean(this.repository.isSupportingAudits());
            out.writeBoolean(this.repository.isSupportingBranches());
            out.writeBoolean(this.repository.isSupportingUnits());
            out.writeBoolean(this.repository.isSerializingCommits());
            out.writeBoolean(this.repository.isEnsuringReferentialIntegrity());
            out.writeBoolean(this.repository.isAuthorizingOperations());
            out.writeEnum((Enum)this.repository.getIDGenerationLocation());
            out.writeEnum((Enum)this.repository.getCommitInfoStorage());
            String[] authorizations = this.session.authorizeOperations(this.operations);
            int length = authorizations == null ? 0 : authorizations.length;
            out.writeXInt(length);
            int i = 0;
            while (i < length) {
                out.writeString(authorizations[i]);
                ++i;
            }
            InternalCDOPackageUnit[] packageUnits = this.repository.getPackageRegistry(false).getPackageUnits();
            out.writeCDOPackageUnits((CDOPackageUnit[])packageUnits);
            Map clientEntities = this.repository.getClientEntities();
            out.writeVarInt(clientEntities.size());
            for (Entity entity : clientEntities.values()) {
                entity.write((ExtendedDataOutput)out);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    protected void handleRunException(Throwable ex) throws Throwable {
        if (this.loginPeek && (ex instanceof RepositoryNotFoundException || ex instanceof SecurityException)) {
            return;
        }
        super.handleRunException(ex);
    }
}

