/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.web;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.web.AbstractWebGroupProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.swt.graphics.Image;

public class GroupFilterMappingItemProvider
extends AbstractWebGroupProvider {
    private static Image FILTER_MAPPING;

    public GroupFilterMappingItemProvider(WebApp webApp) {
        super((JavaEEObject)webApp);
        this.text = Messages.FILTER_MAPPING_ITEM_PROVIDER;
    }

    @Override
    public List<?> getChildren() {
        if (this.javaee != null) {
            return this.flattenMapping(((WebApp)this.javaee).getFilterMappings());
        }
        return null;
    }

    private List<?> flattenMapping(List<FilterMapping> filterMappings) {
        ArrayList<FilterMappingUIWrapper> result = new ArrayList<FilterMappingUIWrapper>();
        if (filterMappings != null && filterMappings.size() > 0) {
            for (FilterMapping filterMapping : filterMappings) {
                result.addAll(this.getFilterMappingDisplay(filterMapping));
            }
        }
        return result;
    }

    @Override
    public Image getImage() {
        return GroupFilterMappingItemProvider.getFilterMappingImage();
    }

    public static Image getFilterMappingImage() {
        if (FILTER_MAPPING == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage(JEEUIPluginIcons.GROUP_FILTER_MAPPING);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            FILTER_MAPPING = imageDescriptor.createImage();
        }
        return FILTER_MAPPING;
    }

    private List<FilterMappingUIWrapper> getFilterMappingDisplay(FilterMapping element) {
        ArrayList<FilterMappingUIWrapper> result = new ArrayList<FilterMappingUIWrapper>();
        String value = null;
        if (element.getUrlPatterns().size() > 0) {
            for (UrlPatternType pattern : element.getUrlPatterns()) {
                value = pattern.getValue();
                result.add(new FilterMappingUIWrapper(String.valueOf(value) + " -> " + element.getFilterName()));
            }
        }
        return result;
    }

    public class FilterMappingUIWrapper {
        private String value;

        public String getValue() {
            return this.value;
        }

        public FilterMappingUIWrapper(String value) {
            this.value = value;
        }
    }
}

