/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionsMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IDocument document = (IDocument)NullSafetyHelper.lateNonNull();
    private Range range = (Range)NullSafetyHelper.lateNonNull();

    public void initialize(IServiceLocator serviceLocator) {
        ITextEditor editor = UI.getActiveTextEditor();
        if (editor != null) {
            ITextEditor textEditor = editor;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document == null) {
                return;
            }
            this.document = document;
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            try {
                this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), document), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), document));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        item.setText(Messages.computing);
        IDocument document = this.document;
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(NullSafetyHelper.castNonNull(LSPEclipseUtils.toTextDocumentIdentifier(document)));
        params.setRange(this.range);
        params.setContext(context);
        List<CompletableFuture<@Nullable T>> actions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getCodeActionProvider)).computeAll((w, ls) -> ls.getTextDocumentService().codeAction(params).whenComplete((codeActions, t) -> this.scheduleMenuUpdate(menu, item, index, document, (LanguageServerWrapper)w, (Throwable)t, (List<Either<Command, CodeAction>>)codeActions)));
        if (actions.isEmpty()) {
            item.setText(Messages.notImplemented);
            return;
        }
        super.fill(menu, index);
    }

    private void scheduleMenuUpdate(final Menu menu, final MenuItem placeHolder, final int index, final IDocument document, final LanguageServerWrapper wrapper, final @Nullable Throwable ex, final @Nullable List<@Nullable Either<Command, CodeAction>> codeActions) {
        UIJob job = new UIJob(menu.getDisplay(), Messages.updateCodeActions_menu){

            public IStatus runInUIThread(@Nullable IProgressMonitor monitor) {
                if (ex != null) {
                    MenuItem item = new MenuItem(menu, 0, index);
                    item.setText(String.valueOf(ex.getMessage()));
                    item.setImage(LSPImages.getSharedImage("IMG_DEC_FIELD_ERROR"));
                    item.setEnabled(false);
                } else if (codeActions != null) {
                    for (Either command : codeActions) {
                        if (command == null) continue;
                        MenuItem item = new MenuItem(menu, 0, index);
                        final CodeActionCompletionProposal proposal = new CodeActionCompletionProposal((Either<Command, CodeAction>)command, wrapper);
                        item.setText(proposal.getDisplayString());
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                proposal.apply(document);
                            }
                        });
                        item.setEnabled(LSPCodeActionMarkerResolution.canPerform((Either<Command, CodeAction>)command));
                    }
                }
                if (menu.getItemCount() == 1) {
                    placeHolder.setText(Messages.codeActions_emptyMenu);
                } else {
                    placeHolder.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

