/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.collection.Repositories;
import org.eclipse.php.composer.api.repositories.ComposerRepository;
import org.eclipse.php.composer.api.repositories.GitRepository;
import org.eclipse.php.composer.api.repositories.MercurialRepository;
import org.eclipse.php.composer.api.repositories.PackageRepository;
import org.eclipse.php.composer.api.repositories.PearRepository;
import org.eclipse.php.composer.api.repositories.Repository;
import org.eclipse.php.composer.api.repositories.SubversionRepository;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.controller.IController;
import org.eclipse.php.composer.ui.dialogs.RepositoryDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TableSection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.TablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RepositoriesSection
extends TableSection
implements PropertyChangeListener {
    private TableViewer repositoryViewer;
    private IAction addAction;
    private IAction editAction;
    private IAction removeAction;
    private static final int ADD_INDEX = 0;
    private static final int EDIT_INDEX = 1;
    private static final int REMOVE_INDEX = 2;

    public RepositoriesSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{Messages.RepositoriesSection_AddButton, Messages.RepositoriesSection_EditButton, Messages.RepositoriesSection_RemoveButton});
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.RepositoriesSection_Title);
        section.setDescription(Messages.RepositoriesSection_Description);
        section.setLayoutData((Object)new GridData(768));
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        TablePart tablePart = this.getTablePart();
        RepositoriesController repositoriesController = new RepositoriesController();
        this.repositoryViewer = tablePart.getTableViewer();
        this.repositoryViewer.setContentProvider((IContentProvider)repositoriesController);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)repositoriesController);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.repositoryViewer.setInput((Object)this.composerPackage.getRepositories());
        this.composerPackage.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void updateButtons() {
        ISelection selection = this.repositoryViewer.getSelection();
        TablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.enabled);
        tablePart.setButtonEnabled(1, !selection.isEmpty() && this.enabled);
        tablePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.repositoryViewer.getTable().setEnabled(enabled);
    }

    public void refresh() {
        this.repositoryViewer.refresh();
        super.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().startsWith("repositories")) {
            this.refresh();
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.addAction = new Action(Messages.RepositoriesSection_AddActionTitle){

            public void run() {
                RepositoriesSection.this.handleAdd();
            }
        };
        this.editAction = new Action(Messages.RepositoriesSection_EditActionTitle){

            public void run() {
                RepositoriesSection.this.handleEdit();
            }
        };
        this.removeAction = new Action(Messages.RepositoriesSection_RemoveActionTitle){

            public void run() {
                RepositoriesSection.this.handleRemove();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.addAction);
        manager.add(this.editAction);
        manager.add(this.removeAction);
    }

    private void handleAdd() {
        RepositoryDialog diag = new RepositoryDialog(this.repositoryViewer.getTable().getShell());
        if (diag.open() == 0 && diag.getRepository() != null) {
            this.composerPackage.getRepositories().add((Object)diag.getRepository());
        }
    }

    private void handleEdit() {
        Repository repo = (Repository)((StructuredSelection)this.repositoryViewer.getSelection()).getFirstElement();
        RepositoryDialog diag = new RepositoryDialog(this.repositoryViewer.getTable().getShell(), repo.clone());
        if (diag.open() == 0) {
            Repository newRepo = diag.getRepository();
            repo.setName(newRepo.getName());
            repo.setUrl(newRepo.getUrl());
        }
    }

    private void handleRemove() {
        StructuredSelection selection = (StructuredSelection)this.repositoryViewer.getSelection();
        Iterator it = selection.iterator();
        Object[] names = new String[selection.size()];
        ArrayList<Repository> repos = new ArrayList<Repository>();
        int i = 0;
        while (it.hasNext()) {
            Repository repo = (Repository)it.next();
            repos.add(repo);
            names[i] = repo.getName();
            ++i;
        }
        String title = selection.size() > 1 ? Messages.RepositoriesSection_RemoveDialogTitlePlural : Messages.RepositoriesSection_RemoveDialogTitle;
        MessageDialog diag = new MessageDialog(this.repositoryViewer.getTable().getShell(), title, null, NLS.bind((String)Messages.RepositoriesSection_RemoveDialogMessage, (Object)StringUtils.join((Object[])names, (String)", ")), 4, new String[]{Messages.RepositoriesSection_YesButton, Messages.RepositoriesSection_NoButton}, 0);
        if (diag.open() == 0) {
            for (Repository repo : repos) {
                this.composerPackage.getRepositories().remove((Object)repo);
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }

    class RepositoriesController
    extends LabelProvider
    implements IController {
        private Repositories repositories;
        private Map<String, Image> images = new HashMap<String, Image>();
        private Map<String, ImageDescriptor> descriptors = new HashMap<String, ImageDescriptor>(){
            private static final long serialVersionUID = -2019489473873127982L;
            {
                this.put("generic", ComposerUIPluginImages.REPO_GENERIC);
                this.put("git", ComposerUIPluginImages.REPO_GIT);
                this.put("svn", ComposerUIPluginImages.REPO_SVN);
                this.put("mercurial", ComposerUIPluginImages.REPO_MERCURIAL);
                this.put("pear", ComposerUIPluginImages.REPO_PEAR);
                this.put("composer", ComposerUIPluginImages.REPO_COMPOSER);
                this.put("package", ComposerUIPluginImages.REPO_PACKAGE);
            }
        };

        RepositoriesController() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.repositories = (Repositories)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.repositories.toArray();
        }

        public String getText(Object element) {
            if (element instanceof Repository) {
                Repository repo = (Repository)element;
                String name = repo.has("name") ? repo.getAsString("name") : repo.getUrl();
                return name;
            }
            return super.getText(element);
        }

        private Image createImage(String type) {
            if (this.descriptors.containsKey(type)) {
                return this.descriptors.get(type).createImage();
            }
            return null;
        }

        private Image getRepoImage(String type) {
            if (!this.images.containsKey(type)) {
                this.images.put(type, this.createImage(type));
            }
            return this.images.get(type);
        }

        public Image getImage(Object element) {
            if (element instanceof GitRepository) {
                return this.getRepoImage("git");
            }
            if (element instanceof SubversionRepository) {
                return this.getRepoImage("svn");
            }
            if (element instanceof MercurialRepository) {
                return this.getRepoImage("mercurial");
            }
            if (element instanceof PearRepository) {
                return this.getRepoImage("pear");
            }
            if (element instanceof PackageRepository) {
                return this.getRepoImage("package");
            }
            if (element instanceof ComposerRepository) {
                return this.getRepoImage("composer");
            }
            if (element instanceof Repository) {
                return this.getRepoImage("generic");
            }
            return null;
        }
    }
}

