// DO NOT EDIT
// Generated by JFlex 1.9.1 http://jflex.de/
// source: ast_scanner.flex

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php5;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.util.collections.StateStack;

import java_cup.sym;
import java_cup.runtime.Symbol;

//@SuppressWarnings({"unused", "nls"})


@SuppressWarnings("fallthrough")
public class PHPAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_START_HEREDOC = 12;
  public static final int ST_END_HEREDOC = 14;
  public static final int ST_LOOKING_FOR_PROPERTY = 16;
  public static final int ST_LOOKING_FOR_VARNAME = 18;
  public static final int ST_VAR_OFFSET = 20;
  public static final int ST_COMMENT = 22;
  public static final int ST_DOCBLOCK = 24;
  public static final int ST_ONE_LINE_COMMENT = 26;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\37\u0200\1\u0300\266\u0200\10\u0400\40\u0200\u1000\u0500";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\1\4"+
    "\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\11\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\74\1\75\1\76\1\77\1\0\260\65\2\44"+
    "\115\65\1\56\u01aa\65\1\46\325\65\u0100\100\u0100\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[1536];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\10\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\2\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\24\34\1\35\1\36"+
    "\1\37\1\34\1\40\1\41\1\42\1\43\1\44\1\1"+
    "\1\45\3\3\1\46\1\47\1\3\1\1\2\3\1\50"+
    "\1\3\2\1\3\3\2\51\1\3\2\52\1\53\1\54"+
    "\1\55\1\56\1\5\1\57\1\11\1\12\1\14\1\16"+
    "\1\17\1\21\1\22\1\23\2\60\1\25\1\27\1\30"+
    "\1\31\1\32\1\61\1\37\1\62\1\63\1\42\1\64"+
    "\1\4\1\65\3\4\3\66\2\65\1\67\1\0\1\70"+
    "\1\71\1\72\1\0\1\73\3\0\1\74\1\75\1\76"+
    "\1\77\1\100\14\0\1\101\1\102\1\103\1\104\1\105"+
    "\1\106\1\107\1\110\1\111\1\112\2\0\1\113\1\0"+
    "\1\114\1\115\1\72\1\116\1\117\1\120\1\121\1\122"+
    "\3\34\1\123\1\0\6\34\1\124\12\34\1\125\5\34"+
    "\1\126\14\34\1\127\1\34\1\130\1\131\3\0\2\132"+
    "\1\74\1\133\1\134\1\132\1\0\1\135\3\0\2\132"+
    "\3\0\1\1\2\132\1\136\2\0\1\137\2\0\1\140"+
    "\1\0\1\141\1\142\1\0\1\143\1\144\1\0\1\145"+
    "\13\0\1\146\2\0\2\107\2\0\1\147\1\150\1\151"+
    "\1\34\1\152\1\34\1\0\10\34\1\153\10\34\1\154"+
    "\10\34\1\155\10\34\1\156\1\34\1\157\1\160\1\34"+
    "\1\161\5\34\1\0\1\162\1\163\1\1\1\60\13\0"+
    "\1\164\3\0\3\34\1\165\10\34\1\166\1\167\6\34"+
    "\1\170\12\34\1\171\21\34\10\0\1\172\7\0\2\173"+
    "\1\34\1\174\1\175\1\176\1\177\1\200\1\201\5\34"+
    "\1\202\2\34\1\203\3\34\1\204\7\34\1\205\1\206"+
    "\7\34\1\207\1\210\1\211\6\34\1\212\2\213\3\0"+
    "\1\214\4\0\1\215\4\0\4\34\1\216\1\217\1\34"+
    "\1\220\5\34\1\221\6\34\1\222\1\34\1\223\1\224"+
    "\1\225\6\34\1\226\4\0\1\227\2\0\2\34\1\230"+
    "\1\231\4\34\1\232\1\233\2\34\1\234\2\34\1\235"+
    "\1\34\1\236\6\34\1\237\1\240\4\0\1\241\1\242"+
    "\3\34\1\243\1\244\7\34\1\245\2\34\1\246\1\34"+
    "\2\0\2\34\1\247\3\34\1\250\1\251\1\34\1\252"+
    "\3\34\2\0\1\253\1\254\1\255\1\34\1\256\3\34"+
    "\1\257\3\0\4\34\2\0\1\260\1\261\1\262\1\34"+
    "\1\263\2\34\1\264";

  private static int [] zzUnpackAction() {
    int [] result = new int[612];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\u0410\0\u0514\0\u0555\0\u0596"+
    "\0\u05d7\0\u0618\0\u0410\0\u0659\0\u069a\0\u0410\0\u06db\0\u071c"+
    "\0\u075d\0\u079e\0\u07df\0\u0820\0\u0410\0\u0861\0\u08a2\0\u08e3"+
    "\0\u0924\0\u0410\0\u0965\0\u09a6\0\u09e7\0\u0a28\0\u0a69\0\u0aaa"+
    "\0\u0aeb\0\u0b2c\0\u0b6d\0\u0bae\0\u0bef\0\u0c30\0\u0c71\0\u0cb2"+
    "\0\u0cf3\0\u0d34\0\u0d75\0\u0db6\0\u0df7\0\u0e38\0\u0410\0\u0410"+
    "\0\u0e79\0\u0eba\0\u0410\0\u0410\0\u0efb\0\u0410\0\u0410\0\u0f3c"+
    "\0\u0410\0\u0f7d\0\u0fbe\0\u0fff\0\u1040\0\u0410\0\u1081\0\u10c2"+
    "\0\u1103\0\u1144\0\u0410\0\u1185\0\u11c6\0\u1207\0\u1248\0\u1289"+
    "\0\u12ca\0\u0410\0\u130b\0\u134c\0\u0410\0\u138d\0\u13ce\0\u0410"+
    "\0\u140f\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0410\0\u0410\0\u1450\0\u1491\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410\0\u0410"+
    "\0\u0410\0\u14d2\0\u1513\0\u0410\0\u1554\0\u1595\0\u15d6\0\u0410"+
    "\0\u1617\0\u1658\0\u0410\0\u15d6\0\u1699\0\u16da\0\u171b\0\u175c"+
    "\0\u04d3\0\u0410\0\u179d\0\u17de\0\u181f\0\u1860\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u05d7\0\u18a1\0\u0618\0\u18e2\0\u1923\0\u1964"+
    "\0\u19a5\0\u19e6\0\u1a27\0\u1a68\0\u1aa9\0\u1aea\0\u0410\0\u0410"+
    "\0\u0410\0\u0410\0\u0410\0\u0410\0\u1b2b\0\u0410\0\u1b6c\0\u0410"+
    "\0\u1bad\0\u1bee\0\u0410\0\u1c2f\0\u1c70\0\u0410\0\u0410\0\u1cb1"+
    "\0\u0410\0\u0410\0\u1cf2\0\u0410\0\u1d33\0\u1d74\0\u1db5\0\u0b2c"+
    "\0\u1df6\0\u1e37\0\u1e78\0\u1eb9\0\u1efa\0\u1f3b\0\u1f7c\0\u0b2c"+
    "\0\u1fbd\0\u1ffe\0\u203f\0\u2080\0\u20c1\0\u2102\0\u2143\0\u2184"+
    "\0\u21c5\0\u2206\0\u0b2c\0\u2247\0\u2288\0\u22c9\0\u230a\0\u234b"+
    "\0\u0b2c\0\u238c\0\u23cd\0\u240e\0\u244f\0\u2490\0\u24d1\0\u2512"+
    "\0\u2553\0\u2594\0\u25d5\0\u2616\0\u2657\0\u0410\0\u2698\0\u0410"+
    "\0\u0410\0\u26d9\0\u0fbe\0\u271a\0\u0410\0\u26d9\0\u275b\0\u0410"+
    "\0\u0410\0\u271a\0\u279c\0\u0410\0\u27dd\0\u1144\0\u281e\0\u27dd"+
    "\0\u281e\0\u285f\0\u1289\0\u28a0\0\u28e1\0\u285f\0\u28a0\0\u0410"+
    "\0\u130b\0\u2922\0\u0410\0\u134c\0\u2963\0\u0410\0\u29a4\0\u0410"+
    "\0\u0410\0\u15d6\0\u0410\0\u0410\0\u29e5\0\u0410\0\u2a26\0\u2a67"+
    "\0\u2aa8\0\u2ae9\0\u2b2a\0\u2b6b\0\u2bac\0\u2bed\0\u2c2e\0\u2c6f"+
    "\0\u2cb0\0\u2cf1\0\u2d32\0\u2d73\0\u2d73\0\u1bee\0\u2db4\0\u2df5"+
    "\0\u0410\0\u0410\0\u0410\0\u2e36\0\u0b2c\0\u2e77\0\u2eb8\0\u2ef9"+
    "\0\u2f3a\0\u2f7b\0\u2fbc\0\u2ffd\0\u303e\0\u307f\0\u30c0\0\u0b2c"+
    "\0\u3101\0\u3142\0\u3183\0\u31c4\0\u3205\0\u3246\0\u3287\0\u32c8"+
    "\0\u3309\0\u334a\0\u338b\0\u33cc\0\u340d\0\u344e\0\u348f\0\u34d0"+
    "\0\u3511\0\u0b2c\0\u3552\0\u3593\0\u35d4\0\u3615\0\u3656\0\u3697"+
    "\0\u36d8\0\u3719\0\u0b2c\0\u375a\0\u0b2c\0\u0b2c\0\u379b\0\u0b2c"+
    "\0\u37dc\0\u381d\0\u385e\0\u389f\0\u38e0\0\u3921\0\u0410\0\u0410"+
    "\0\u3962\0\u29a4\0\u39a3\0\u39e4\0\u3a25\0\u3a66\0\u3aa7\0\u3ae8"+
    "\0\u3b29\0\u3b6a\0\u3bab\0\u3bec\0\u3c2d\0\u0410\0\u3c6e\0\u3caf"+
    "\0\u3cf0\0\u3d31\0\u3d72\0\u3db3\0\u0b2c\0\u3df4\0\u3e35\0\u3e76"+
    "\0\u3eb7\0\u3ef8\0\u3f39\0\u3f7a\0\u3fbb\0\u0b2c\0\u3ffc\0\u403d"+
    "\0\u407e\0\u40bf\0\u4100\0\u4141\0\u4182\0\u0b2c\0\u41c3\0\u4204"+
    "\0\u4245\0\u4286\0\u42c7\0\u4308\0\u4349\0\u438a\0\u43cb\0\u440c"+
    "\0\u0b2c\0\u444d\0\u448e\0\u44cf\0\u4510\0\u4551\0\u4592\0\u45d3"+
    "\0\u4614\0\u4655\0\u4696\0\u46d7\0\u4718\0\u4759\0\u479a\0\u47db"+
    "\0\u481c\0\u485d\0\u489e\0\u48df\0\u4920\0\u4961\0\u49a2\0\u49e3"+
    "\0\u4a24\0\u4a65\0\u0410\0\u4aa6\0\u4ae7\0\u4b28\0\u4b69\0\u4baa"+
    "\0\u4beb\0\u4c2c\0\u0410\0\u4c6d\0\u4cae\0\u0b2c\0\u0b2c\0\u0b2c"+
    "\0\u0b2c\0\u0b2c\0\u0b2c\0\u4cef\0\u4d30\0\u4d71\0\u4db2\0\u4df3"+
    "\0\u0b2c\0\u4e34\0\u4e75\0\u0b2c\0\u4eb6\0\u4ef7\0\u4f38\0\u0b2c"+
    "\0\u4f79\0\u4fba\0\u4ffb\0\u503c\0\u507d\0\u50be\0\u50ff\0\u0b2c"+
    "\0\u0b2c\0\u5140\0\u5181\0\u51c2\0\u5203\0\u5244\0\u5285\0\u52c6"+
    "\0\u0b2c\0\u0b2c\0\u0b2c\0\u5307\0\u5348\0\u5389\0\u53ca\0\u540b"+
    "\0\u544c\0\u0410\0\u0410\0\u548d\0\u54ce\0\u550f\0\u5550\0\u0410"+
    "\0\u5591\0\u55d2\0\u5613\0\u5654\0\u0410\0\u5695\0\u56d6\0\u5717"+
    "\0\u5758\0\u5799\0\u57da\0\u581b\0\u585c\0\u0b2c\0\u0b2c\0\u589d"+
    "\0\u58de\0\u591f\0\u5960\0\u59a1\0\u59e2\0\u5a23\0\u0b2c\0\u5a64"+
    "\0\u5aa5\0\u5ae6\0\u5b27\0\u5b68\0\u5ba9\0\u0b2c\0\u5bea\0\u0b2c"+
    "\0\u0b2c\0\u0b2c\0\u5c2b\0\u5c6c\0\u5cad\0\u5cee\0\u5d2f\0\u5d70"+
    "\0\u0410\0\u5db1\0\u5df2\0\u5e33\0\u5e74\0\u0410\0\u5eb5\0\u5ef6"+
    "\0\u5f37\0\u5f78\0\u0b2c\0\u0b2c\0\u5fb9\0\u5ffa\0\u603b\0\u607c"+
    "\0\u0b2c\0\u0b2c\0\u60bd\0\u60fe\0\u613f\0\u6180\0\u61c1\0\u0b2c"+
    "\0\u6202\0\u6243\0\u6284\0\u62c5\0\u6306\0\u6347\0\u6388\0\u63c9"+
    "\0\u0410\0\u0410\0\u640a\0\u644b\0\u648c\0\u64cd\0\u0b2c\0\u0b2c"+
    "\0\u650e\0\u654f\0\u6590\0\u0b2c\0\u0b2c\0\u65d1\0\u6612\0\u6653"+
    "\0\u6694\0\u66d5\0\u6716\0\u6757\0\u0b2c\0\u6798\0\u67d9\0\u0b2c"+
    "\0\u681a\0\u685b\0\u689c\0\u68dd\0\u691e\0\u0b2c\0\u695f\0\u69a0"+
    "\0\u69e1\0\u0b2c\0\u0b2c\0\u6a22\0\u0b2c\0\u6a63\0\u6aa4\0\u6ae5"+
    "\0\u6b26\0\u6b67\0\u0b2c\0\u0b2c\0\u0b2c\0\u6ba8\0\u0b2c\0\u6be9"+
    "\0\u6c2a\0\u6c6b\0\u0b2c\0\u6cac\0\u6ced\0\u6d2e\0\u6d6f\0\u6db0"+
    "\0\u6df1\0\u6e32\0\u6e73\0\u6eb4\0\u0b2c\0\u0b2c\0\u0b2c\0\u6ef5"+
    "\0\u0410\0\u6f36\0\u6f77\0\u0b2c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[612];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\27\17\1\20\51\17\1\21\3\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\1\63\2\62\1\64"+
    "\1\62\1\65\1\66\1\67\1\62\1\70\1\71\1\72"+
    "\1\73\1\74\1\75\1\76\2\62\1\77\1\21\1\100"+
    "\1\101\1\102\1\103\1\104\1\105\1\106\1\107\1\62"+
    "\5\110\1\111\1\110\1\112\57\110\1\113\4\110\1\114"+
    "\4\110\12\115\1\116\54\115\1\117\11\115\7\120\1\121"+
    "\57\120\1\122\3\120\1\123\1\124\4\120\2\125\2\126"+
    "\3\125\1\127\57\125\1\130\4\125\1\131\4\125\34\132"+
    "\32\133\4\132\1\133\5\132\1\133\34\21\32\134\4\21"+
    "\1\134\5\21\1\134\20\135\1\136\13\135\32\137\4\135"+
    "\1\137\5\135\1\137\34\140\32\141\4\140\1\141\5\140"+
    "\1\141\1\21\3\142\1\143\1\144\1\142\1\26\1\145"+
    "\1\146\1\142\1\147\1\33\1\150\1\151\1\36\1\152"+
    "\1\153\1\154\1\155\1\156\1\157\1\45\1\160\1\161"+
    "\1\162\1\163\1\52\32\62\1\77\1\142\1\164\1\165"+
    "\1\62\1\166\1\167\1\170\1\171\1\107\1\62\15\172"+
    "\1\173\63\172\3\174\1\175\11\174\1\176\63\174\2\177"+
    "\1\200\1\201\4\177\1\202\20\177\1\203\1\202\45\177"+
    "\1\204\27\17\1\205\61\17\1\206\16\17\1\0\2\17"+
    "\1\207\46\17\102\0\3\22\125\0\1\210\50\0\5\211"+
    "\1\212\1\211\1\213\57\211\1\214\4\211\1\215\4\211"+
    "\34\0\32\216\4\0\1\216\5\0\1\216\30\0\1\217"+
    "\1\220\60\0\1\221\16\0\1\222\50\0\12\223\1\212"+
    "\54\223\1\224\11\223\1\0\1\225\32\0\1\226\1\227"+
    "\1\0\1\230\1\0\1\231\2\0\1\232\5\0\1\233"+
    "\2\0\1\234\1\235\1\0\1\236\50\0\1\237\66\0"+
    "\1\240\11\0\1\241\70\0\1\242\7\0\1\243\1\244"+
    "\72\0\2\245\3\0\1\246\65\0\1\247\4\0\1\25"+
    "\5\0\1\250\71\0\1\245\1\0\2\43\13\0\1\251"+
    "\22\0\1\252\36\0\1\245\1\0\2\43\13\0\1\251"+
    "\65\0\1\253\75\0\1\254\4\0\1\255\1\256\1\257"+
    "\77\0\1\260\1\261\77\0\1\262\1\263\100\0\1\264"+
    "\72\0\2\62\7\0\1\62\1\265\13\62\1\266\3\62"+
    "\1\267\1\270\7\62\4\0\1\62\5\0\1\62\5\0"+
    "\1\24\4\0\1\223\10\0\2\62\2\0\1\271\4\0"+
    "\21\62\1\272\10\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\1\273\12\62\1\274\2\62\1\275\13\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\276\3\62\1\277\5\62\1\300\13\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\2\62\1\301\10\62"+
    "\1\302\1\303\1\304\7\62\1\305\1\62\1\306\2\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\10\62"+
    "\1\307\5\62\1\310\5\62\1\311\5\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\13\62\1\312\16\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\32\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\5\62"+
    "\1\313\6\62\1\314\1\315\4\62\1\316\7\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\10\62\1\317"+
    "\21\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\320\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\21\62\1\321\10\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\21\62\1\322\2\62\1\323"+
    "\5\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\324\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\23\62\1\325\2\62\1\326\3\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\7\62\1\327"+
    "\11\62\1\330\10\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\15\62\1\331\4\62\1\332\7\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\1\333\31\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\7\62"+
    "\1\334\22\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\16\62\1\335\13\62\4\0\1\62\5\0\1\62"+
    "\30\0\1\336\73\0\2\62\7\0\32\62\4\0\1\337"+
    "\5\0\1\62\30\0\1\340\44\0\1\341\3\0\5\110"+
    "\1\0\1\110\1\342\57\110\1\343\4\110\1\344\11\110"+
    "\1\345\1\110\1\346\24\110\32\347\1\110\1\343\2\110"+
    "\1\347\1\110\1\350\3\110\1\347\106\110\1\345\1\110"+
    "\1\351\57\110\1\343\4\110\1\352\4\110\12\115\1\0"+
    "\54\115\1\353\23\115\1\354\54\115\1\354\11\115\7\120"+
    "\1\355\57\120\1\356\3\120\1\0\1\357\13\120\1\360"+
    "\24\120\32\347\1\120\1\356\2\120\1\347\1\345\1\350"+
    "\3\120\1\347\110\120\1\351\57\120\1\356\3\120\1\345"+
    "\1\361\4\120\2\125\2\126\3\125\1\362\57\125\1\363"+
    "\4\125\1\364\6\125\2\126\3\125\1\362\24\125\32\365"+
    "\1\125\1\363\2\125\1\365\1\125\1\364\3\125\1\365"+
    "\2\125\2\126\3\125\1\366\24\125\32\347\1\125\1\363"+
    "\2\125\1\347\1\125\1\350\3\125\1\347\2\125\2\126"+
    "\77\125\2\126\3\125\1\351\57\125\1\363\4\125\1\367"+
    "\4\125\2\0\2\370\17\0\2\371\1\0\1\372\5\0"+
    "\32\371\4\0\1\371\5\0\1\371\2\0\2\373\17\0"+
    "\2\374\1\0\1\375\5\0\32\374\4\0\1\374\5\0"+
    "\1\374\31\0\1\376\72\0\2\137\7\0\32\137\4\0"+
    "\1\137\5\0\1\137\23\0\2\141\7\0\32\141\4\0"+
    "\1\141\5\0\1\141\23\0\2\156\36\0\1\377\40\0"+
    "\2\156\54\0\15\172\1\0\63\172\22\0\1\u0100\60\0"+
    "\1\174\120\0\1\u0101\56\0\2\177\1\200\1\201\4\177"+
    "\1\200\20\177\2\200\45\177\1\u0102\2\0\1\200\127\0"+
    "\1\u0103\47\0\10\17\1\0\16\17\1\0\2\17\1\0"+
    "\46\17\30\0\1\u0104\100\0\1\u0104\22\0\1\u0105\55\0"+
    "\1\u0106\50\0\5\211\1\212\1\211\1\213\24\211\32\0"+
    "\1\211\1\214\2\211\1\0\1\211\1\0\3\211\1\0"+
    "\106\211\1\212\1\211\1\0\57\211\1\214\4\211\1\215"+
    "\4\211\23\0\2\216\7\0\32\216\4\0\1\216\5\0"+
    "\1\216\101\223\55\0\1\u0107\67\0\1\u0108\5\0\1\u0109"+
    "\100\0\1\u010a\75\0\1\u010b\102\0\1\u010c\64\0\1\u010d"+
    "\103\0\1\u010e\117\0\1\u010f\72\0\1\u0110\52\0\2\245"+
    "\13\0\1\251\41\0\3\u0111\11\0\1\u0112\15\0\1\u0113"+
    "\63\0\1\u0114\1\0\1\u0114\2\0\2\u0115\77\0\2\u0116"+
    "\7\0\6\u0116\115\0\1\u0117\51\0\1\u0118\1\u0119\100\0"+
    "\1\u011a\100\0\1\u011b\73\0\2\62\7\0\22\62\1\u011c"+
    "\7\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\3\62\1\u011d\26\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\21\62\1\u011e\10\62\4\0\1\62\5\0"+
    "\1\62\27\0\1\u011f\74\0\2\62\7\0\4\62\1\u0120"+
    "\25\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\22\62\1\u0121\1\u0122\6\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\1\u0123\15\62\1\u0124\13\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\15\62\1\u0125"+
    "\14\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\2\62\1\u0126\2\62\1\u0127\24\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\4\62\1\u0128\25\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\7\62\1\u0129"+
    "\22\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\22\62\1\u012a\7\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\17\62\1\u012b\12\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\3\62\1\u012c\26\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\1\u012d\31\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\10\62"+
    "\1\u012e\12\62\1\u012f\6\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\15\62\1\u0130\14\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\21\62\1\u0131\10\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\15\62"+
    "\1\u0132\14\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\16\62\1\u0133\13\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\17\62\1\u0134\12\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\2\62\1\u0135\17\62"+
    "\1\u0136\1\u0137\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\22\62\1\u0138\7\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\22\62\1\u0139\7\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\26\62\1\u013a"+
    "\3\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\10\62\1\u013b\5\62\1\u013c\13\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\1\62\1\u013d\30\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\20\62\1\u013e"+
    "\2\62\1\u013f\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\1\u0140\31\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\10\62\1\u0141\21\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\21\62\1\u0142\10\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\30\62"+
    "\1\u0143\1\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\22\62\1\u0144\7\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\4\62\1\u0145\25\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\21\62\1\u0146\10\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\10\62"+
    "\1\u0147\21\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\21\62\1\u0148\10\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\2\62\1\u0149\2\62\1\u014a\1\62"+
    "\1\u014b\3\62\1\u014c\1\u014d\15\62\4\0\1\62\5\0"+
    "\1\62\5\110\1\345\1\110\1\346\24\110\32\0\1\110"+
    "\1\343\2\110\1\0\1\110\1\0\3\110\1\0\5\110"+
    "\1\345\1\110\1\0\57\110\1\343\4\110\1\352\4\110"+
    "\20\0\1\u014e\2\0\2\347\7\0\32\347\1\u014f\3\0"+
    "\1\347\5\0\1\347\12\115\1\0\54\115\1\0\11\115"+
    "\7\120\1\360\24\120\32\0\1\120\1\356\2\120\1\0"+
    "\1\345\1\0\3\120\1\0\7\120\1\0\57\120\1\356"+
    "\3\120\1\345\1\361\4\120\2\125\2\126\3\125\1\366"+
    "\24\125\32\0\1\125\1\363\2\125\1\0\1\125\1\0"+
    "\3\125\1\0\2\125\2\126\3\125\1\0\57\125\1\363"+
    "\4\125\1\367\6\125\2\u0150\3\125\1\362\13\125\2\365"+
    "\1\125\1\u0151\5\125\32\365\1\125\1\363\2\125\1\365"+
    "\1\125\1\364\3\125\1\365\2\0\2\370\77\0\2\373"+
    "\120\0\2\u0152\7\0\6\u0152\102\0\1\u0153\112\0\1\u0154"+
    "\74\0\1\u0155\101\0\1\u0156\106\0\1\u0157\72\0\1\u0158"+
    "\105\0\1\u0159\66\0\1\u015a\67\0\1\u015b\121\0\1\u015c"+
    "\101\0\1\u015d\23\0\3\u0111\27\0\1\u0113\67\0\1\u015e"+
    "\137\0\1\u015f\42\0\2\u0115\112\0\1\u0160\43\0\1\u0118"+
    "\32\0\32\u0161\4\0\1\u0161\5\0\1\u0161\23\0\2\62"+
    "\7\0\23\62\1\u0162\6\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\1\u0163\31\62\4\0\1\62\5\0"+
    "\1\62\27\0\1\u0118\74\0\2\62\7\0\1\u0164\31\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\u0165\25\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\2\62\1\u0166\27\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\22\62\1\u0167\7\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\15\62\1\u0168\14\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\22\62"+
    "\1\u0169\1\u016a\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\13\62\1\u016b\16\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\1\u016c\7\62\1\u016d\21\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\16\62"+
    "\1\u016e\13\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\4\62\1\u016f\25\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\23\62\1\u0170\6\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\3\62\1\u0171\1\62"+
    "\1\u0172\2\62\1\u0173\11\62\1\u0174\3\62\1\u0175\3\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\13\62"+
    "\1\u0176\16\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\23\62\1\u0128\6\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\4\62\1\u0177\25\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\1\u0178\31\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\4\62\1\u0179"+
    "\25\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\2\62\1\u017a\27\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\1\62\1\u017b\30\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\13\62\1\u017c\16\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\13\62\1\u017d"+
    "\16\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\23\62\1\u017e\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u017f\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\4\62\1\u0180\25\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u0181"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\15\62\1\u0182\7\62\1\u0183\4\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\23\62\1\u0184\6\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\13\62\1\u0185"+
    "\16\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\24\62\1\u0186\5\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\24\62\1\u0187\5\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\23\62\1\u0188\6\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u0189"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\16\62\1\u018a\13\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u018b\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\13\62\1\u018c\16\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\13\62\1\u018d"+
    "\16\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\10\62\1\u018e\13\62\1\u018f\5\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\1\u0190\31\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\10\62\1\u0191\21\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\u0192\25\62\4\0\1\62\5\0\1\62\31\0\1\u0193"+
    "\47\0\2\125\2\u0150\3\125\1\362\57\125\1\363\4\125"+
    "\1\364\4\125\53\0\1\u0194\61\0\1\u0195\100\0\1\u0196"+
    "\113\0\1\u0197\66\0\1\u0198\77\0\1\u0199\45\0\1\u019a"+
    "\12\0\1\u019b\23\0\1\u019c\100\0\1\u019d\107\0\1\u019e"+
    "\75\0\1\u019f\74\0\1\u01a0\74\0\1\u01a1\121\0\1\u01a2"+
    "\25\0\1\u01a3\1\u01a4\17\0\2\u0161\7\0\32\u0161\4\0"+
    "\1\u0161\5\0\1\u0161\23\0\2\62\7\0\21\62\1\u01a5"+
    "\10\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\30\62\1\u01a6\1\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\12\62\1\u01a7\17\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\7\62\1\u01a8\22\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\22\62\1\u01a9"+
    "\7\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\u01aa\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\23\62\1\u01ab\6\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\10\62\1\u01ac\21\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\1\u01ad\31\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\24\62"+
    "\1\u01ae\5\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\15\62\1\u01af\14\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\10\62\1\u01b0\21\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\30\62\1\u01b1\1\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\u01b2\25\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\16\62\1\u01b3\13\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\5\62\1\u01b4\24\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\26\62\1\u01b5\3\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\7\62"+
    "\1\u01b6\22\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\15\62\1\u01b7\14\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\13\62\1\u01b8\16\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\1\u01b9\31\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u01ba"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\1\u01bb\31\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\4\62\1\u01bc\25\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\24\62\1\u01bd\5\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\1\u01be\31\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\21\62\1\u01bf"+
    "\10\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\23\62\1\u01c0\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\23\62\1\u01c1\6\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\1\u01c2\31\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\4\62\1\u01c3\25\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\10\62"+
    "\1\u01c4\21\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\10\62\1\u01c5\21\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\21\62\1\u01c6\10\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\10\62\1\u01c7\21\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\2\62"+
    "\1\u01c8\27\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\26\62\1\u01c9\3\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\23\62\1\u01ca\6\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\4\62\1\u01cb\25\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\1\u01cc"+
    "\31\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\13\62\1\u01cd\16\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\15\62\1\u01ce\14\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\13\62\1\u01cf\16\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\15\62\1\u01d0"+
    "\14\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\23\62\1\u01d1\6\62\4\0\1\62\5\0\1\62\34\0"+
    "\32\u01d2\4\0\1\u01d2\5\0\1\u01d2\1\0\2\u01d3\1\u01d4"+
    "\161\0\1\u01d5\71\0\1\u01d6\24\0\1\u01d7\12\0\1\u01d8"+
    "\23\0\1\u01d9\107\0\1\u01da\110\0\1\u019e\22\0\1\u019a"+
    "\12\0\1\u019b\126\0\1\u01db\74\0\1\u01dc\43\0\1\u019e"+
    "\12\0\1\u01dd\135\0\1\u01de\106\0\1\u01df\76\0\1\u01e0"+
    "\67\0\1\u01e1\36\0\1\u01a3\121\0\2\62\7\0\1\u01e2"+
    "\31\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\15\62\1\u01e3\14\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\21\62\1\u01e4\10\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\13\62\1\u01e5\16\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\4\62\1\u01e6"+
    "\25\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\5\62\1\u01e7\24\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\2\62\1\u01e8\27\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\21\62\1\u01e9\10\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\10\62\1\u01ea"+
    "\21\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\10\62\1\u01eb\21\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\3\62\1\u01ec\26\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\2\62\1\u01ed\27\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\10\62\1\u01ee"+
    "\21\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\13\62\1\u01ef\16\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\14\62\1\u01f0\15\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\3\62\1\u01f1\26\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\15\62\1\u01f2"+
    "\14\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\5\62\1\u01f3\24\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\23\62\1\u01f4\6\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\2\62\1\u01f5\27\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\2\62\1\u01f6"+
    "\27\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\21\62\1\u01f7\10\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\15\62\1\u01f8\14\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\2\62\1\u01f9\27\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\7\62\1\u01fa"+
    "\22\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\22\62\1\u01fb\7\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u01fc\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\2\62\1\u01fd\27\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u01fe"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\u01ff\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\7\62\1\u0200\22\62\4\0\1\62\5\0"+
    "\1\62\2\0\1\u01d3\77\0\1\u01d5\12\0\1\u0201\150\0"+
    "\1\u0202\15\0\1\u01d7\12\0\1\u01d8\120\0\1\u0203\104\0"+
    "\1\u019e\100\0\1\u0204\117\0\1\u0205\63\0\1\u0202\37\0"+
    "\1\u01df\12\0\1\u0206\65\0\3\u0207\150\0\1\u0208\50\0"+
    "\2\62\7\0\2\62\1\u0209\27\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\24\62\1\u020a\5\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\4\62\1\u020b"+
    "\25\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\23\62\1\u020c\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\13\62\1\u020d\16\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\4\62\1\u020e\25\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u020f"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\13\62\1\u0210\16\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\22\62\1\u0211\7\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\7\62\1\u0212\22\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\16\62\1\u0213"+
    "\13\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\u0214\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u0215\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\2\62\1\u0216\27\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\1\u0217\31\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\u0218\25\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\23\62\1\u0219\6\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\4\62\1\u021a\25\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\22\62\1\u021b\7\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\32\62"+
    "\4\0\1\u021c\5\0\1\62\23\0\2\62\7\0\23\62"+
    "\1\u021d\6\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\32\62\4\0\1\u021e\5\0\1\62\23\0\2\62"+
    "\7\0\32\62\4\0\1\u021f\5\0\1\62\23\0\2\62"+
    "\7\0\16\62\1\u0220\13\62\4\0\1\62\5\0\1\62"+
    "\1\0\1\u0202\12\0\1\u0221\135\0\1\u01d7\104\0\1\u019a"+
    "\24\0\1\u0205\12\0\1\u0222\65\0\3\u0207\3\0\1\u0223"+
    "\24\0\32\u0224\1\u0225\1\0\1\u0225\1\0\1\u0224\2\0"+
    "\1\u0225\2\0\1\u0224\57\0\1\u0226\44\0\2\62\7\0"+
    "\23\62\1\u0227\6\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u0228\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\1\u0229\31\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\1\u022a\31\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\2\62\1\u022b"+
    "\27\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\4\62\1\u022c\25\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\15\62\1\u022d\14\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\15\62\1\u022e\14\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\32\62\4\0"+
    "\1\u022f\5\0\1\62\23\0\2\62\7\0\4\62\1\u0230"+
    "\25\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\2\62\1\u0231\27\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\4\62\1\u0232\25\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\32\62\4\0\1\u0233\5\0"+
    "\1\62\23\0\2\62\7\0\32\62\4\0\1\u0234\5\0"+
    "\1\62\23\0\2\62\7\0\32\62\4\0\1\u0235\5\0"+
    "\1\62\23\0\2\62\7\0\10\62\1\u0236\21\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\2\62\1\u0237"+
    "\27\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\32\62\4\0\1\u0238\5\0\1\62\23\0\2\62\7\0"+
    "\3\62\1\u0239\26\62\4\0\1\62\5\0\1\62\34\0"+
    "\32\u023a\4\0\1\u023a\5\0\1\u023a\1\0\3\u023b\17\0"+
    "\2\u0224\7\0\32\u0224\1\u0225\1\0\1\u0225\1\0\1\u0224"+
    "\2\0\1\u0225\2\0\1\u0224\1\0\3\u023b\30\0\32\u0224"+
    "\1\u0225\1\0\1\u0225\1\0\1\u0224\2\0\1\u0225\2\0"+
    "\1\u0224\1\0\3\u0226\25\0\1\264\72\0\2\62\7\0"+
    "\21\62\1\u023c\10\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\2\62\1\u023d\27\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\7\62\1\u023e\22\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\23\62\1\u023f"+
    "\6\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\16\62\1\u0240\13\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\16\62\1\u0241\13\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\4\62\1\u0242\25\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\3\62\1\u0243"+
    "\26\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\16\62\1\u0244\13\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\32\62\4\0\1\u0245\5\0\1\62\23\0"+
    "\2\62\7\0\16\62\1\u0246\13\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\16\62\1\u0247\13\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\32\62\4\0"+
    "\1\u0248\5\0\1\62\1\0\3\u0249\17\0\2\u023a\7\0"+
    "\32\u023a\4\0\1\u023a\5\0\1\u023a\1\0\3\u023b\3\0"+
    "\1\u024a\114\0\2\62\7\0\4\62\1\u024b\25\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\7\62\1\u024c"+
    "\22\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\22\62\1\u024d\7\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\15\62\1\u024e\14\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\5\62\1\u024f\24\62\4\0"+
    "\1\62\5\0\1\62\23\0\2\62\7\0\15\62\1\u0250"+
    "\14\62\4\0\1\62\5\0\1\62\23\0\2\62\7\0"+
    "\15\62\1\u0251\14\62\4\0\1\62\5\0\1\62\23\0"+
    "\2\62\7\0\14\62\1\u0252\15\62\4\0\1\62\5\0"+
    "\1\62\23\0\2\62\7\0\32\62\4\0\1\u0253\5\0"+
    "\1\62\1\0\3\u0249\30\0\32\u0254\1\u0255\1\0\1\u0255"+
    "\1\0\1\u0254\2\0\1\u0255\2\0\1\u0254\34\0\32\u0256"+
    "\4\0\1\u0256\5\0\1\u0256\23\0\2\62\7\0\2\62"+
    "\1\u0257\27\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\2\62\1\u0258\27\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\32\62\4\0\1\u0259\5\0\1\62"+
    "\23\0\2\62\7\0\17\62\1\u025a\12\62\4\0\1\62"+
    "\5\0\1\62\1\0\3\u025b\11\0\1\u025c\5\0\2\u0254"+
    "\7\0\32\u0254\1\u0255\1\0\1\u0255\1\0\1\u0254\2\0"+
    "\1\u0255\2\0\1\u0254\1\0\3\u025b\11\0\1\u025c\16\0"+
    "\32\u0254\1\u0255\1\0\1\u0255\1\0\1\u0254\2\0\1\u0255"+
    "\2\0\1\u0254\1\0\3\u025b\11\0\1\u025c\5\0\2\u0256"+
    "\7\0\32\u0256\4\0\1\u0256\5\0\1\u0256\23\0\2\62"+
    "\7\0\4\62\1\u025d\25\62\4\0\1\62\5\0\1\62"+
    "\23\0\2\62\7\0\4\62\1\u025e\25\62\4\0\1\62"+
    "\5\0\1\62\23\0\2\62\7\0\32\62\4\0\1\u025f"+
    "\5\0\1\62\23\0\2\62\7\0\10\62\1\u0260\21\62"+
    "\4\0\1\62\5\0\1\62\1\0\3\u025b\11\0\1\u025c"+
    "\105\0\1\u0261\101\0\2\62\7\0\13\62\1\u0262\16\62"+
    "\4\0\1\62\5\0\1\62\23\0\2\62\7\0\4\62"+
    "\1\u0263\25\62\4\0\1\62\5\0\1\62\23\0\2\62"+
    "\7\0\21\62\1\u0264\10\62\4\0\1\62\5\0\1\62";

  private static int [] zzUnpacktrans() {
    int [] result = new int[28600];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\10\0\2\1\1\11\3\1\1\11\5\1"+
    "\1\11\2\1\1\11\6\1\1\11\4\1\1\11\24\1"+
    "\2\11\2\1\2\11\1\1\2\11\1\1\1\11\4\1"+
    "\1\11\4\1\1\11\6\1\1\11\2\1\1\11\2\1"+
    "\1\11\1\1\13\11\2\1\13\11\2\1\1\11\3\1"+
    "\1\11\2\1\1\11\1\1\1\0\3\1\1\0\1\11"+
    "\3\0\1\1\4\11\14\0\6\11\1\1\1\11\1\1"+
    "\1\11\2\0\1\11\1\0\1\1\2\11\1\1\2\11"+
    "\1\1\1\11\4\1\1\0\44\1\1\11\1\1\2\11"+
    "\3\0\1\11\2\1\2\11\1\1\1\0\1\11\3\0"+
    "\2\1\3\0\3\1\1\11\2\0\1\11\2\0\1\11"+
    "\1\0\2\11\1\0\2\11\1\0\1\11\13\0\1\1"+
    "\2\0\2\1\2\0\3\11\3\1\1\0\56\1\1\0"+
    "\2\11\2\1\13\0\1\11\3\0\61\1\10\0\1\11"+
    "\7\0\1\11\56\1\2\11\1\1\3\0\1\11\4\0"+
    "\1\11\4\0\37\1\1\11\4\0\1\11\2\0\30\1"+
    "\2\11\4\0\23\1\2\0\15\1\2\0\11\1\3\0"+
    "\4\1\2\0\4\1\1\11\3\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[612];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList<Object> commentList = new LinkedList<>();
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=514632
	// stores nested HEREDOC ids
	private final Stack<String> heredocIds = new Stack<>();
	private boolean asp_tags = false;
	private boolean short_tags_allowed = true;
	// XXX: "heredocIds" and "stack" are never reset
	private final StateStack stack = new StateStack();
	protected int commentStartPosition;

	private AST ast;

	public void setAST(AST ast) {
		this.ast = ast;
	}

	@Override
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5;
	}

	@Override
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	@Override
	public void resetCommentList() {
		commentList.clear();
	}

	/**
	 * Will only be filled when ast != null
	 */
	@Override
	public LinkedList<Object> getCommentList() {
		return commentList;
	}

	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}

	@Override
	public void setUseAspTagsAsPHP(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	@Override
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

	private void pushState(int state) {
		stack.pushStack(zzLexicalState);
		yybegin(state);
	}

	private void popState() {
		yybegin(stack.popStack());
	}

	@Override
	public int getCurrentLine() {
		return yyline;
	}

	protected int getTokenStartPosition() {
		return zzStartRead - _zzPushbackPos;
	}

	protected int getTokenLength() {
		return zzMarkedPos - zzStartRead;
	}

	@Override
	public int getLength() {
		return zzEndRead - _zzPushbackPos;
	}

	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
		addComment(Comment.TYPE_SINGLE_LINE);
	}

	private void handleMultilineCommentEnd() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
	}

	protected void handleVarComment() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private Symbol createFullSymbol(int symbolNumber) {
		Symbol symbol = createSymbol(symbolNumber);
		symbol.value = yytext();
		return symbol;
	}

	protected Symbol createSymbol(int symbolNumber) {
		int leftPosition = getTokenStartPosition();
		return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
	}

	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 *
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that underlying lexer was unavailable)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if (documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParameters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParameters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private boolean useOldString = false;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    if (useOldString) {
      String saveOldString = oldString;
      oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
      if (saveOldString != null) {
        oldString = saveOldString + oldString;
      }
    }

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    String saveOldString = oldString;
    oldString = null;

    /* first: make room (if you can) */
    if (zzRefill()) {
      oldString = saveOldString;
      return YYEOF;
    }

    oldString = saveOldString;

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      _zzPushbackPos = 0;
      startPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      oldString = null;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          { 	return createSymbol(sym.EOF);
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 181: break;
          case 2:
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          // fall through
          case 182: break;
          case 3:
            { // do nothing
            }
          // fall through
          case 183: break;
          case 4:
            { 
            }
          // fall through
          case 184: break;
          case 5:
            { return createSymbol(ParserConstants.T_NOT);
            }
          // fall through
          case 185: break;
          case 6:
            { yybegin(ST_DOUBLE_QUOTES);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 186: break;
          case 7:
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
	// yymore();
            }
          // fall through
          case 187: break;
          case 8:
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          // fall through
          case 188: break;
          case 9:
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          // fall through
          case 189: break;
          case 10:
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          // fall through
          case 190: break;
          case 11:
            { yybegin(ST_SINGLE_QUOTE);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 191: break;
          case 12:
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          // fall through
          case 192: break;
          case 13:
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          // fall through
          case 193: break;
          case 14:
            { return createSymbol(ParserConstants.T_TIMES);
            }
          // fall through
          case 194: break;
          case 15:
            { return createSymbol(ParserConstants.T_PLUS);
            }
          // fall through
          case 195: break;
          case 16:
            { return createSymbol(ParserConstants.T_COMMA);
            }
          // fall through
          case 196: break;
          case 17:
            { return createSymbol(ParserConstants.T_MINUS);
            }
          // fall through
          case 197: break;
          case 18:
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          // fall through
          case 198: break;
          case 19:
            { return createSymbol(ParserConstants.T_DIV);
            }
          // fall through
          case 199: break;
          case 20:
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          // fall through
          case 200: break;
          case 21:
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          // fall through
          case 201: break;
          case 22:
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          // fall through
          case 202: break;
          case 23:
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          // fall through
          case 203: break;
          case 24:
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          // fall through
          case 204: break;
          case 25:
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          // fall through
          case 205: break;
          case 26:
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          // fall through
          case 206: break;
          case 27:
            { return createSymbol(ParserConstants.T_AT);
            }
          // fall through
          case 207: break;
          case 28:
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 208: break;
          case 29:
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          // fall through
          case 209: break;
          case 30:
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 210: break;
          case 31:
            { return createSymbol(ParserConstants.T_KOVA);
            }
          // fall through
          case 211: break;
          case 32:
            { yybegin(ST_BACKQUOTE);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 212: break;
          case 33:
            { pushState(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 213: break;
          case 34:
            { return createSymbol(ParserConstants.T_OR);
            }
          // fall through
          case 214: break;
          case 35:
            { if (!stack.isEmpty()) {
		popState();
	}
	return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 215: break;
          case 36:
            { return createSymbol(ParserConstants.T_TILDA);
            }
          // fall through
          case 216: break;
          case 37:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 217: break;
          case 38:
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 218: break;
          case 39:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 219: break;
          case 40:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 220: break;
          case 41:
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          // fall through
          case 221: break;
          case 42:
            { yypushback(1);
	popState();
            }
          // fall through
          case 222: break;
          case 43:
            { popState();
	return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 223: break;
          case 44:
            { yypushback(1);
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 224: break;
          case 45:
            { yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          // fall through
          case 225: break;
          case 46:
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 226: break;
          case 47:
            { return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 227: break;
          case 48:
            { /* treat numbers (almost) as strings inside encapsulated strings */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          // fall through
          case 228: break;
          case 49:
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 229: break;
          case 50:
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 230: break;
          case 51:
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 231: break;
          case 52:
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 232: break;
          case 53:
            { // yymore();
            }
          // fall through
          case 233: break;
          case 54:
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
	// yymore();
            }
          // fall through
          case 234: break;
          case 55:
            { System.out.print(yytext());
            }
          // fall through
          case 235: break;
          case 56:
            { if (asp_tags) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 236: break;
          case 57:
            { if (short_tags_allowed) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 237: break;
          case 58:
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          // fall through
          case 238: break;
          case 59:
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          // fall through
          case 239: break;
          case 60:
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 240: break;
          case 61:
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          // fall through
          case 241: break;
          case 62:
            { if (asp_tags) {
		yybegin(YYINITIAL);
		return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 242: break;
          case 63:
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          // fall through
          case 243: break;
          case 64:
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          // fall through
          case 244: break;
          case 65:
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          // fall through
          case 245: break;
          case 66:
            { return createSymbol(ParserConstants.T_INC);
            }
          // fall through
          case 246: break;
          case 67:
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          // fall through
          case 247: break;
          case 68:
            { return createSymbol(ParserConstants.T_DEC);
            }
          // fall through
          case 248: break;
          case 69:
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          // fall through
          case 249: break;
          case 70:
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 250: break;
          case 71:
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          // fall through
          case 251: break;
          case 72:
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          // fall through
          case 252: break;
          case 73:
            { handleCommentStart();
	yybegin(ST_COMMENT);
            }
          // fall through
          case 253: break;
          case 74:
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          // fall through
          case 254: break;
          case 75:
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          // fall through
          case 255: break;
          case 76:
            { return createSymbol(ParserConstants.T_SL);
            }
          // fall through
          case 256: break;
          case 77:
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          // fall through
          case 257: break;
          case 78:
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          // fall through
          case 258: break;
          case 79:
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          // fall through
          case 259: break;
          case 80:
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          // fall through
          case 260: break;
          case 81:
            { return createSymbol(ParserConstants.T_SR);
            }
          // fall through
          case 261: break;
          case 82:
            { yybegin(YYINITIAL);
	return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
            }
          // fall through
          case 262: break;
          case 83:
            { return createSymbol(ParserConstants.T_AS);
            }
          // fall through
          case 263: break;
          case 84:
            { return createSymbol(ParserConstants.T_DO);
            }
          // fall through
          case 264: break;
          case 85:
            { return createSymbol(ParserConstants.T_IF);
            }
          // fall through
          case 265: break;
          case 86:
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          // fall through
          case 266: break;
          case 87:
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          // fall through
          case 267: break;
          case 88:
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          // fall through
          case 268: break;
          case 89:
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          // fall through
          case 269: break;
          case 90:
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 270: break;
          case 91:
            { pushState(ST_LOOKING_FOR_VARNAME);
	return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          // fall through
          case 271: break;
          case 92:
            { pushState(ST_IN_SCRIPTING);
	yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          // fall through
          case 272: break;
          case 93:
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          // fall through
          case 273: break;
          case 94:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String heredoc = heredocIds.peek();
	if (yytext.equals(heredoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_HEREDOC);
	}
            }
          // fall through
          case 274: break;
          case 95:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		nb_pushback = 2;
	} else {
		nb_pushback = 1;
	}
	yypushback(nb_pushback);
	heredocIds.pop();
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          // fall through
          case 275: break;
          case 96:
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 276: break;
          case 97:
            { handleMultilineCommentEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 277: break;
          case 98:
            { handlePHPDocEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 278: break;
          case 99:
            { if (asp_tags || yytext().charAt(0) != '%') { /* asp comment? */
		handleLineCommentEnd();
		yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          // fall through
          case 279: break;
          case 100:
            { String yytext = yytext();
	if ((yytext.charAt(1) == '%' && asp_tags)
		|| (yytext.charAt(1) == '?' && short_tags_allowed)) {
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 280: break;
          case 101:
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          // fall through
          case 281: break;
          case 102:
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          // fall through
          case 282: break;
          case 103:
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          // fall through
          case 283: break;
          case 104:
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          // fall through
          case 284: break;
          case 105:
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          // fall through
          case 285: break;
          case 106:
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          // fall through
          case 286: break;
          case 107:
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          // fall through
          case 287: break;
          case 108:
            { return createSymbol(ParserConstants.T_FOR);
            }
          // fall through
          case 288: break;
          case 109:
            { return createSymbol(ParserConstants.T_NEW);
            }
          // fall through
          case 289: break;
          case 110:
            { return createSymbol(ParserConstants.T_TRY);
            }
          // fall through
          case 290: break;
          case 111:
            { return createSymbol(ParserConstants.T_USE);
            }
          // fall through
          case 291: break;
          case 112:
            { return createSymbol(ParserConstants.T_VAR);
            }
          // fall through
          case 292: break;
          case 113:
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          // fall through
          case 293: break;
          case 114:
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 294: break;
          case 115:
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		char c = yytext.charAt(textLength - heredocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += heredocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          // fall through
          case 295: break;
          case 116:
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          // fall through
          case 296: break;
          case 117:
            { return createSymbol(ParserConstants.T_CASE);
            }
          // fall through
          case 297: break;
          case 118:
            { return createSymbol(ParserConstants.T_ECHO);
            }
          // fall through
          case 298: break;
          case 119:
            { return createSymbol(ParserConstants.T_ELSE);
            }
          // fall through
          case 299: break;
          case 120:
            { return createSymbol(ParserConstants.T_EVAL);
            }
          // fall through
          case 300: break;
          case 121:
            { return createSymbol(ParserConstants.T_LIST);
            }
          // fall through
          case 301: break;
          case 122:
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          // fall through
          case 302: break;
          case 123:
            { String yytext = yytext();
	int removeChars = (yytext.charAt(0) == 'b') ? 4 : 3;
	yytext = yytext.substring(removeChars).trim();    // for 'b<<<' or '<<<'
	heredocIds.push(yytext);
	yybegin(ST_START_HEREDOC);
	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);
	sym.value = yytext;
	return sym;
            }
          // fall through
          case 303: break;
          case 124:
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          // fall through
          case 304: break;
          case 125:
            { return createSymbol(ParserConstants.T_BREAK);
            }
          // fall through
          case 305: break;
          case 126:
            { return createSymbol(ParserConstants.T_CATCH);
            }
          // fall through
          case 306: break;
          case 127:
            { return createSymbol(ParserConstants.T_CLASS);
            }
          // fall through
          case 307: break;
          case 128:
            { return createSymbol(ParserConstants.T_CLONE);
            }
          // fall through
          case 308: break;
          case 129:
            { return createSymbol(ParserConstants.T_CONST);
            }
          // fall through
          case 309: break;
          case 130:
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          // fall through
          case 310: break;
          case 131:
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          // fall through
          case 311: break;
          case 132:
            { return createSymbol(ParserConstants.T_FINAL);
            }
          // fall through
          case 312: break;
          case 133:
            { return createSymbol(ParserConstants.T_ISSET);
            }
          // fall through
          case 313: break;
          case 134:
            { return createSymbol(ParserConstants.T_PRINT);
            }
          // fall through
          case 314: break;
          case 135:
            { return createSymbol(ParserConstants.T_THROW);
            }
          // fall through
          case 315: break;
          case 136:
            { return createSymbol(ParserConstants.T_UNSET);
            }
          // fall through
          case 316: break;
          case 137:
            { return createSymbol(ParserConstants.T_WHILE);
            }
          // fall through
          case 317: break;
          case 138:
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 318: break;
          case 139:
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          // fall through
          case 319: break;
          case 140:
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          // fall through
          case 320: break;
          case 141:
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          // fall through
          case 321: break;
          case 142:
            { /* not a keyword, used to recognize constants.*/
	return createFullSymbol(ParserConstants.T_DEFINE);
            }
          // fall through
          case 322: break;
          case 143:
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          // fall through
          case 323: break;
          case 144:
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          // fall through
          case 324: break;
          case 145:
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          // fall through
          case 325: break;
          case 146:
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          // fall through
          case 326: break;
          case 147:
            { return createSymbol(ParserConstants.T_RETURN);
            }
          // fall through
          case 327: break;
          case 148:
            { return createSymbol(ParserConstants.T_STATIC);
            }
          // fall through
          case 328: break;
          case 149:
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          // fall through
          case 329: break;
          case 150:
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          // fall through
          case 330: break;
          case 151:
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          // fall through
          case 331: break;
          case 152:
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          // fall through
          case 332: break;
          case 153:
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          // fall through
          case 333: break;
          case 154:
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          // fall through
          case 334: break;
          case 155:
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          // fall through
          case 335: break;
          case 156:
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          // fall through
          case 336: break;
          case 157:
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          // fall through
          case 337: break;
          case 158:
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          // fall through
          case 338: break;
          case 159:
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          // fall through
          case 339: break;
          case 160:
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          // fall through
          case 340: break;
          case 161:
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          // fall through
          case 341: break;
          case 162:
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          // fall through
          case 342: break;
          case 163:
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          // fall through
          case 343: break;
          case 164:
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          // fall through
          case 344: break;
          case 165:
            { return createSymbol(ParserConstants.T_FILE);
            }
          // fall through
          case 345: break;
          case 166:
            { return createSymbol(ParserConstants.T_LINE);
            }
          // fall through
          case 346: break;
          case 167:
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          // fall through
          case 347: break;
          case 168:
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          // fall through
          case 348: break;
          case 169:
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          // fall through
          case 349: break;
          case 170:
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          // fall through
          case 350: break;
          case 171:
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          // fall through
          case 351: break;
          case 172:
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          // fall through
          case 352: break;
          case 173:
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          // fall through
          case 353: break;
          case 174:
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          // fall through
          case 354: break;
          case 175:
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          // fall through
          case 355: break;
          case 176:
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          // fall through
          case 356: break;
          case 177:
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          // fall through
          case 357: break;
          case 178:
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          // fall through
          case 358: break;
          case 179:
            { handleCommentStart();
	handleVarComment();
	//return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          // fall through
          case 359: break;
          case 180:
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          // fall through
          case 360: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String[] argv) {
    if (argv.length == 0) {
      System.out.println("Usage : java PHPAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PHPAstLexer scanner = null;
        java.io.FileInputStream stream = null;
        java.io.Reader reader = null;
        try {
          stream = new java.io.FileInputStream(argv[i]);
          reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PHPAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
        finally {
          if (reader != null) {
            try {
              reader.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
          if (stream != null) {
            try {
              stream.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
        }
      }
    }
  }


}
