/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.ImageProvider;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DefaultImageProvider
implements ImageProvider {
    private IEditorRegistry editorRegistry = null;

    @Override
    public Image getImage(IFSTreeNode node) {
        if (node.isFileSystem()) {
            return UIPlugin.getImage("Root");
        }
        if (node.isRootDirectory()) {
            return UIPlugin.getImage("RootDrive");
        }
        if (node.isDirectory()) {
            return UIPlugin.getImage("Folder");
        }
        if (node.isFile()) {
            return this.getPredefinedImage(node);
        }
        return null;
    }

    protected Image getPredefinedImage(IFSTreeNode node) {
        String key = node.getName();
        Image image = UIPlugin.getImage(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getEditorRegistry().getImageDescriptor(key);
            if (descriptor == null) {
                descriptor = this.getEditorRegistry().getSystemExternalEditorImageDescriptor(key);
            }
            if (descriptor != null) {
                UIPlugin.getDefault().getImageRegistry().put(key, descriptor);
            }
            image = UIPlugin.getImage(key);
        }
        return image;
    }

    private IEditorRegistry getEditorRegistry() {
        IWorkbench workbench;
        if (this.editorRegistry == null && (workbench = PlatformUI.getWorkbench()) != null) {
            this.editorRegistry = workbench.getEditorRegistry();
        }
        return this.editorRegistry;
    }
}

