/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.BuildInterpreterDescriptor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IInterpreterComboBlockContext;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractInterpreterContainerWizardPage
extends WizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension {
    private IBuildpathEntry fSelection;
    private AbstractInterpreterComboBlock fInterpreterBlock;
    private IScriptProject scriptProject;
    private IBuildpathEntry[] currentEntries;

    public AbstractInterpreterContainerWizardPage() {
        super(InterpretersMessages.InterpreterContainerWizardPage_Interpreter_System_Library_1);
    }

    public boolean finish() {
        IStatus status = this.fInterpreterBlock.getStatus();
        if (!status.isOK()) {
            return false;
        }
        this.fSelection = this.fInterpreterBlock.getEntry();
        return true;
    }

    public IBuildpathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IBuildpathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            if (this.fSelection == null) {
                this.fInterpreterBlock.setUseDefaultInterpreter();
            } else {
                this.fInterpreterBlock.setPath(this.fSelection.getPath());
            }
            IStatus status = this.fInterpreterBlock.getStatus();
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                try {
                    Boolean b;
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                    if (handler != null && (b = (Boolean)handler.handleStatus(status, (Object)this)).booleanValue()) {
                        this.fInterpreterBlock.refreshInterpreters();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    protected AbstractInterpreterComboBlock createInterpreterBlock(IInterpreterComboBlockContext context) {
        return new AbstractInterpreterComboBlock(context);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        IInterpreterComboBlockContext context = this.createInterpreterBlockHost();
        this.fInterpreterBlock = this.createInterpreterBlock(context);
        this.fInterpreterBlock.setDefaultInterpreterDescriptor(new BuildInterpreterDescriptor(context));
        this.fInterpreterBlock.setTitle(InterpretersMessages.InterpreterContainerWizardPage_3);
        this.fInterpreterBlock.createControl(composite);
        this.setControl((Control)composite);
        this.fInterpreterBlock.addPropertyChangeListener(event -> {
            IStatus status = this.fInterpreterBlock.getStatus();
            if (status.isOK()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(status.getMessage());
            }
        });
        this.setTitle(InterpretersMessages.InterpreterContainerWizardPage_Interpreter_System_Library_1);
        this.setMessage(InterpretersMessages.InterpreterContainerWizardPage_Select_the_Interpreter_used_to_build_this_project__4);
        this.initializeFromSelection();
    }

    private IInterpreterComboBlockContext createInterpreterBlockHost() {
        return new IInterpreterComboBlockContext(){

            @Override
            public int getMode() {
                return 0;
            }

            @Override
            public IEnvironment getEnvironment() {
                return EnvironmentManager.getEnvironment((IModelElement)AbstractInterpreterContainerWizardPage.this.getScriptProject());
            }

            @Override
            public String getNatureId() {
                return AbstractInterpreterContainerWizardPage.this.getScriptNature();
            }
        };
    }

    public Image getImage() {
        return ScriptDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.scriptProject = project;
        this.currentEntries = currentEntries;
    }

    public IScriptProject getScriptProject() {
        return this.scriptProject;
    }

    public IBuildpathEntry[] getCurrentEntries() {
        return this.currentEntries;
    }

    public abstract String getScriptNature();
}

