/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.adt.ui.corext.doc.SingleCharReader;

public class AtlCodeReader
extends SingleCharReader {
    public static final int EOF = -1;
    private IDocument document;
    private int end = -1;
    private boolean forward = false;
    private int offset;
    private boolean skipComments = false;
    private boolean skipStrings = false;

    @Override
    public void close() throws IOException {
        this.document = null;
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipComments, boolean skipStrings) {
        this.document = document;
        this.offset = offset;
        this.skipComments = skipComments;
        this.skipStrings = skipStrings;
        this.forward = false;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipComments, boolean skipStrings) {
        this.document = document;
        this.offset = offset;
        this.skipComments = skipComments;
        this.skipStrings = skipStrings;
        this.forward = true;
        this.end = Math.min(this.document.getLength(), this.offset + length);
    }

    public int getOffset() {
        return this.forward ? this.offset - 1 : this.offset;
    }

    private void gotoEndOfLine() throws BadLocationException {
        this.offset = this.document.getLineOffset(this.document.getLineOfOffset(this.offset) + 1);
    }

    private void gotoEndOfString() throws BadLocationException {
        while (this.offset < this.end) {
            char current;
            if ((current = this.document.getChar(this.offset++)) == '\\') {
                ++this.offset;
                continue;
            }
            if (current != '\'') continue;
            return;
        }
    }

    private boolean isCommentLine() throws BadLocationException {
        int i = 0;
        while (this.document.getChar(this.document.getLineOffset(this.document.getLineOfOffset(this.offset)) + i) == '\t') {
            ++i;
        }
        char firstLineChar = this.document.getChar(this.document.getLineOffset(this.document.getLineOfOffset(this.offset)) + i);
        char secondLineChar = this.document.getChar(this.document.getLineOffset(this.document.getLineOfOffset(this.offset)) + i + 1);
        return firstLineChar == '-' && secondLineChar == '-';
    }

    private void gotoStartOfLine() throws BadLocationException {
        this.offset = this.document.getLineOffset(this.document.getLineOfOffset(this.offset) - 1);
    }

    private void gotoStartOfString() throws BadLocationException {
        while (--this.offset > 0) {
            char current = this.document.getChar(this.offset);
            if (current != '\'' || this.offset >= 0 && this.document.getChar(this.offset - 1) == '\\') continue;
            return;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.forward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int readBackwards() throws BadLocationException {
        block4: while (this.offset > 0) {
            char current = this.document.getChar(--this.offset);
            switch (current) {
                case '\n': {
                    if (!this.skipComments || !this.isCommentLine()) break;
                    this.gotoStartOfLine();
                    continue block4;
                }
                case '\'': {
                    if (!this.skipStrings) break;
                    this.gotoStartOfString();
                    continue block4;
                }
            }
            return current;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int readForwards() throws BadLocationException {
        block4: while (this.offset < this.end) {
            char current = this.document.getChar(this.offset++);
            switch (current) {
                case '-': {
                    char next = this.document.getChar(this.offset);
                    if (!this.skipComments || this.offset >= this.end || next != '-') break;
                    this.gotoEndOfLine();
                    continue block4;
                }
                case '\'': {
                    if (!this.skipStrings) break;
                    this.gotoEndOfString();
                    continue block4;
                }
            }
            return current;
        }
        return -1;
    }
}

