/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import io.nayuki.deflate.InflaterInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.util.MessageUtil;

public class GZIPInputStream2
extends FilterInputStream {
    private static final int FLG_FHCRC = 2;
    private static final int FLG_FCOMMENT = 16;
    private static final int FLG_FNAME = 8;
    private static final int FLG_FEXTRA = 4;
    InputStream is;
    long uncompressedLen;
    long uncompressedLocationAtHeader;
    CRC32 crc;
    String comment;
    String filename;
    long mark;
    long reset;
    boolean eof;

    public GZIPInputStream2(GZIPInputStream2 gs) throws IOException {
        super(new InflaterInputStream((InflaterInputStream)gs.in));
        this.is = gs.is;
        this.crc = gs.crc.clone();
        this.uncompressedLen = gs.uncompressedLen;
        this.uncompressedLocationAtHeader = gs.uncompressedLocationAtHeader;
        this.mark = gs.mark;
        this.reset = gs.reset;
        this.eof = gs.eof;
    }

    public GZIPInputStream2(InputStream is) throws IOException {
        super(new InflaterInputStream(is, false));
        this.is = is;
        this.crc = new CRC32();
        this.readHeader(is);
    }

    private InputStream readHeader(InputStream is) throws IOException {
        int b0 = is.read();
        return this.readHeader(is, b0);
    }

    private InputStream readHeader(InputStream is, int b0) throws IOException {
        int b;
        this.uncompressedLocationAtHeader += this.uncompressedLen;
        this.uncompressedLen = 0L;
        this.crc.reset();
        this.crc.update(b0);
        if (b0 != 31) {
            throw new ZipException(Messages.GZIPInputStream2_NotAGzip);
        }
        int b1 = is.read();
        this.crc.update(b1);
        if (b1 != 139) {
            throw new ZipException(Messages.GZIPInputStream2_NotAGzip);
        }
        int b2 = is.read();
        this.crc.update(b2);
        if (b2 != 8) {
            throw new ZipException(Messages.GZIPInputStream2_NotDeflate);
        }
        int b3 = is.read();
        if (b3 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b3);
        if ((b3 & 0xE0) != 0) {
            throw new ZipException(Messages.GZIPInputStream2_BadHeaderFlag);
        }
        int b4 = is.read();
        if (b4 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b4);
        int b5 = is.read();
        if (b5 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b5);
        int b6 = is.read();
        if (b6 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b6);
        int b7 = is.read();
        if (b7 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b7);
        int mtime = b4 & 0xFF | (b5 & 0xFF) << 8 | (b6 & 0xFF) << 16 | (b7 & 0xFF) << 24;
        long mjtime = (long)mtime * 1000L;
        int b8 = is.read();
        if (b8 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b8);
        int b9 = is.read();
        if (b9 < 0) {
            throw new ZipException(Messages.GZIPInputStream2_TruncatedHeader);
        }
        this.crc.update(b9);
        if ((b3 & 4) != 0) {
            int l1 = is.read();
            if (l1 < 0) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
            this.crc.update(l1);
            int l2 = is.read();
            if (l2 < 0) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
            this.crc.update(l2);
            int l = (l2 & 0xFF) << 8 | l1 & 0xFF;
            byte[] b10 = new byte[l];
            int r = is.read(b10);
            if (r < l) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedExtra);
            }
            this.crc.update(b10);
        }
        if ((b3 & 8) != 0) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((b = is.read()) != 0) {
                if (b == -1) {
                    throw new ZipException(Messages.GZIPInputStream2_TruncatedName);
                }
                this.crc.update(b);
                bos.write(b);
            }
            this.crc.update(0);
            this.filename = new String(bos.toByteArray(), StandardCharsets.ISO_8859_1);
        }
        if ((b3 & 0x10) != 0) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((b = is.read()) != 0) {
                if (b == -1) {
                    throw new ZipException(Messages.GZIPInputStream2_TruncatedComment);
                }
                this.crc.update(b);
                bos.write(b);
            }
            this.crc.update(0);
            this.comment = new String(bos.toByteArray(), StandardCharsets.ISO_8859_1);
        }
        if ((b3 & 2) != 0) {
            int c0 = is.read();
            if (c0 == -1) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedHeaderCRC);
            }
            int c1 = is.read();
            if (c1 == -1) {
                throw new ZipException(Messages.GZIPInputStream2_TruncatedHeaderCRC);
            }
            int crcv = c0 & 0xFF | (c1 & 0xFF) << 8;
            if ((this.crc.getValue() & 0xFFFFL) != (long)crcv) {
                throw new ZipException(MessageUtil.format((String)Messages.GZIPInputStream2_BadHeaderCRC, (Object[])new Object[]{Integer.toHexString(crcv), Integer.toHexString((int)(this.crc.getValue() & 0xFFFFL))}));
            }
        }
        this.crc.reset();
        return is;
    }

    @Override
    public int read() throws IOException {
        int r;
        do {
            if ((r = super.read()) != -1) continue;
            if (this.eof) break;
            ((InflaterInputStream)this.in).detach();
            this.checkTrailer(this.in);
            int b0 = this.in.read();
            if (b0 <= 0) {
                this.eof = true;
                break;
            }
            this.readHeader(this.in, b0);
            ((InflaterInputStream)this.in).attach();
        } while (r < 0);
        if (r >= 0) {
            if (this.uncompressedLocationAtHeader + this.uncompressedLen >= this.reset) {
                this.crc.update(r);
            }
            ++this.uncompressedLen;
        }
        return r;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int r;
        do {
            if ((r = super.read(buf, off, len)) != -1) continue;
            if (this.eof) break;
            ((InflaterInputStream)this.in).detach();
            this.checkTrailer(this.in);
            int b0 = this.in.read();
            if (b0 <= 0) {
                this.eof = true;
                break;
            }
            this.readHeader(this.in, b0);
            ((InflaterInputStream)this.in).attach();
            r = 0;
        } while (r <= 0 && len != 0);
        if (r != -1) {
            if (this.uncompressedLocationAtHeader + this.uncompressedLen >= this.reset) {
                this.crc.update(buf, off, r);
            } else if (this.uncompressedLocationAtHeader + this.uncompressedLen + (long)r >= this.reset) {
                int d = (int)(this.reset - (this.uncompressedLocationAtHeader + this.uncompressedLen));
                this.crc.update(buf, off + d, r - d);
            }
            this.uncompressedLen += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r;
        long skipped = 0L;
        if (n <= 0L) {
            return 0L;
        }
        if (this.uncompressedLocationAtHeader + this.uncompressedLen < this.reset) {
            long toSkip = Math.min(n, this.reset - (this.uncompressedLocationAtHeader + this.uncompressedLen));
            while (toSkip > 0L) {
                r = this.in.skip(toSkip);
                if (r == 0L) break;
                toSkip -= r;
                n -= r;
                skipped += r;
                this.uncompressedLen += r;
            }
        }
        byte[] buf = null;
        while (n > 0L) {
            int toskip = (int)Math.min(n, 16384L);
            if (buf == null) {
                buf = new byte[toskip];
            }
            if ((r = (long)this.read(buf, 0, toskip)) == -1L) break;
            skipped += r;
            n -= r;
            if (r < (long)toskip) break;
        }
        return skipped;
    }

    void checkTrailer(InputStream is) throws IOException {
        int b0 = is.read();
        if (b0 < 0) {
            throw new EOFException();
        }
        int b1 = is.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = is.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        int b3 = is.read();
        if (b3 < 0) {
            throw new EOFException();
        }
        long crc32 = (long)(b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16) | ((long)b3 & 0xFFL) << 24;
        long crc32v = this.crc.getValue();
        if (crc32v != crc32) {
            throw new ZipException(MessageUtil.format((String)Messages.GZIPInputStream2_BadTrailerCRC, (Object[])new Object[]{Integer.toHexString((int)crc32), Integer.toHexString((int)crc32v)}));
        }
        int b4 = is.read();
        if (b4 < 0) {
            throw new EOFException();
        }
        int b5 = is.read();
        if (b5 < 0) {
            throw new EOFException();
        }
        int b6 = is.read();
        if (b6 < 0) {
            throw new EOFException();
        }
        int b7 = is.read();
        if (b7 < 0) {
            throw new EOFException();
        }
        long len32 = (long)(b4 & 0xFF | (b5 & 0xFF) << 8 | (b6 & 0xFF) << 16) | ((long)b7 & 0xFFL) << 24;
        if (len32 != (this.uncompressedLen & 0xFFFFFFFFL)) {
            throw new ZipException(MessageUtil.format((String)Messages.GZIPInputStream2_BadTrailerLength, (Object[])new Object[]{Integer.toHexString((int)len32), Long.toHexString(this.uncompressedLen)}));
        }
    }

    public String comment() {
        return this.comment;
    }

    public String filename() {
        return this.filename;
    }

    @Override
    public void mark(int limit) {
        super.mark(limit);
        this.mark = this.uncompressedLocationAtHeader + this.uncompressedLen;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.reset = Math.max(this.reset, this.uncompressedLocationAtHeader + this.uncompressedLen);
        this.uncompressedLen = this.mark - this.uncompressedLocationAtHeader;
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    public String toString() {
        return this.getClass() + " " + (this.uncompressedLocationAtHeader + this.uncompressedLen) + " " + this.in;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private static class CRC32
    implements Cloneable {
        int value;
        private static final int[] table = new int[256];

        static {
            int i = 0;
            while (i < 256) {
                int v = i;
                int j = 0;
                while (j < 8) {
                    v = (v & 1) != 0 ? 0xEDB88320 ^ v >>> 1 : (v >>>= 1);
                    ++j;
                }
                CRC32.table[i] = v;
                ++i;
            }
        }

        public CRC32() {
            this.reset();
        }

        public CRC32 clone() {
            CRC32 c = new CRC32();
            c.value = this.value;
            return c;
        }

        public void reset() {
            this.value = -1;
        }

        public void update(int b) {
            this.value = table[(this.value ^ b & 0xFF) & 0xFF] ^ this.value >>> 8;
        }

        public void update(byte[] b, int offset, int len) {
            int i = 0;
            while (i < len) {
                this.update(b[offset + i]);
                ++i;
            }
        }

        public void update(byte[] b) {
            this.update(b, 0, b.length);
        }

        public long getValue() {
            return (long)(~this.value) & 0xFFFFFFFFL;
        }
    }
}

