/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.strategy;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategyManager;
import org.osgi.service.prefs.BackingStoreException;

public class StrategyManager
implements IStrategyManager {
    public static final String PRIORITY_KEY = "priority";
    public static final String IS_ACTIVE_KEY = "isActive";
    public static final String DEFAULT_STRATEGY_KEY = "defaultStrategy";
    protected String EXTENSION_ID = "";
    protected SortedMap<Integer, List<IStrategy>> allAvailableStrategies;
    protected Map<IStrategy, Boolean> activeStrategies;
    protected Map<Set<IStrategy>, IStrategy> defaultStrategies;
    protected IPreferenceStore preferences;
    public static final StrategyManager instance = new StrategyManager();

    protected StrategyManager(String extensionId) {
        this.EXTENSION_ID = extensionId;
        this.allAvailableStrategies = new TreeMap<Integer, List<IStrategy>>();
        this.activeStrategies = new HashMap<IStrategy, Boolean>();
        this.defaultStrategies = new HashMap<Set<IStrategy>, IStrategy>();
        this.preferences = Activator.getInstance().getPreferenceStore();
        this.init();
    }

    protected StrategyManager() {
        this.allAvailableStrategies = new TreeMap<Integer, List<IStrategy>>();
        this.activeStrategies = new HashMap<IStrategy, Boolean>();
        this.defaultStrategies = new HashMap<Set<IStrategy>, IStrategy>();
        this.preferences = Activator.getInstance().getPreferenceStore();
        this.init();
    }

    protected void init() {
        this.initStrategies();
        this.initActiveStrategies();
        this.initDefaultPreferences();
        this.initDefaultDropStrategies();
    }

    protected void initStrategies() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(this.EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                if ("strategy".equals(e.getName())) {
                    IStrategy strategy = (IStrategy)e.createExecutableExtension("strategy");
                    int priority = this.findPriority(strategy);
                    this.getStrategies(priority).add(strategy);
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + String.valueOf(e.getContributor()) + " contributed an invalid extension for " + this.EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
    }

    private void initActiveStrategies() {
        for (List<IStrategy> strategies : this.allAvailableStrategies.values()) {
            for (IStrategy strategy : strategies) {
                this.activeStrategies.put(strategy, this.isActive(strategy));
            }
        }
    }

    private void initDefaultPreferences() {
        for (Collection collection : this.allAvailableStrategies.values()) {
            for (IStrategy strategy : collection) {
                this.preferences.setDefault(StrategyManager.getPriorityKey(strategy), strategy.getPriority());
                this.preferences.setDefault(StrategyManager.getIsActiveKey(strategy), true);
            }
        }
    }

    private void initDefaultDropStrategies() {
        try {
            String[] stringArray = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.common").keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.endsWith(DEFAULT_STRATEGY_KEY)) {
                    this.parseDefaultDropStrategy(key);
                }
                ++n2;
            }
        }
        catch (BackingStoreException ex) {
            Activator.log.error("Could not initialize the default Drag & Drop strategy choices", (Throwable)ex);
        }
    }

    public IStrategy findStrategy(String id) {
        for (IStrategy strategy : this.getAllStrategies()) {
            if (!strategy.getID().equals(id)) continue;
            return strategy;
        }
        return null;
    }

    private void parseDefaultDropStrategy(String key) {
        String[] strategyIds = key.substring(0, key.lastIndexOf(":")).split(":");
        HashSet<IStrategy> strategies = new HashSet<IStrategy>();
        String[] stringArray = strategyIds;
        int n = strategyIds.length;
        int n2 = 0;
        while (n2 < n) {
            String strategyId = stringArray[n2];
            IStrategy strategy = this.findStrategy(strategyId);
            if (strategy == null) {
                return;
            }
            strategies.add(strategy);
            ++n2;
        }
        if (strategies.size() > 1) {
            this.defaultStrategies.put(strategies, this.findStrategy(this.preferences.getString(key)));
        }
    }

    private List<IStrategy> getStrategies(int priority) {
        if (!this.allAvailableStrategies.containsKey(priority)) {
            this.allAvailableStrategies.put(priority, new LinkedList());
        }
        return (List)this.allAvailableStrategies.get(priority);
    }

    public List<IStrategy> getActiveStrategies() {
        LinkedList<IStrategy> orderedActiveStrategies = new LinkedList<IStrategy>();
        for (List<IStrategy> strategies : this.allAvailableStrategies.values()) {
            for (IStrategy strategy : strategies) {
                if (!this.isActive(strategy)) continue;
                orderedActiveStrategies.add(strategy);
            }
        }
        return orderedActiveStrategies;
    }

    @Deprecated
    public Map<Integer, List<IStrategy>> getAllAvailableStrategies() {
        return this.allAvailableStrategies;
    }

    public static String getPriorityKey(IStrategy strategy) {
        return strategy.getID() + ".priority";
    }

    public static String getIsActiveKey(IStrategy strategy) {
        return strategy.getID() + ".isActive";
    }

    public static String getDefaultStrategyKey(Collection<IStrategy> conflict) {
        LinkedList<IStrategy> orderedStrategies = new LinkedList<IStrategy>(conflict);
        Collections.sort(orderedStrategies, new Comparator<IStrategy>(){

            @Override
            public int compare(IStrategy strategy1, IStrategy strategy2) {
                return Collator.getInstance().compare(strategy1.getID(), strategy2.getID());
            }
        });
        Object key = "";
        for (IStrategy strategy : conflict) {
            key = (String)key + strategy.getID() + ":";
        }
        key = (String)key + DEFAULT_STRATEGY_KEY;
        return key;
    }

    @Override
    public int findPriority(IStrategy strategy) {
        String preferenceKey = StrategyManager.getPriorityKey(strategy);
        if (this.preferences.contains(preferenceKey)) {
            return this.preferences.getInt(preferenceKey);
        }
        return strategy.getPriority();
    }

    @Override
    public boolean isActive(IStrategy strategy) {
        String preferenceKey = StrategyManager.getIsActiveKey(strategy);
        if (this.preferences.contains(preferenceKey)) {
            return this.preferences.getBoolean(preferenceKey);
        }
        return true;
    }

    @Override
    public void setActive(IStrategy strategy, boolean active) {
        this.preferences.setValue(StrategyManager.getIsActiveKey(strategy), active);
        this.activeStrategies.put(strategy, active);
    }

    @Override
    public void setPriority(IStrategy strategy, int priority) {
        this.getStrategies(this.findPriority(strategy)).remove(strategy);
        this.preferences.setValue(StrategyManager.getPriorityKey(strategy), priority);
        this.getStrategies(priority).add(strategy);
    }

    @Override
    public List<IStrategy> getAllStrategies() {
        LinkedList<IStrategy> result = new LinkedList<IStrategy>();
        for (List<IStrategy> strategies : this.allAvailableStrategies.values()) {
            result.addAll(strategies);
        }
        return result;
    }

    @Override
    public void restoreDefaults() {
        try {
            IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.common");
            preferenceStore.clear();
            preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.activeStrategies.clear();
        this.allAvailableStrategies.clear();
        this.defaultStrategies.clear();
        this.initStrategies();
        this.initActiveStrategies();
        this.initDefaultDropStrategies();
    }

    public IStrategy getDefaultDropStrategy(Collection<IStrategy> strategies) {
        IStrategy defaultStrategy;
        if (strategies.isEmpty()) {
            return null;
        }
        if (strategies.size() == 1) {
            defaultStrategy = strategies.iterator().next();
        } else {
            HashSet<IStrategy> conflictingStrategies = new HashSet<IStrategy>(strategies);
            defaultStrategy = this.defaultStrategies.get(conflictingStrategies);
        }
        if (defaultStrategy == null) {
            return null;
        }
        return this.isActive(defaultStrategy) ? defaultStrategy : null;
    }

    public void setDefaultDropStrategy(Collection<IStrategy> conflictingStrategies, IStrategy defaultStrategy) {
        if (conflictingStrategies.size() < 2) {
            return;
        }
        HashSet<IStrategy> conflict = new HashSet<IStrategy>(conflictingStrategies);
        this.defaultStrategies.put(conflict, defaultStrategy);
        this.preferences.putValue(StrategyManager.getDefaultStrategyKey(conflict), defaultStrategy.getID());
        IEclipsePreferences preferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.common");
        try {
            preferenceStore.flush();
        }
        catch (BackingStoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public List<IStrategy> getAllActiveStrategies() {
        ArrayList<IStrategy> res = new ArrayList<IStrategy>();
        List<IStrategy> allStrategies = this.getAllStrategies();
        for (IStrategy iStrategy : allStrategies) {
            if (!this.isActive(iStrategy)) continue;
            res.add(iStrategy);
        }
        return res;
    }
}

