/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class StateMachineExternalSourceToRepresentationDropBehaviorProvider
implements IExternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public DnDStatus drop(EObject droppedElement, EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (DnDStatus)new StateMachineInsideRepresentationBehaviorProviderSwitch(target).doSwitch(droppedElement);
    }

    static class StateMachineInsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<DnDStatus> {
        private final EObject newSemanticContainer;

        StateMachineInsideRepresentationBehaviorProviderSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public DnDStatus caseComment(Comment comment) {
            if (this.newSemanticContainer instanceof Region || this.newSemanticContainer instanceof StateMachine || this.newSemanticContainer instanceof State) {
                return DnDStatus.createNothingStatus(Set.of(comment));
            }
            return (DnDStatus)super.caseComment(comment);
        }

        public DnDStatus caseRegion(Region region) {
            if (this.newSemanticContainer instanceof State || this.newSemanticContainer instanceof StateMachine) {
                return DnDStatus.createNothingStatus(Set.of(region));
            }
            return (DnDStatus)super.caseRegion(region);
        }

        public DnDStatus caseState(State state) {
            if (this.newSemanticContainer instanceof Region) {
                return DnDStatus.createNothingStatus(Set.of(state));
            }
            return (DnDStatus)super.caseState(state);
        }

        public DnDStatus casePseudostate(Pseudostate pseudostate) {
            DnDStatus result = null;
            if (pseudostate.getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL) || pseudostate.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL)) {
                if (this.newSemanticContainer instanceof Region || this.newSemanticContainer instanceof StateMachine || this.newSemanticContainer instanceof State) {
                    result = DnDStatus.createNothingStatus(Set.of(pseudostate));
                }
            } else {
                result = this.newSemanticContainer instanceof Region ? DnDStatus.createNothingStatus(Set.of(pseudostate)) : (DnDStatus)super.casePseudostate(pseudostate);
            }
            return result;
        }

        public DnDStatus defaultCase(EObject object) {
            return DnDStatus.createFailingStatus("DnD is forbidden.", Collections.emptySet());
        }
    }
}

