/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCreateChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CreateArguments;
import org.eclipse.ltk.core.refactoring.participants.CreateParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileCreateProcessor
extends RefactoringProcessor {
    public static final String PROCESSOR_ID = "org.eclipse.datatools.connectivity.ui.createProcessor";
    private String mNewProfileName;
    private String mNewProfileDescription;
    private String mNewProfileProviderID;
    private Properties mNewProfileProperties;
    private String mNewProfileParentProfile;
    private boolean mNewProfileAutoConnect;
    private Shell mShell;

    public ConnectionProfileCreateProcessor(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect, Shell shell) {
        this.mNewProfileName = name;
        this.mNewProfileDescription = description;
        this.mNewProfileProviderID = providerID;
        this.mNewProfileProperties = baseProperties;
        this.mNewProfileParentProfile = parentProfile;
        this.mNewProfileAutoConnect = autoConnect;
        this.mShell = shell;
    }

    public Object[] getElements() {
        return new Object[]{this.mNewProfileName};
    }

    public String getIdentifier() {
        return PROCESSOR_ID;
    }

    public String getProcessorName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCreateChange.name"), this.mNewProfileName);
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(new String());
        change.markAsSynthetic();
        ConnectionProfileCreateChange createchange = new ConnectionProfileCreateChange(this.mNewProfileName, this.mNewProfileDescription, this.mNewProfileProviderID, this.mNewProfileProperties, this.mNewProfileParentProfile, this.mNewProfileAutoConnect, this.mShell);
        change.add((Change)createchange);
        return change;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<CreateParticipant> participants = new ArrayList<CreateParticipant>();
        participants.addAll(Arrays.asList(ParticipantManager.loadCreateParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.mNewProfileName, (CreateArguments)new CreateArguments(), (String[])new String[0], (SharableParticipants)sharedParticipants)));
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }
}

