/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulExtendedCommandContext;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.SimpleThreadFactory;
import org.eclipse.jpt.common.utility.internal.command.AbstractAsynchronousCommandContext;
import org.eclipse.jpt.common.utility.internal.command.DefaultExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.SimpleStatefulExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.SynchronizingCommand;

public class AsynchronousExtendedCommandContext
extends AbstractAsynchronousCommandContext<StatefulExtendedCommandContext>
implements StatefulExtendedCommandContext {
    public AsynchronousExtendedCommandContext(ExceptionHandler exceptionHandler) {
        this(null, exceptionHandler);
    }

    public AsynchronousExtendedCommandContext(String threadName, ExceptionHandler exceptionHandler) {
        this(new SimpleStatefulExtendedCommandContext(DefaultExtendedCommandContext.instance()), SimpleThreadFactory.instance(), threadName, exceptionHandler);
    }

    public AsynchronousExtendedCommandContext(StatefulExtendedCommandContext commandContext, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        super(commandContext, threadFactory, threadName, exceptionHandler);
    }

    public AsynchronousExtendedCommandContext(Config config) {
        super(config);
    }

    @Override
    public void waitToExecute(Command command) throws InterruptedException {
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            syncCommand.waitForExecution();
            ((StatefulExtendedCommandContext)this.commandContext).waitToExecute(command);
        }
        finally {
            syncCommand.release();
        }
    }

    @Override
    public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitToExecute(command);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            if (syncCommand.waitForExecution(timeout)) {
                timeout = stop - System.currentTimeMillis();
                boolean bl = timeout > 0L && ((StatefulExtendedCommandContext)this.commandContext).waitToExecute(command, timeout);
                return bl;
            }
            return false;
        }
        finally {
            syncCommand.release();
        }
    }

    public static interface Config
    extends AbstractAsynchronousCommandContext.Config<StatefulExtendedCommandContext> {
    }

    public static class SimpleConfig
    extends AbstractAsynchronousCommandContext.SimpleConfig<StatefulExtendedCommandContext>
    implements Config {
        public SimpleConfig() {
        }

        public SimpleConfig(StatefulExtendedCommandContext commandContext, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
            super(commandContext, threadFactory, threadName, exceptionHandler);
        }

        @Override
        protected StatefulExtendedCommandContext buildDefaultCommandContext() {
            return new SimpleStatefulExtendedCommandContext();
        }
    }
}

