/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ModifyQuery;

public class DynamicSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected List<String> sqlStrings;
    protected long batchSize;
    protected boolean usesOptimisticLocking;
    protected DatabaseCall lastCallAppended;

    public DynamicSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.sqlStrings = new ArrayList<String>();
        this.batchSize = 0L;
        this.maxBatchSize = this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize();
        if (this.maxBatchSize == 0) {
            this.maxBatchSize = 32000;
        }
    }

    @Override
    public void appendCall(AbstractSession session, DatabaseCall dbCall) {
        if (!dbCall.hasParameters()) {
            if (this.batchSize + (long)dbCall.getSQLString().length() > (long)this.maxBatchSize) {
                this.executeBatchedStatements(session);
            }
            if (this.usesOptimisticLocking != dbCall.hasOptimisticLock) {
                this.executeBatchedStatements(session);
            }
            this.sqlStrings.add(dbCall.getSQLString());
            this.lastCallAppended = dbCall;
            this.batchSize += (long)dbCall.getSQLString().length();
            this.usesOptimisticLocking = dbCall.hasOptimisticLock;
            ++this.statementCount;
            if (dbCall != null) {
                this.cacheQueryTimeout(session, dbCall);
            }
            if (((ModifyQuery)dbCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(session);
            }
        } else {
            this.executeBatchedStatements(session);
            this.switchMechanisms(session, dbCall);
        }
    }

    @Override
    public void clear() {
        this.sqlStrings = new ArrayList<String>();
        this.executionCount = 0;
        this.statementCount = 0;
        this.usesOptimisticLocking = false;
        this.batchSize = 0L;
        this.queryTimeoutCache = 0;
        this.lastCallAppended = null;
    }

    @Override
    public void executeBatchedStatements(AbstractSession session) {
        if (this.sqlStrings.isEmpty()) {
            return;
        }
        DynamicSQLBatchWritingMechanism currentBatch = (DynamicSQLBatchWritingMechanism)this.clone();
        this.clear();
        currentBatch.executeBatch(session);
    }

    private void executeBatch(AbstractSession session) {
        if (this.sqlStrings.size() == 1) {
            try {
                int rowCount = (Integer)this.databaseAccessor.basicExecuteCall(this.lastCallAppended, null, session, false);
                if (this.usesOptimisticLocking && rowCount != 1) {
                    throw OptimisticLockException.batchStatementExecutionFailure();
                }
            }
            finally {
                this.clear();
            }
            return;
        }
        try {
            Statement statement;
            ++this.databaseAccessor.writeStatementsCount;
            this.databaseAccessor.incrementCallCount(session);
            if (session.shouldLog(3, "sql")) {
                session.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
                for (String sql : this.sqlStrings) {
                    session.log(3, "sql", sql, null, this.databaseAccessor, false);
                }
                session.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
            }
            if (!session.getPlatform().usesJDBCBatchWriting()) {
                statement = this.prepareBatchStatement(session);
                this.databaseAccessor.executeBatchedStatement((PreparedStatement)statement, session);
            } else {
                statement = this.prepareJDK12BatchStatement(session);
                this.executionCount = this.databaseAccessor.executeJDK12BatchStatement(statement, null, session, false);
                if (this.usesOptimisticLocking && this.executionCount != this.statementCount) {
                    throw OptimisticLockException.batchStatementExecutionFailure();
                }
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(AbstractSession session, DatabaseCall dbCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToParameterizedSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism(session).appendCall(session, dbCall);
    }

    protected PreparedStatement prepareBatchStatement(AbstractSession session) throws DatabaseException {
        PreparedStatement statement = null;
        boolean isDelimiterStringNeeded = false;
        StringWriter writer = new StringWriter();
        DatabasePlatform platform = session.getPlatform();
        writer.write(platform.getBatchBeginString());
        for (String sql : this.sqlStrings) {
            if (isDelimiterStringNeeded) {
                writer.write(platform.getBatchDelimiterString());
            }
            writer.write(sql);
            isDelimiterStringNeeded = true;
        }
        writer.write(platform.getBatchDelimiterString());
        writer.write(platform.getBatchEndString());
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                statement = this.databaseAccessor.getConnection().prepareStatement(writer.toString());
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, null);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw exception;
        }
        return statement;
    }

    protected Statement prepareJDK12BatchStatement(AbstractSession session) throws DatabaseException {
        Statement statement = null;
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                statement = this.databaseAccessor.getConnection().createStatement();
                for (String sql : this.sqlStrings) {
                    statement.addBatch(sql);
                }
                if (this.queryTimeoutCache > 0) {
                    statement.setQueryTimeout(this.queryTimeoutCache);
                }
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, null);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw exception;
        }
        return statement;
    }
}

