/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public final class FMUtil {
    public static final int SEG_NONE = 0;
    public static final int SEG_WHOLE_TAG = 1;
    public static final int SEG_START_TAG = 2;
    public static final int SEG_END_TAG = 3;
    public static final int SEG_START_TAG_NAME = 4;
    public static final int SEG_END_TAG_NAME = 5;

    private FMUtil() {
    }

    public static final Segment getSegment(IDOMNode target, int segType) {
        if (target == null) {
            return new Segment(0, 0);
        }
        Segment seg = null;
        IStructuredDocumentRegion startTag = null;
        IStructuredDocumentRegion endTag = null;
        switch (segType) {
            case 1: {
                startTag = target.getFirstStructuredDocumentRegion();
                if (startTag != null) {
                    endTag = target.getLastStructuredDocumentRegion();
                    seg = new Segment(startTag, endTag);
                    break;
                }
                int startOffset = target.getStartOffset();
                int endOffset = target.getEndOffset();
                seg = new Segment(startOffset, endOffset - startOffset);
                break;
            }
            case 2: {
                startTag = target.getStartStructuredDocumentRegion();
                if (startTag != null) {
                    seg = new Segment(startTag);
                    break;
                }
                seg = new Segment(target.getStartOffset(), 1);
                break;
            }
            case 3: {
                endTag = target.getEndStructuredDocumentRegion();
                if (endTag != null) {
                    seg = new Segment(endTag);
                    break;
                }
                seg = new Segment(target.getEndOffset(), 1);
                break;
            }
            case 4: {
                ITextRegion nameRegion;
                startTag = target.getStartStructuredDocumentRegion();
                if (startTag != null && (nameRegion = FMUtil.getNameRegion((ITextRegionCollection)startTag)) != null) {
                    seg = new Segment(startTag.getStartOffset(nameRegion), nameRegion.getTextLength());
                }
                if (seg != null) break;
                seg = FMUtil.getSegment(target, 2);
                break;
            }
            case 5: {
                ITextRegion nameRegion;
                endTag = target.getEndStructuredDocumentRegion();
                if (endTag != null && (nameRegion = FMUtil.getNameRegion((ITextRegionCollection)endTag)) != null) {
                    seg = new Segment(endTag.getStartOffset(nameRegion), nameRegion.getTextLength());
                }
                if (seg != null) break;
                seg = FMUtil.getSegment(target, 3);
                break;
            }
            default: {
                return new Segment(0, 0);
            }
        }
        return seg;
    }

    private static ITextRegion getNameRegion(ITextRegionCollection containerRegion) {
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion nameRegion = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameRegion = r;
                break;
            }
            ++i;
        }
        return nameRegion;
    }
}

