/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogAttribute;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDistinctUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.impl.StructuredUserDefinedTypeImpl;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogStructuredUserDefinedType
extends StructuredUserDefinedTypeImpl
implements ICatalogObject,
IDatabaseObject {
    private boolean attributesLoaded = false;
    private boolean superLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();

    public void refresh() {
        if (this.attributesLoaded) {
            this.attributes.clear();
            this.attributesLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public EList getAttributes() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getAttributes();
        }
        if (!this.attributesLoaded) {
            this.loadAttributes();
        }
        return this.attributes;
    }

    public StructuredUserDefinedType getSuper() {
        if (!this.superLoaded) {
            this.loadSuper();
        }
        return this.super_;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 14) {
            this.getAttributes();
        } else if (id == 12) {
            this.getSuper();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadAttributes() {
        if (this.attributesLoaded) {
            return;
        }
        EList attributeList = super.getAttributes();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT ATTR_NAME, ATTR_TYPESCHEMA, ATTR_TYPENAME, LENGTH, SCALE, CODEPAGE, TARGET_TYPESCHEMA,TARGET_TYPENAME,LOGGED,COMPACT FROM SYSCAT.ATTRIBUTES WHERE TYPENAME = SOURCE_TYPENAME AND TYPESCHEMA = SOURCE_TYPESCHEMA AND TYPESCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "'" + " AND TYPENAME='" + LUWUtil.getIdentifier(this.getName()) + "' ORDER BY ORDINAL ");
            while (r.next()) {
                PredefinedDataTypeDefinition typeDefinition;
                LUWCatalogAttribute attribute = new LUWCatalogAttribute();
                String attrName = r.getString(1);
                attribute.setName(attrName);
                DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
                String attrTypeName = r.getString(3);
                if (attrTypeName.equalsIgnoreCase("FLOAT")) {
                    int length = r.getInt(4);
                    attrTypeName = length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(attrTypeName)) != null) {
                    EStructuralFeature feature;
                    int codePage;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        int codePage2 = r.getInt(6);
                        if (codePage2 == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt(6)) == 0) {
                        typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        int length = r.getInt(4);
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)length);
                    } else if (typeDefinition.isPrecisionSupported()) {
                        if (attrTypeName.equals("TIMESTAMP")) {
                            int length = r.getInt(4);
                            feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                            type.eSet(feature, (Object)length);
                        } else {
                            int length = r.getInt(4);
                            if (attrTypeName.equals("DECFLOAT")) {
                                length = length == 8 ? 16 : 34;
                            }
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)length);
                        }
                    }
                    if (typeDefinition.isScaleSupported()) {
                        int scale = r.getInt(5);
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)scale);
                    }
                    attribute.setContainedType((SQLDataType)type);
                } else if (attrTypeName.equals("REFERENCE")) {
                    String typeSchemaName = r.getString("TARGET_TYPESCHEMA").trim();
                    String udtName = r.getString("TARGET_TYPENAME");
                    attribute.setReferencedType(LUWCatalogStructuredUserDefinedType.getUserDefinedType((UserDefinedType)this, typeSchemaName, udtName));
                } else {
                    String attrTypeSchemaName = r.getString(2).trim();
                    LUWCatalogStructuredUserDefinedType.getSchema((UserDefinedType)this, attrTypeSchemaName);
                    attribute.setReferencedType(LUWCatalogStructuredUserDefinedType.getUserDefinedType((UserDefinedType)this, attrTypeSchemaName, attrTypeName));
                }
                String logged = r.getString("LOGGED");
                if (logged.equals("Y")) {
                    attribute.setLOBLogged(true);
                } else {
                    attribute.setLOBLogged(false);
                }
                String compact = r.getString("COMPACT");
                if (compact.equals("Y")) {
                    attribute.setLOBCompacted(true);
                } else {
                    attribute.setLOBCompacted(false);
                }
                attributeList.add((Object)attribute);
            }
            this.attributesLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadSuper() {
        if (this.superLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            String query = "SELECT SOURCE_TYPESCHEMA,SOURCE_TYPENAME FROM SYSCAT.ATTRIBUTES WHERE TYPESCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "'" + " AND TYPENAME='" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND TYPENAME <> SOURCE_TYPENAME" + " ORDER BY ORDINAL DESC";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            if (r.next()) {
                new LUWCatalogAttribute();
                String sourceSchemaName = r.getString("SOURCE_TYPESCHEMA").trim();
                String sourceTypeName = r.getString("SOURCE_TYPENAME");
                this.setSuper(LUWCatalogStructuredUserDefinedType.getStructuredUserDefinedType((UserDefinedType)this, sourceSchemaName, sourceTypeName));
            }
            this.superLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
    }

    protected static Schema getSchema(UserDefinedType type, String schemaName) {
        Schema s2 = type.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database db = s2.getDatabase();
        if (db instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)db).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : db.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(db);
        if (db instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)db).cacheSchema((Schema)schema);
        }
        return schema;
    }

    private static UserDefinedType getUserDefinedType(UserDefinedType type, String schemaName, String userDefinedTypeName) {
        LUWCatalogDistinctUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        for (LUWCatalogDistinctUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogDistinctUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }

    private static StructuredUserDefinedType getStructuredUserDefinedType(UserDefinedType type, String schemaName, String userDefinedTypeName) {
        LUWCatalogStructuredUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        for (LUWCatalogStructuredUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!(userDefinedType2 instanceof StructuredUserDefinedType) || !userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return (StructuredUserDefinedType)userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogStructuredUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }

    private static Table getTable(UserDefinedType type, String schemaName, String tableName) {
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getTable(schema.getName(), tableName);
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Routine getRountine(UserDefinedType type, String schemaName, String specificName) {
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        for (Routine routine : schema.getRoutines()) {
            if (!specificName.equals(routine.getSpecificName())) continue;
            return routine;
        }
        return null;
    }

    public static TableConstraint getTableConstraint(UserDefinedType type, String schemaName, String tableName, String constName) {
        Table t = LUWCatalogStructuredUserDefinedType.getTable(type, schemaName, tableName);
        if (!(t instanceof BaseTable)) {
            return null;
        }
        for (TableConstraint constraint : ((BaseTable)t).getConstraints()) {
            if (!constraint.getName().equals(constName)) continue;
            return constraint;
        }
        return null;
    }

    public static Trigger getTrigger(UserDefinedType type, String schemaName, String tabName, String triggerName) {
        Table table = LUWCatalogStructuredUserDefinedType.getTable(type, schemaName, tabName);
        if (table != null) {
            for (Trigger r : table.getTriggers()) {
                if (!r.getName().equals(triggerName)) continue;
                return r;
            }
        }
        return null;
    }

    public static DB2Package getDb2Package(UserDefinedType type, String schemaName, String pkgName, String pkgUniqueID) {
        Schema schema = LUWCatalogStructuredUserDefinedType.getSchema(type, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getDB2Package(pkgName, pkgUniqueID);
        }
        return null;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogStructuredUserDefinedType.getImpactedTriggers(connection, (UserDefinedType)this));
        impacts.addAll(LUWCatalogStructuredUserDefinedType.getImpactedTables(connection, (UserDefinedType)this));
        impacts.addAll(LUWCatalogStructuredUserDefinedType.getImpactedConstraints(connection, (UserDefinedType)this));
        impacts.addAll(LUWCatalogStructuredUserDefinedType.getImpactedRoutines(connection, (UserDefinedType)this));
        impacts.addAll(LUWCatalogStructuredUserDefinedType.getImpactedPackages(connection, (UserDefinedType)this));
        return impacts;
    }

    protected static Collection getImpactedTables(Connection connection, UserDefinedType type) {
        ArrayList<Table> impacts = new ArrayList<Table>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT TABNAME, TABSCHEMA FROM SYSCAT.TABDEP WHERE BTYPE='R' AND BNAME ='" + LUWUtil.getIdentifier(type.getName()) + "'" + " AND BSCHEMA = '" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " UNION ALL" + " SELECT DISTINCT TABNAME,TABSCHEMA" + " FROM SYSCAT.COLUMNS" + " WHERE TYPESCHEMA = '" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " AND TYPENAME ='" + LUWUtil.getIdentifier(type.getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Table t = LUWCatalogStructuredUserDefinedType.getTable(type, schemaName, tabName);
                if (t == null) continue;
                impacts.add(t);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedConstraints(Connection connection, UserDefinedType type) {
        ArrayList<TableConstraint> impacts = new ArrayList<TableConstraint>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT CONSTNAME,TABNAME,TABSCHEMA FROM SYSCAT.CONSTDEP WHERE BTYPE='R' AND BNAME='" + LUWUtil.getIdentifier(type.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String constName = r.getString("CONSTNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                TableConstraint constraint = LUWCatalogStructuredUserDefinedType.getTableConstraint(type, schemaName, tabName, constName);
                if (constraint == null) continue;
                impacts.add(constraint);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedTriggers(Connection connection, UserDefinedType type) {
        ArrayList<Trigger> impacts = new ArrayList<Trigger>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT A.TABSCHEMA, A.TABNAME, A.TRIGNAME FROM SYSCAT.TRIGGERS A, SYSCAT.TRIGDEP B WHERE (B.BNAME='" + LUWUtil.getIdentifier(type.getName()) + "'" + " AND B.BSCHEMA='" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " AND B.BTYPE='R'" + " AND A.TRIGNAME=B.TRIGNAME" + " AND A.TRIGSCHEMA=B.TRIGSCHEMA)" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String trigName = r.getString("TRIGNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Trigger trigger = LUWCatalogStructuredUserDefinedType.getTrigger(type, schemaName, tabName, trigName);
                if (trigger == null) continue;
                impacts.add(trigger);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedRoutines(Connection connection, UserDefinedType type) {
        ArrayList<Routine> impacts = new ArrayList<Routine>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT ROUTINENAME,ROUTINESCHEMA FROM SYSCAT.ROUTINEDEP WHERE BTYPE='R' AND BNAME='" + LUWUtil.getIdentifier(type.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String routineName = r.getString("ROUTINENAME").trim();
                String schemaName = r.getString("ROUTINESCHEMA").trim();
                Routine p = LUWCatalogStructuredUserDefinedType.getRountine(type, schemaName, routineName);
                if (p == null) continue;
                impacts.add(p);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedPackages(Connection connection, UserDefinedType type) {
        ArrayList<DB2Package> impacts = new ArrayList<DB2Package>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT PKGNAME, PKGSCHEMA, HEX(UNIQUE_ID) AS UID FROM SYSCAT.PACKAGEDEP WHERE BTYPE = 'R' AND BNAME='" + LUWUtil.getIdentifier(type.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(type.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String pkgUniqueID;
                String pkgName = r.getString("PKGNAME").trim();
                String schemaName = r.getString("PKGSCHEMA").trim();
                DB2Package p = LUWCatalogStructuredUserDefinedType.getDb2Package(type, schemaName, pkgName, pkgUniqueID = r.getString("UID").trim());
                if (p == null) continue;
                impacts.add(p);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }
}

