/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.matching;

import java.util.regex.Pattern;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.IMatchingPairs;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public abstract class AbstractPairMatcher
implements ICharacterPairMatcher {
    protected IMatchingPairs _matchingPairs;
    protected SQLEditor _editor;
    protected int _fAnchor = -1;
    private IDocument _lastDocument;

    public AbstractPairMatcher(IMatchingPairs matchingPairs) {
        this._matchingPairs = matchingPairs;
    }

    public void clear() {
        this._fAnchor = -1;
    }

    public void dispose() {
    }

    public int getAnchor() {
        return this._fAnchor;
    }

    public IRegion match(IDocument doc, int offset) {
        int otEndOffset;
        if (offset < 0 || offset > doc.getLength() || !this.isCode(offset)) {
            return null;
        }
        String text = doc.get();
        String originalToken = this.getOriginalToken(text, offset);
        if (originalToken == null) {
            return null;
        }
        this._fAnchor = this._matchingPairs.isLeftToken(originalToken) ? 1 : 0;
        boolean searchForward = this._matchingPairs.isLeftToken(originalToken);
        int mtStartOffset = otEndOffset = this.getOriginalTokenEndOffset(text, offset);
        mtStartOffset = this.getMatchingTokenStartOffset(originalToken, otEndOffset, searchForward, text);
        if (mtStartOffset == -1) {
            return null;
        }
        int otLen = this.getOriginalTokenLength();
        int mtLen = this.getMatchingTokenLength();
        int length = searchForward ? mtStartOffset + mtLen - (otEndOffset - otLen) : otEndOffset - mtStartOffset;
        int position = searchForward ? otEndOffset - otLen : mtStartOffset;
        return new Region(position, length);
    }

    public SQLEditor getSQLEditor() {
        return this._editor;
    }

    public void setSQLEditor(SQLEditor editor) {
        this._editor = editor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isCode(int offset) {
        char c;
        if (offset > 0 && ((c = this._editor.getSV().getDocument().get().charAt(offset - 1)) == '[' || c == ']' || c == '(' || c == ')')) {
            return true;
        }
        if (this.isInSquareBracket(this._editor.getSV().getDocument().get(), offset)) {
            return false;
        }
        String contentType = null;
        IDocument document = this._editor.getSV().getDocument();
        if (this._lastDocument != null && this._lastDocument != document) {
            this._lastDocument = null;
            return false;
        }
        try {
            this._lastDocument = document;
            boolean notCodeFlag = true;
            int tempOffset = offset - 1;
            while (tempOffset <= offset) {
                if (tempOffset >= 0 && tempOffset < document.get().length()) {
                    contentType = ((IDocumentExtension3)this._lastDocument).getContentType("___sql_partitioning", tempOffset, false);
                    if (contentType == null) {
                        return false;
                    }
                    if (!(contentType.equals("sql_comment") || contentType.equals("sql_multiline_comment") || contentType.equals("sql_double_quotes_identifier") || contentType.equals("sql_character"))) {
                        notCodeFlag = false;
                    }
                }
                ++tempOffset;
            }
            return !notCodeFlag;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (BadPartitioningException badPartitioningException) {
            return false;
        }
    }

    private boolean isInSquareBracket(String text, int offset) {
        int next = offset;
        int begin = offset;
        int end = offset;
        while (next > 0 && next < text.length() && text.charAt(next) != '[') {
            --next;
        }
        begin = next == text.length() && next != 0 ? next - 1 : next;
        next = offset;
        while (next < text.length() && text.charAt(next) != ']') {
            ++next;
        }
        end = next == text.length() ? next : next + 1;
        String s = text.substring(begin, end);
        String pattern = "\\[(.)*\\]";
        return Pattern.compile(pattern).matcher(s).matches();
    }

    public abstract String getOriginalToken(String var1, int var2);

    public abstract int getOriginalTokenLength();

    public abstract int getMatchingTokenLength();

    public abstract int getOriginalTokenEndOffset(String var1, int var2);

    public abstract int getMatchingTokenStartOffset(String var1, int var2, boolean var3, String var4);
}

