/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.Collection;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class FocusBehavior
extends AbstractBehavior {
    public static final String UNFOCUSED_STYLE = "-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0);";
    public static final String FOCUSED_STYLE = "-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0); -fx-border-color: #8ec0fc; -fx-border-width: 2;";
    public static final String FOCUS_FEEDBACK_PART_FACTORY = "FOCUS_FEEDBACK_PART_FACTORY";
    private IContentPart<? extends Node> focusPart;
    private boolean isViewerFocused;
    private ChangeListener<IContentPart<? extends Node>> focusObserver = new ChangeListener<IContentPart<? extends Node>>(){

        public void changed(ObservableValue<? extends IContentPart<? extends Node>> observable, IContentPart<? extends Node> oldValue, IContentPart<? extends Node> newValue) {
            if (oldValue != null && FocusBehavior.this.hasFeedback(oldValue)) {
                FocusBehavior.this.removeFeedback(oldValue);
            }
            FocusBehavior.this.focusPart = newValue;
            FocusBehavior.this.applyFocusToVisual();
            FocusBehavior.this.refreshFocusFeedback();
        }
    };
    private FocusModel focusModel;
    private ChangeListener<? super Boolean> viewerFocusedListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            FocusBehavior.this.isViewerFocused = newValue;
            FocusBehavior.this.refreshFocusFeedback();
        }
    };
    private IViewer viewer;
    private boolean hasViewerFocusedFeedback;

    @Override
    protected void addAnchoreds(Collection<? extends IVisualPart<? extends Node>> targets, List<? extends IVisualPart<? extends Node>> anchoreds) {
        super.addAnchoreds(targets, anchoreds, 0);
    }

    protected void addViewerFocusedFeedback() {
        this.viewer.getCanvas().setStyle(FOCUSED_STYLE);
        this.hasViewerFocusedFeedback = true;
    }

    protected void applyFocusToVisual() {
        if (this.focusPart == null) {
            this.viewer.getRootPart().getVisual().requestFocus();
        } else {
            this.focusPart.getVisual().requestFocus();
        }
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        this.viewer = this.getHost().getRoot().getViewer();
        this.focusModel = (FocusModel)((Object)this.viewer.getAdapter(FocusModel.class));
        if (this.focusModel == null) {
            throw new IllegalStateException("Unable to retrieve FocusModel viewer adapter. Please check your adapter bindings.");
        }
        this.viewer.viewerFocusedProperty().addListener(this.viewerFocusedListener);
        this.focusModel.focusProperty().addListener(this.focusObserver);
        this.focusPart = this.focusModel.getFocus();
        this.isViewerFocused = this.viewer.isViewerFocused();
        this.refreshFocusFeedback();
    }

    @Override
    protected void doDeactivate() {
        this.focusModel.focusProperty().removeListener(this.focusObserver);
        this.viewer.viewerFocusedProperty().removeListener(this.viewerFocusedListener);
        this.focusPart = null;
        this.isViewerFocused = false;
        this.refreshFocusFeedback();
        super.doDeactivate();
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, FOCUS_FEEDBACK_PART_FACTORY);
    }

    protected FocusModel getFocusModel() {
        return this.focusModel;
    }

    protected void refreshFocusFeedback() {
        boolean showViewerFocusFeedback;
        boolean bl = showViewerFocusFeedback = this.isViewerFocused && this.focusPart == null;
        if (this.hasViewerFocusedFeedback && !showViewerFocusFeedback) {
            this.removeViewerFocusedFeedback();
        } else if (!this.hasViewerFocusedFeedback && showViewerFocusFeedback) {
            this.addViewerFocusedFeedback();
        }
        if (this.focusPart != null) {
            boolean hasFeedback = this.hasFeedback(this.focusPart);
            if (hasFeedback && !this.isViewerFocused) {
                this.removeFeedback(this.focusPart);
            } else if (!hasFeedback && this.isViewerFocused) {
                this.addFeedback(this.focusPart);
            }
        }
    }

    protected void removeViewerFocusedFeedback() {
        this.viewer.getCanvas().setStyle(UNFOCUSED_STYLE);
        this.hasViewerFocusedFeedback = false;
    }
}

