/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.forms;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.commons.ui.GradientToolTip;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class RichToolTip
extends GradientToolTip {
    private static final int X_SHIFT = PlatformUiUtil.getToolTipXShift();
    private static final int Y_SHIFT = 1;
    private final Control control;
    private Object data;
    private boolean enabled;
    private boolean triggeredByMouse = true;
    private ColumnViewer viewer;
    private boolean visible;

    public RichToolTip(Control control) {
        super(control);
        this.control = control;
        this.setEnabled(true);
        this.setShift(new Point(1, 1));
    }

    protected void afterHideToolTip(Event event) {
        this.triggeredByMouse = true;
        this.visible = false;
    }

    protected Object computeData(Widget hoverWidget) {
        return hoverWidget.getData();
    }

    private boolean contains(int x, int y) {
        if (this.control instanceof Scrollable) {
            return ((Scrollable)this.control).getClientArea().contains(x, y);
        }
        return this.control.getBounds().contains(x, y);
    }

    public void dispose() {
        this.hide();
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof ToolItem) {
            ToolItem w = (ToolItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TableItem) {
            TableItem w = (TableItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TreeItem) {
            TreeItem w = (TreeItem)widget;
            return w.getBounds();
        }
        return null;
    }

    public Object getData() {
        return this.data;
    }

    public Point getLocation(Point tipSize, Event event) {
        Rectangle bounds;
        Widget widget = this.getTipWidget(event);
        if (widget != null && (bounds = this.getBounds(widget)) != null) {
            if (this.data instanceof ViewerCell) {
                bounds = ((ViewerCell)this.data).getBounds();
            }
            return this.control.toDisplay(bounds.x + X_SHIFT, bounds.y + bounds.height + 1);
        }
        return super.getLocation(tipSize, event);
    }

    protected Widget getTipWidget(Event event) {
        Point widgetPosition = new Point(event.x, event.y);
        Widget widget = event.widget;
        if (widget instanceof ToolBar) {
            ToolBar w = (ToolBar)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Table) {
            Table w = (Table)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Tree) {
            Tree w = (Tree)widget;
            return w.getItem(widgetPosition);
        }
        return widget;
    }

    protected Color getTitleColor() {
        return CommonsWorkbenchPlugin.getDefault().getFormColors(this.control.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTriggeredByMouse() {
        return this.triggeredByMouse;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setViewer(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    protected boolean shouldCreateToolTip(Event event) {
        Widget tipWidget;
        this.data = null;
        if (this.isTriggeredByMouse() && !this.enabled) {
            return false;
        }
        if (super.shouldCreateToolTip(event) && (tipWidget = this.getTipWidget(event)) != null) {
            if (this.viewer != null) {
                this.data = this.viewer.getCell(new Point(event.x, event.y));
            } else {
                Rectangle bounds = this.getBounds(tipWidget);
                if (tipWidget instanceof ScalingHyperlink) {
                    this.data = this.computeData(tipWidget);
                } else if (bounds != null && this.contains(bounds.x, bounds.y)) {
                    this.data = this.computeData(tipWidget);
                }
            }
        }
        if (this.data == null) {
            this.hide();
            return false;
        }
        return true;
    }

    public void show(Point location) {
        this.triggeredByMouse = false;
        super.show(location);
    }
}

