/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.ast;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.ASTNodes;
import org.eclipse.php.internal.ui.PHPUiPlugin;

public class ASTUtils {
    public static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    public static final String DEBUG_PREFIX = "ASTProvider > ";

    public static Program createAST(final ISourceModule input, final IProgressMonitor progressMonitor) {
        if (!ASTUtils.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((ISourceModule)input);
        if (parser == null) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final Program[] root = new Program[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    if (DEBUG) {
                        System.err.println(ASTUtils.getThreadName() + " - ASTProvider > creating AST for: " + input.getElementName());
                    }
                    root[0] = parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], (int)4);
                }
                catch (OperationCanceledException ex) {
                    return;
                }
                catch (Exception e) {
                    PHPUiPlugin.log(e);
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.php.ui", 0, "Error in PDT UI during AST creation", ex);
                PHPUiPlugin.log((IStatus)status);
            }
        });
        return root[0];
    }

    private static boolean hasSource(ISourceModule je) {
        return je != null && je.exists();
    }

    public static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }
}

