/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.diagram.description.EdgeMapping;

public class EdgeMappingCycleConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EdgeMapping edgeMapping;
        boolean findCycle;
        Resource eObjResource;
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL && (eObjResource = eObj.eResource()) != null && eObjResource.getResourceSet() != null && eObj instanceof EdgeMapping && (findCycle = this.hasCycle(edgeMapping = (EdgeMapping)eObj, Sets.newLinkedHashSet(), Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)Iterables.filter((Iterable)edgeMapping.getSourceMapping(), EdgeMapping.class), (Iterable)Iterables.filter((Iterable)edgeMapping.getTargetMapping(), EdgeMapping.class)))))) {
            return ctx.createFailureStatus(new Object[]{edgeMapping, edgeMapping.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private boolean hasCycle(EdgeMapping edgeMapping, Set<EdgeMapping> processedEdgeMappings, Set<EdgeMapping> edgeMappingsToProcess) {
        boolean hasCycle = false;
        if (Iterables.contains(edgeMappingsToProcess, (Object)edgeMapping)) {
            hasCycle = true;
        } else if (edgeMappingsToProcess.isEmpty() || processedEdgeMappings.containsAll(edgeMappingsToProcess)) {
            hasCycle = false;
        } else {
            LinkedHashSet newEdgeMappingsToProcess = Sets.newLinkedHashSet();
            for (EdgeMapping edgeMappingToProcess : edgeMappingsToProcess) {
                newEdgeMappingsToProcess.addAll(Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)Iterables.filter((Iterable)edgeMappingToProcess.getSourceMapping(), EdgeMapping.class), (Iterable)Iterables.filter((Iterable)edgeMappingToProcess.getTargetMapping(), EdgeMapping.class))));
            }
            hasCycle = this.hasCycle(edgeMapping, Sets.newLinkedHashSet((Iterable)Iterables.concat(processedEdgeMappings, edgeMappingsToProcess)), newEdgeMappingsToProcess);
        }
        return hasCycle;
    }
}

