/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHelperImpl;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.io.FileSystemItem;

public interface ClassPathHelper {
    public static ClassPathHelper create(ClassPathHunter classPathHunter, Map<?, ?> config) {
        return new ClassPathHelperImpl(classPathHunter, config);
    }

    public Supplier<Map<String, String>> compute(SearchConfig var1);

    public Supplier<Map<String, String>> compute(Compute.ByClasses.Config var1);

    public Supplier<Map<String, String>> compute(Compute.ByClasses.AndBySourceImportsConfig var1);

    public Supplier<Map<String, String>> compute(Compute.Config var1);

    public Supplier<Map<String, String>> compute(Compute.BySourceImportsConfig var1);

    public Map<String, ClassLoader> compute(Compute.AndAddToClassLoaderConfig var1);

    public static interface Compute {

        public static interface ByClasses {

            public static class AndBySourceImportsConfig {
                public Collection<String> sources;
                public Collection<String> classRepositories;
                public ClassCriteria additionalClassCriteria;

                AndBySourceImportsConfig(Collection<String> sources, Collection<String> classRepositories) {
                    this.sources = sources;
                    this.classRepositories = classRepositories;
                }

                public static AndBySourceImportsConfig create(Collection<String> sources, Collection<String> classRepositories) {
                    if (sources == null) {
                        throw new IllegalArgumentException("No source has been provided");
                    }
                    if (classRepositories == null) {
                        throw new IllegalArgumentException("No class repository has been provided");
                    }
                    return new AndBySourceImportsConfig(sources, classRepositories);
                }

                public AndBySourceImportsConfig setClassRepositories(Collection<String> classRepositories) {
                    this.classRepositories = classRepositories;
                    return this;
                }

                public AndBySourceImportsConfig withAdditionalClassFilter(ClassCriteria additionalClassCriteria) {
                    this.additionalClassCriteria = additionalClassCriteria;
                    return this;
                }
            }

            public static class Config {
                Collection<String> classRepositories;
                Collection<String> pathsToBeRefreshed;
                ClassCriteria classCriteria;

                Config(Collection<String> classRepositories) {
                    this.classRepositories = classRepositories;
                }

                public static Config create(Collection<String> classRepositories) {
                    if (classRepositories == null) {
                        throw new IllegalArgumentException("No class repository has been provided");
                    }
                    return new Config(classRepositories);
                }

                public Config refreshPaths(Collection<String> pathsToBeRefreshed) {
                    this.pathsToBeRefreshed = pathsToBeRefreshed;
                    return this;
                }

                public Config withClassFilter(ClassCriteria classCriteria) {
                    this.classCriteria = classCriteria;
                    return this;
                }
            }
        }

        public static class BySourceImportsConfig {
            public Collection<String> sources;
            public Collection<String> classRepositories;
            public Predicate<FileSystemItem> pathsToBeRefreshedPredicate;
            public Predicate<FileSystemItem> additionalFileFilter;

            BySourceImportsConfig(Collection<String> sources, Collection<String> classRepositories) {
                this.sources = sources;
                this.classRepositories = classRepositories;
            }

            public static BySourceImportsConfig create(Collection<String> sources, Collection<String> classRepositories) {
                if (sources == null) {
                    throw new IllegalArgumentException("No source has been provided");
                }
                if (classRepositories == null) {
                    throw new IllegalArgumentException("No class repository has been provided");
                }
                return new BySourceImportsConfig(sources, classRepositories);
            }

            public BySourceImportsConfig refreshAllPathsThat(Predicate<FileSystemItem> pathsToBeRefreshedPredicate) {
                this.pathsToBeRefreshedPredicate = pathsToBeRefreshedPredicate;
                return this;
            }

            public BySourceImportsConfig withAdditionalFileFilter(Predicate<FileSystemItem> additionalFileFilter) {
                this.additionalFileFilter = additionalFileFilter;
                return this;
            }
        }

        public static class AndAddToClassLoaderConfig {
            public ClassLoader classLoader;
            public Collection<String> classRepositories;
            public Collection<String> pathsToBeRefreshed;
            public String nameOfTheClassToBeLoaded;
            public Collection<String> nameOfTheClassesRequiredByTheClassToBeLoaded;

            AndAddToClassLoaderConfig(ClassLoader classLoader, Collection<String> classRepositories, String nameOfTheClassToBeLoaded) {
                this.classLoader = classLoader;
                this.classRepositories = classRepositories;
                this.nameOfTheClassToBeLoaded = nameOfTheClassToBeLoaded;
            }

            public static AndAddToClassLoaderConfig create(ClassLoader classLoader, Collection<String> classRepositories, String nameOfTheClassToBeLoaded) {
                if (classLoader == null) {
                    throw new IllegalArgumentException("No class loader has been provided");
                }
                if (classRepositories == null) {
                    throw new IllegalArgumentException("No class repository has been provided");
                }
                if (StaticComponentContainer.Strings.isEmpty(nameOfTheClassToBeLoaded)) {
                    throw new IllegalArgumentException("No class name to be found has been provided");
                }
                return new AndAddToClassLoaderConfig(classLoader, classRepositories, nameOfTheClassToBeLoaded);
            }

            public AndAddToClassLoaderConfig setClassesRequiredByTheClassToBeLoaded(Collection<String> nameOfTheClassesRequiredByTheClassToBeLoaded) {
                this.nameOfTheClassesRequiredByTheClassToBeLoaded = nameOfTheClassesRequiredByTheClassToBeLoaded;
                return this;
            }

            public AndAddToClassLoaderConfig refreshPaths(Collection<String> pathsToBeRefreshed) {
                this.pathsToBeRefreshed = pathsToBeRefreshed;
                return this;
            }
        }

        public static class Config {
            public Collection<String> classRepositories;
            public Predicate<FileSystemItem> pathsToBeRefreshedPredicate;
            public Predicate<FileSystemItem> fileFilter;

            Config(Collection<String> classRepositories) {
                this.classRepositories = classRepositories;
            }

            public static Config create(Collection<String> classRepositories) {
                if (classRepositories == null) {
                    throw new IllegalArgumentException("No class repository has been provided");
                }
                return new Config(classRepositories);
            }

            public Config refreshAllPathsThat(Predicate<FileSystemItem> pathsToBeRefreshedPredicate) {
                this.pathsToBeRefreshedPredicate = pathsToBeRefreshedPredicate;
                return this;
            }

            public Config withFileFilter(Predicate<FileSystemItem> javaClassFilter) {
                this.fileFilter = javaClassFilter;
                return this;
            }
        }
    }

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put("class-path-helper.class-path-hunter.search-config.check-file-option", "${hunters.default-search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            public static final String CLASS_PATH_HUNTER_SEARCH_CONFIG_CHECK_FILE_OPTIONS = "class-path-helper.class-path-hunter.search-config.check-file-option";
        }
    }
}

