/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.utils.Messages;
import org.eclipse.osgi.service.datalocation.Location;

public class PlatformFileUtils {
    public static IFileHandle findAbsoluteOrEclipseRelativeFile(IEnvironment env, IPath path) {
        IFileHandle file;
        block11: {
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException(Messages.PlatformFileUtils_pathMustNotBeEmpty);
            }
            file = env.getFile(path);
            if (env.isLocal() && !file.exists() && !path.isAbsolute()) {
                IFileHandle nfile;
                String loc;
                Location location;
                block10: {
                    location = Platform.getInstallLocation();
                    if (location != null) {
                        try {
                            loc = FileLocator.resolve((URL)location.getURL()).getPath();
                            nfile = env.getFile(new Path(loc).append(path));
                            if (nfile.exists()) {
                                return nfile;
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block10;
                            e.printStackTrace();
                        }
                    }
                }
                if ((location = Platform.getInstanceLocation()) != null) {
                    try {
                        loc = FileLocator.resolve((URL)location.getURL()).getPath();
                        nfile = env.getFile(new Path(loc).append(path));
                        if (nfile.exists()) {
                            return nfile;
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
        }
        return file;
    }

    public static File findAbsoluteOrEclipseRelativeFile(File file) {
        return file;
    }
}

