/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;

public class CurvedConnectionEditPart
extends ConnectionEditPart {
    public CurvedConnectionEditPart(IConfigurationProviderInternal configurationProvider, CurvedConnection connection, EditPart contextParent) {
        super(configurationProvider, (Connection)connection, contextParent);
    }

    private CurvedConnection getCurvedConnection() {
        return (CurvedConnection)super.getConnection();
    }

    @Override
    protected IFigure createFigure() {
        IFigure ret = super.createFigure();
        if (ret instanceof org.eclipse.draw2d.Connection) {
            org.eclipse.draw2d.Connection draw2dConnection = (org.eclipse.draw2d.Connection)ret;
            ArrayList<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint> controllPoints = new ArrayList<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint>();
            controllPoints.addAll((Collection<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint>)this.getCurvedConnection().getControlPoints());
            draw2dConnection.setConnectionRouter((ConnectionRouter)new BezierRouter(controllPoints));
        }
        return ret;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshControlPoints();
    }

    private void refreshControlPoints() {
        IFigure figure = this.getFigure();
        if (figure instanceof org.eclipse.draw2d.Connection) {
            org.eclipse.draw2d.Connection draw2dConnection = (org.eclipse.draw2d.Connection)figure;
            draw2dConnection.getConnectionRouter().invalidate(draw2dConnection);
        }
    }

    private class BezierRouter
    extends AbstractRouter {
        private List<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint> bezierPoints;
        private Map<org.eclipse.draw2d.Connection, Object> constraints = new HashMap<org.eclipse.draw2d.Connection, Object>(11);

        public BezierRouter(List<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint> bezierPoints) {
            this.bezierPoints = bezierPoints;
        }

        public void invalidate(org.eclipse.draw2d.Connection connection) {
            super.invalidate(connection);
            this.bezierPoints.clear();
            this.bezierPoints.addAll((Collection<org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint>)CurvedConnectionEditPart.this.getCurvedConnection().getControlPoints());
        }

        public void route(org.eclipse.draw2d.Connection connection) {
            ArrayList<PrecisionPoint> controllPoints = new ArrayList<PrecisionPoint>();
            PointList points = connection.getPoints();
            points.removeAllPoints();
            Point ref1 = connection.getTargetAnchor().getReferencePoint();
            Point ref2 = connection.getSourceAnchor().getReferencePoint();
            PrecisionPoint start = new PrecisionPoint();
            PrecisionPoint end = new PrecisionPoint();
            start.setLocation(connection.getSourceAnchor().getLocation(ref1));
            connection.translateToRelative((Translatable)start);
            end.setLocation(connection.getTargetAnchor().getLocation(ref2));
            connection.translateToRelative((Translatable)end);
            controllPoints.add(start);
            double gradient = (end.preciseY() - start.preciseY()) / (-end.preciseX() + start.preciseX());
            double ortho_gradient = -Math.pow(gradient, -1.0);
            double orthovector_x = 1.0;
            double orthovector_y = ortho_gradient;
            double factor_to_length = 1.0 / Math.sqrt(Math.pow(orthovector_y, 2.0) + Math.pow(orthovector_x, 2.0));
            for (org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint precisionPoint : this.bezierPoints) {
                double orthovector_x_cp = factor_to_length * orthovector_x * precisionPoint.getY();
                double orthovector_y_cp = factor_to_length * orthovector_y * precisionPoint.getY();
                if (Double.isNaN(orthovector_x_cp)) {
                    orthovector_x_cp = 0.0;
                }
                if (Double.isNaN(orthovector_y_cp)) {
                    orthovector_y_cp = 1.0 * precisionPoint.getY();
                }
                PrecisionPoint anchor = new PrecisionPoint((double)start.x + (double)(end.x - start.x) * precisionPoint.getX() - orthovector_x_cp, (double)start.y - (double)(start.y - end.y) * precisionPoint.getX() + orthovector_y_cp);
                controllPoints.add(anchor);
            }
            controllPoints.add(end);
            int precision = 10;
            double factor = 1.0 / (double)precision;
            points.addPoint((Point)start);
            int i = 1;
            while (i < precision) {
                int j = 0;
                double sum_x = 0.0;
                double sum_y = 0.0;
                for (Point point : controllPoints) {
                    sum_x += this.bezier(j, controllPoints.size() - 1, (double)i * factor) * point.preciseX();
                    sum_y += this.bezier(j, controllPoints.size() - 1, (double)i * factor) * point.preciseY();
                    ++j;
                }
                PrecisionPoint precisionPoint = new PrecisionPoint(sum_x, sum_y);
                points.addPoint((Point)precisionPoint);
                ++i;
            }
            points.addPoint((Point)end);
            connection.setPoints(points);
        }

        private double bezier(int i, int n, double t) {
            return (double)this.binomialCoefficients(n, i) * Math.pow(t, i) * Math.pow(1.0 - t, n - i);
        }

        private long binomialCoefficients(int n, int k) {
            long coeff = 1L;
            int i = n - k + 1;
            while (i <= n) {
                coeff *= (long)i;
                ++i;
            }
            i = 1;
            while (i <= k) {
                coeff /= (long)i;
                ++i;
            }
            return coeff;
        }

        public void setConstraint(org.eclipse.draw2d.Connection connection, Object constraint) {
            this.constraints.put(connection, constraint);
        }

        public void remove(org.eclipse.draw2d.Connection connection) {
            this.constraints.remove(connection);
        }

        public Object getConstraint(org.eclipse.draw2d.Connection connection) {
            return this.constraints.get(connection);
        }
    }
}

