/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class SynchronizedStack<E>
implements Stack<E>,
Serializable {
    private final Stack<E> stack;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedStack(Stack<E> stack, Object mutex) {
        if (stack == null || mutex == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
        this.mutex = mutex;
    }

    public SynchronizedStack(Stack<E> stack) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.push_(element);
        }
    }

    private void push_(E element) {
        this.stack.push(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pop() {
        Object object = this.mutex;
        synchronized (object) {
            return this.pop_();
        }
    }

    private E pop_() {
        E o = this.stack.pop();
        this.mutex.notifyAll();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(empty);
        }
    }

    private void waitUntilEmptyIs_(boolean empty) throws InterruptedException {
        while (this.stack.isEmpty() != empty) {
            this.mutex.wait();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(true);
    }

    public void waitUntilNotEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToPush(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.push_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToPop() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.pop_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs_(empty, timeout);
        }
    }

    private boolean waitUntilEmptyIs_(boolean empty, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmptyIs_(empty);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.stack.isEmpty() != empty && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.stack.isEmpty() == empty;
    }

    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(true, timeout);
    }

    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToPush(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.push_(element);
            }
            return success;
        }
    }

    public Object waitToPop(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.pop_();
            }
            throw new EmptyStackException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public boolean pushAll(Iterable<? extends E> iterable) {
        return this.pushAll(iterable.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushAll(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.pushAll_(iterator);
        }
    }

    private boolean pushAll_(Iterator<? extends E> iterator) {
        do {
            this.stack.push(iterator.next());
        } while (iterator.hasNext());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushAll(E ... array) {
        int len = array.length;
        if (len == 0) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.pushAll_(array, len);
        }
    }

    private boolean pushAll_(E[] array, int arrayLength) {
        int i = 0;
        do {
            this.stack.push(array[i++]);
        } while (i < arrayLength);
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushAll(Stack<? extends E> s) {
        if (s.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.pushAll_(s);
        }
    }

    private boolean pushAll_(Stack<? extends E> s) {
        do {
            this.stack.push(s.pop());
        } while (!s.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushAll(Queue<? extends E> queue) {
        if (queue.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.pushAll_(queue);
        }
    }

    private boolean pushAll_(Queue<? extends E> queue) {
        do {
            this.stack.push(queue.dequeue());
        } while (!queue.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public ArrayList<E> popAll() {
        ArrayList result = new ArrayList();
        this.popAllTo(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popAllTo(Collection<? super E> collection) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(collection);
        }
    }

    private boolean popAllTo_(Collection<? super E> collection) {
        if (this.stack.isEmpty()) {
            return false;
        }
        return this.popAllTo__(collection);
    }

    private boolean popAllTo__(Collection<? super E> collection) {
        do {
            collection.add(this.stack.pop());
        } while (!this.stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popAllTo(List<? super E> list, int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(list, index);
        }
    }

    private boolean popAllTo_(List<? super E> list, int index) {
        if (this.stack.isEmpty()) {
            return false;
        }
        if (index == list.size()) {
            return this.popAllTo__(list);
        }
        ArrayList temp = new ArrayList();
        this.popAllTo__(temp);
        list.addAll(index, temp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popAllTo(Stack<? super E> stack2) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(stack2);
        }
    }

    public boolean popAllTo_(Stack<? super E> stack2) {
        if (this.stack.isEmpty()) {
            return false;
        }
        do {
            stack2.push(this.stack.pop());
        } while (!this.stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean popAllTo(Queue<? super E> queue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(queue);
        }
    }

    public boolean popAllTo_(Queue<? super E> queue) {
        if (this.stack.isEmpty()) {
            return false;
        }
        do {
            queue.enqueue(this.stack.pop());
        } while (!this.stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean popAllTo(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(map, keyTransformer);
        }
    }

    private <K> boolean popAllTo_(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        if (this.stack.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.stack.pop(), keyTransformer);
        } while (!this.stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> boolean popAllTo(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.popAllTo_(map, keyTransformer, valueTransformer);
        }
    }

    private <K, V> boolean popAllTo_(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        if (this.stack.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.stack.pop(), keyTransformer, valueTransformer);
        } while (!this.stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

