/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UpdateBuildpathWizardPage
extends WizardPage {
    private final IPluginModelBase[] fSelected;
    private final IPluginModelBase[] fUnmigrated;
    private CheckboxTableViewer pluginListViewer;
    private final TablePart tablePart;

    public UpdateBuildpathWizardPage(IPluginModelBase[] models, IPluginModelBase[] selected) {
        super("UpdateBuildpathWizardPage");
        this.setTitle(PDEUIMessages.UpdateBuildpathWizard_title);
        this.setDescription(PDEUIMessages.UpdateBuildpathWizard_desc);
        this.fUnmigrated = models;
        this.fSelected = selected;
        this.tablePart = new TablePart(PDEUIMessages.UpdateBuildpathWizard_availablePlugins);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new BuildpathContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.pluginListViewer.setInput((Object)PDEPlugin.getDefault());
        this.tablePart.setSelection(this.fSelected);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.update_classpath");
    }

    public void storeSettings() {
    }

    public Object[] getSelected() {
        return this.tablePart.getSelection();
    }

    private void dialogChanged() {
        this.setPageComplete(this.tablePart.getSelectionCount() > 0);
    }

    public boolean isPageComplete() {
        return this.tablePart.getSelectionCount() > 0;
    }

    public class BuildpathContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (UpdateBuildpathWizardPage.this.fUnmigrated != null) {
                return UpdateBuildpathWizardPage.this.fUnmigrated;
            }
            return new Object[0];
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        @Override
        public void updateCounterLabel() {
            super.updateCounterLabel();
            UpdateBuildpathWizardPage.this.dialogChanged();
        }

        @Override
        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
            return viewer;
        }
    }
}

