/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;

public final class JobFuture<V>
extends SdkFuture<V> {
    private final AbstractJob m_job;

    JobFuture(AbstractJob job, final Supplier<V> resultExtractor) {
        this.m_job = (AbstractJob)((Object)Ensure.notNull((Object)((Object)job)));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){
            final /* synthetic */ JobFuture this$0;
            {
                this.this$0 = this$0;
            }

            public void done(IJobChangeEvent event) {
                try {
                    AbstractJob j = (AbstractJob)event.getJob();
                    j.removeJobChangeListener((IJobChangeListener)this);
                    this.this$0.doCompletion(j.isCanceled(), this.this$0.exception().orElse(null), resultExtractor);
                }
                catch (Throwable t) {
                    this.this$0.completeExceptionally(t);
                }
            }
        });
    }

    public AbstractJob job() {
        return this.m_job;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.m_job.cancel();
        return super.cancel(mayInterruptIfRunning);
    }

    public Optional<Throwable> exception() {
        IStatus result = this.m_job.getResult();
        if (result == null) {
            return Optional.empty();
        }
        Optional<Throwable> exception = Optional.ofNullable(result.getException());
        if (exception.isPresent()) {
            return exception;
        }
        if (this.m_job.getResult().getSeverity() == 4) {
            return Optional.of(new SdkException((CharSequence)"Job '{}' completed with Status Error.", new Object[]{this.m_job}));
        }
        return Optional.empty();
    }

    public Supplier<V> get(long timeout, TimeUnit unit, IProgressMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.detectDeadLock();
            boolean completed = this.m_job.join(unit.toMillis(timeout), monitor);
            if (!completed) {
                throw new TimeoutException();
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            return (Supplier)this.get();
        }
        catch (OperationCanceledException e) {
            SdkLog.debug((CharSequence)"Waiting for job {} has been aborted.", (Object[])new Object[]{this.m_job, e});
            return null;
        }
    }

    void detectDeadLock() {
        Ensure.isFalse((boolean)this.isCurrentContextConflictingWithJobRule(), (CharSequence)"DEADLOCK detected: Cannot wait for future because the scheduling rule of the calling thread is conflicting with the scheduling rule of the future!", (Object[])new Object[0]);
    }

    boolean isCurrentContextConflictingWithJobRule() {
        ISchedulingRule rule = this.m_job.getRule();
        if (rule == null) {
            return false;
        }
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        if (currentRule == null) {
            return false;
        }
        return currentRule.isConflicting(rule);
    }
}

