/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.layout;

import java.util.List;
import java.util.Objects;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public abstract class AbstractLayoutInfo<T extends JavaInfo>
extends JavaInfo {
    public AbstractLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void setDefaultLayout() throws Exception {
        IPreferenceStore prefs = this.getDescription().getToolkit().getPreferences();
        String defaultValue = prefs.getString("layout.default");
        if (defaultValue.isEmpty()) {
            this.delete();
            return;
        }
        List<LayoutDescription> descriptions = LayoutDescriptionHelper.get(this.getDescription().getToolkit());
        String creationId = null;
        ClassLoader editorLoader = null;
        Class<?> layoutClass = null;
        for (LayoutDescription description : descriptions) {
            if (!Objects.equals(defaultValue, description.getId())) continue;
            creationId = description.getCreationId();
            editorLoader = EditorState.get(this.getParentJava().getEditor()).getEditorLoader();
            layoutClass = editorLoader.loadClass(description.getLayoutClassName());
        }
        if (layoutClass == null) {
            DesignerPlugin.log((String)NLS.bind((String)Messages.AbstractLayoutInfo_unknownDefaultLayout, (Object)defaultValue));
            this.delete();
            return;
        }
        JavaInfo defaultLayoutInfo = JavaInfoUtils.createJavaInfo(this.getParentJava().getEditor(), layoutClass, (CreationSupport)new ConstructorCreationSupport(creationId, true));
        this.setLayout(defaultLayoutInfo);
    }

    protected abstract void setLayout(T var1) throws Exception;
}

