/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.launching.Messages;

public class EnvironmentVariable {
    private String name;
    private String value;

    public EnvironmentVariable(EnvironmentVariable var) {
        this(var.getName(), var.getValue());
    }

    public EnvironmentVariable(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public IStatus validate() {
        String name = this.getName();
        String value = this.getValue();
        if (name == null && value == null) {
            return new Status(4, "org.eclipse.dltk.core", 0, Messages.EnvironmentVariable_variableNameAndValueMustNotBeEmpty, null);
        }
        boolean skipUntilQuote1 = false;
        boolean skipUntilQuote2 = false;
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) == '\"' && !skipUntilQuote2) {
                skipUntilQuote1 = !skipUntilQuote1;
            } else if (value.charAt(i) == '\'' && !skipUntilQuote1) {
                skipUntilQuote2 = !skipUntilQuote2;
            }
            ++i;
        }
        if (skipUntilQuote1) {
            return new Status(2, "org.eclipse.dltk.core", 0, "Missing closing quote(\") in variable " + name, null);
        }
        if (skipUntilQuote2) {
            return new Status(2, "org.eclipse.dltk.core", 0, "Missing closing quote(') in variable " + name, null);
        }
        return Status.OK_STATUS;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

