/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.validators.core.CommandLine;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.IValidatorProblem;
import org.eclipse.dltk.validators.core.IValidatorReporter;
import org.eclipse.dltk.validators.core.ValidatorReporter;
import org.eclipse.dltk.validators.internal.externalchecker.core.CustomWildcard;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalChecker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.eclipse.dltk.validators.internal.externalchecker.core.WildcardMatcher;

class ExternalCheckerDelegate {
    public static final String MARKER_ID = "org.eclipse.dltk.validators.externalchecker.externalcheckerproblem";
    private final String arguments;
    private final String command;
    private final IEnvironment environment;
    private final IExecutionEnvironment execEnvironment;
    private final String[] extensions;
    private final boolean passInterpreterEnvironmentVars;
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<IProject, EnvContainer> projectEnvs = new HashMap<IProject, EnvContainer>();

    public ExternalCheckerDelegate(IEnvironment environment, ExternalChecker externalChecker) {
        this.environment = environment;
        this.execEnvironment = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        int i = 0;
        while (i < externalChecker.getNRules()) {
            this.rules.add(externalChecker.getRule(i));
            ++i;
        }
        this.arguments = externalChecker.getArguments();
        this.extensions = this.prepareExtensions(externalChecker.getExtensions());
        this.passInterpreterEnvironmentVars = externalChecker.isPassInterpreterEnvironmentVars();
        this.command = this.prepareCommand(externalChecker.getCommand(), environment);
    }

    public IValidatorReporter createValidatorReporter() {
        return new ValidatorReporter(this.getMarkerId(), false);
    }

    public String getMarkerId() {
        return MARKER_ID;
    }

    public boolean isValidatorConfigured() {
        return this.command != null && this.command.trim().length() != 0;
    }

    public boolean isValidExtension(String extension) {
        if (this.extensions.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (extension != null && extension.endsWith(this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void runValidator(IResource resource, IValidatorOutput console, IExternalReporterDelegate delegate) throws CoreException {
        String[] env;
        CommandLine cmdLine = new CommandLine(this.arguments);
        cmdLine.replaceSequence('f', this.getResourcePath(resource));
        cmdLine.add(0, this.command);
        if (this.passInterpreterEnvironmentVars) {
            IProject project = resource.getProject();
            EnvContainer envContainer = this.projectEnvs.get(project);
            if (envContainer == null) {
                EnvironmentVariable[] resolved;
                envContainer = new EnvContainer();
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)DLTKCore.create((IProject)project));
                if (install != null && (resolved = EnvironmentResolver.resolve((Map)this.execEnvironment.getEnvironmentVariables(true), (EnvironmentVariable[])install.getEnvironmentVariables(), (boolean)true)) != null) {
                    envContainer.environmentVars = new String[resolved.length];
                    int i = 0;
                    while (i < resolved.length) {
                        envContainer.environmentVars[i] = resolved[i].toString();
                        ++i;
                    }
                }
                this.projectEnvs.put(project, envContainer);
            }
            env = envContainer.environmentVars;
        } else {
            env = null;
        }
        Process process = this.execEnvironment.exec(cmdLine.toArray(), null, env);
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                console.println(line);
                IValidatorProblem problem = this.parseProblem(line);
                delegate.report(problem);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getResourcePath(IResource resource) {
        if (resource.getLocation() != null) {
            return resource.getLocation().makeAbsolute().toOSString();
        }
        URI uri = resource.getLocationURI();
        IFileHandle file = this.environment.getFile(uri);
        return file.toOSString();
    }

    private IValidatorProblem parseProblem(String problem) {
        List<CustomWildcard> wlist = ExternalCheckerWildcardManager.loadCustomWildcards();
        int i = 0;
        while (i < this.rules.size()) {
            block4: {
                Rule rule = this.rules.get(i);
                try {
                    WildcardMatcher wmatcher = new WildcardMatcher(wlist);
                    IValidatorProblem cproblem = wmatcher.match(rule, problem);
                    if (cproblem != null) {
                        return cproblem;
                    }
                }
                catch (Exception x) {
                    if (!DLTKCore.DEBUG) break block4;
                    System.out.println(x.toString());
                }
            }
            ++i;
        }
        return null;
    }

    private String prepareCommand(Map<IEnvironment, String> commands, IEnvironment environment) {
        String result = commands.get(environment);
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    private String[] prepareExtensions(String extensions) {
        String[] parts = extensions.split("[\\s;]+");
        int i = 0;
        while (i < parts.length) {
            if ("*".equals(parts[i])) {
                return CharOperation.NO_STRINGS;
            }
            ++i;
        }
        return parts;
    }

    private static class EnvContainer {
        String[] environmentVars;

        private EnvContainer() {
        }
    }

    static interface IExternalReporterDelegate {
        public void report(IValidatorProblem var1) throws CoreException;
    }
}

