/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.logger;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLogger;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;

public class OCERuntimeLoggerSpy
implements RuntimeLogger {
    public static final String RE_THROW_STATUS_MESSAGE_KEY = "-RT-";

    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        if (exception instanceof EvaluationException) {
            Throwable cause = exception.getCause();
            this.throwOperationCanceledExceptionIfNeeded(cause);
            if (cause instanceof InvocationTargetException) {
                this.throwOperationCanceledExceptionIfNeeded(((InvocationTargetException)cause).getTargetException());
            } else if (cause != null && cause.getClass().getSimpleName().equals("AcceleoQueryEvaluationException")) {
                this.throwOperationCanceledExceptionIfNeeded(cause.getCause());
            }
        }
    }

    private void throwOperationCanceledExceptionIfNeeded(Throwable cause) {
        if (cause instanceof OperationCanceledException && cause.getMessage() != null && cause.getMessage().contains(RE_THROW_STATUS_MESSAGE_KEY)) {
            throw (OperationCanceledException)cause;
        }
    }

    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, String message) {
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, String message) {
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, String message) {
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clear(EObject eObject) {
    }
}

