/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.ee8.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee8.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.ee8.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UriPatternPredicate;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.ResourceUriPatternPredicate;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetaInfConfiguration.class);
    public static final String USE_CONTAINER_METAINF_CACHE = "org.eclipse.jetty.metainf.useCache";
    public static final boolean DEFAULT_USE_CONTAINER_METAINF_CACHE = true;
    public static final String CACHED_CONTAINER_TLDS = "org.eclipse.jetty.tlds.cache";
    public static final String CACHED_CONTAINER_FRAGMENTS = FragmentConfiguration.FRAGMENT_RESOURCES + ".cache";
    public static final String CACHED_CONTAINER_RESOURCES = "org.eclipse.jetty.resources.cache";
    public static final String METAINF_TLDS = "org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = FragmentConfiguration.FRAGMENT_RESOURCES;
    public static final String METAINF_RESOURCES = "org.eclipse.jetty.resources";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final List<String> __allScanTypes = Arrays.asList("org.eclipse.jetty.tlds", "org.eclipse.jetty.resources", METAINF_FRAGMENTS);
    public static final String RESOURCE_DIRS = "org.eclipse.jetty.resources";

    public MetaInfConfiguration() {
        this.addDependencies(WebXmlConfiguration.class);
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.findAndFilterContainerPaths(context);
        this.findAndFilterWebAppPaths(context);
        context.getMetaData().setWebInfClassesResources(this.findClassDirs(context));
        this.scanJars(context);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
    }

    public void findAndFilterContainerPaths(WebAppContext context) throws Exception {
        String pattern = (String)context.getAttribute(CONTAINER_JAR_PATTERN);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}={}", (Object)CONTAINER_JAR_PATTERN, (Object)pattern);
        }
        if (StringUtil.isBlank((String)pattern)) {
            return;
        }
        ResourceFactory resourceFactory = context.getResourceFactory();
        UriPatternPredicate uriPatternPredicate = new UriPatternPredicate(pattern, false);
        Consumer<Resource> addContainerResource = resource -> {
            if (Resources.missing((Resource)resource)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Classpath URI doesn't exist: " + String.valueOf(resource));
                }
            } else {
                context.getMetaData().addContainerResource((Resource)resource);
            }
        };
        List<URI> containerUris = this.getAllContainerJars(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All container urls {}", containerUris);
        }
        containerUris.stream().filter(uriPatternPredicate).map(arg_0 -> ((ResourceFactory)resourceFactory).newResource(arg_0)).filter(Objects::nonNull).forEach(addContainerResource);
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            resourceFactory.split(classPath, File.pathSeparator, true).stream().filter(Objects::nonNull).filter(r -> uriPatternPredicate.test(r.getURI())).forEach(addContainerResource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container paths selected:{}", context.getMetaData().getContainerResources());
        }
    }

    public void findAndFilterWebAppPaths(WebAppContext context) throws Exception {
        String pattern = (String)context.getAttribute(WEBINF_JAR_PATTERN);
        ResourceUriPatternPredicate webinfPredicate = new ResourceUriPatternPredicate(pattern, true);
        List<Resource> jars = this.findJars(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("webapp {}={} jars {}", new Object[]{WEBINF_JAR_PATTERN, pattern, jars});
        }
        if (jars != null) {
            jars.stream().filter(webinfPredicate).forEach(resource -> context.getMetaData().addWebInfResource((Resource)resource));
        }
    }

    protected List<URI> getAllContainerJars(WebAppContext context) {
        HashSet locations = new HashSet();
        Module module = MetaInfConfiguration.class.getModule();
        if (module.isNamed()) {
            ArrayDeque<ModuleLayer> layers = new ArrayDeque<ModuleLayer>();
            layers.push(module.getLayer());
            while (!layers.isEmpty()) {
                ModuleLayer layer = (ModuleLayer)layers.pop();
                layers.addAll(layer.parents());
                layer.configuration().modules().stream().map(m -> m.reference().location()).map(optional -> optional.orElse(null)).filter(Objects::nonNull).filter(uri -> !uri.getScheme().equalsIgnoreCase("jrt")).collect(Collectors.toCollection(() -> locations));
            }
        }
        for (ClassLoader loader = MetaInfConfiguration.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URLClassLoader urlCL = (URLClassLoader)loader;
            URIUtil.streamOf((URLClassLoader)urlCL).forEach(locations::add);
        }
        return List.copyOf(locations);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Set resources = (Set)context.getAttribute("org.eclipse.jetty.resources");
        if (resources != null && !resources.isEmpty()) {
            ArrayList<Resource> collection = new ArrayList<Resource>();
            collection.add(context.getBaseResource());
            collection.addAll(resources);
            context.setBaseResource(ResourceFactory.combine(collection));
        }
    }

    protected void scanJars(WebAppContext context) throws Exception {
        Boolean attr;
        boolean useContainerCache = true;
        if (context.getServer() != null && (attr = (Boolean)context.getServer().getAttribute(USE_CONTAINER_METAINF_CACHE)) != null) {
            useContainerCache = attr;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} = {}", (Object)USE_CONTAINER_METAINF_CACHE, (Object)useContainerCache);
        }
        if (context.getAttribute(METAINF_TLDS) == null) {
            context.setAttribute(METAINF_TLDS, new HashSet());
        }
        if (context.getAttribute("org.eclipse.jetty.resources") == null) {
            context.setAttribute("org.eclipse.jetty.resources", new HashSet());
        }
        if (context.getAttribute(METAINF_FRAGMENTS) == null) {
            context.setAttribute(METAINF_FRAGMENTS, new HashMap());
        }
        this.scanJars(context, context.getMetaData().getContainerResources(), useContainerCache, __allScanTypes);
        ArrayList<String> scanTypes = new ArrayList<String>(__allScanTypes);
        if (context.getMetaData().isMetaDataComplete() || context.getServletContext().getEffectiveMajorVersion() < 3 && !context.isConfigurationDiscovered()) {
            scanTypes.remove(METAINF_FRAGMENTS);
        }
        this.scanJars(context, context.getMetaData().getWebInfResources(false), false, scanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches) throws Exception {
        this.scanJars(context, jars, useCaches, __allScanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches, List<String> scanTypes) throws Exception {
        ConcurrentHashMap<Resource, Resource> metaInfResourceCache = null;
        ConcurrentHashMap<Resource, Resource> metaInfFragmentCache = null;
        ConcurrentHashMap<Resource, Collection<URL>> metaInfTldCache = null;
        if (useCaches) {
            metaInfResourceCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_RESOURCES);
            if (metaInfResourceCache == null) {
                metaInfResourceCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_RESOURCES, metaInfResourceCache);
            }
            if ((metaInfFragmentCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_FRAGMENTS)) == null) {
                metaInfFragmentCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_FRAGMENTS, metaInfFragmentCache);
            }
            if ((metaInfTldCache = (ConcurrentHashMap<Resource, Collection<URL>>)context.getServer().getAttribute(CACHED_CONTAINER_TLDS)) == null) {
                metaInfTldCache = new ConcurrentHashMap<Resource, Collection<URL>>();
                context.getServer().setAttribute(CACHED_CONTAINER_TLDS, metaInfTldCache);
            }
        }
        if (jars != null) {
            try (ResourceFactory.Closeable scanResourceFactory = ResourceFactory.closeable();){
                for (Resource dir : jars) {
                    block16: {
                        try {
                            if (dir.isDirectory()) break block16;
                            dir = scanResourceFactory.newJarFileResource(dir.getURI());
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    if (MetaInfConfiguration.isEmptyResource(dir)) continue;
                    if (scanTypes.contains("org.eclipse.jetty.resources")) {
                        this.scanForResources(context, dir, metaInfResourceCache);
                    }
                    if (scanTypes.contains(METAINF_FRAGMENTS)) {
                        this.scanForFragment(context, dir, metaInfFragmentCache);
                    }
                    if (!scanTypes.contains(METAINF_TLDS)) continue;
                    this.scanForTlds(context, dir, metaInfTldCache);
                }
            }
        }
    }

    public void scanForResources(WebAppContext context, Resource dir, ConcurrentHashMap<Resource, Resource> cache) {
        HashSet<Resource> dirs;
        if (MetaInfConfiguration.isEmptyResource(dir)) {
            return;
        }
        Resource resourcesDir = null;
        if (cache != null && cache.containsKey(dir)) {
            resourcesDir = cache.get(dir);
            if (MetaInfConfiguration.isEmptyResource(resourcesDir)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no META-INF/resources", (Object)dir);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/resources found in cache ", (Object)dir);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/resources checked", (Object)dir);
            }
            if (MetaInfConfiguration.isEmptyResource(resourcesDir = dir.resolve("/META-INF/resources"))) {
                return;
            }
            resourcesDir = context.getResourceFactory().newResource(resourcesDir.getURI());
            if (cache != null) {
                Resource old = cache.putIfAbsent(dir, resourcesDir);
                if (old != null) {
                    resourcesDir = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("{} META-INF/resources cache updated", (Object)dir);
                }
            }
        }
        if ((dirs = (HashSet<Resource>)context.getAttribute("org.eclipse.jetty.resources")) == null) {
            dirs = new HashSet<Resource>();
            context.setAttribute("org.eclipse.jetty.resources", dirs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added to context", (Object)resourcesDir);
        }
        dirs.add(resourcesDir);
    }

    private static boolean isEmptyResource(Resource resourcesDir) {
        return resourcesDir == null || !resourcesDir.isDirectory();
    }

    public void scanForFragment(WebAppContext context, Resource dir, ConcurrentHashMap<Resource, Resource> cache) {
        HashMap<Resource, Resource> fragments;
        Resource webFrag = null;
        if (cache != null && cache.containsKey(dir)) {
            webFrag = cache.get(dir);
            if (MetaInfConfiguration.isEmptyFragment(webFrag)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no META-INF/web-fragment.xml", (Object)dir);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/web-fragment.xml found in cache ", (Object)dir);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/web-fragment.xml checked", (Object)dir);
            }
            if (MetaInfConfiguration.isEmptyFragment(webFrag = dir.resolve("META-INF/web-fragment.xml"))) {
                return;
            }
            webFrag = context.getResourceFactory().newResource(webFrag.getURI());
            if (cache != null) {
                Resource old = cache.putIfAbsent(dir, webFrag);
                if (old != null) {
                    webFrag = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("{} META-INF/web-fragment.xml cache updated", (Object)dir);
                }
            }
        }
        if ((fragments = (HashMap<Resource, Resource>)context.getAttribute(METAINF_FRAGMENTS)) == null) {
            fragments = new HashMap<Resource, Resource>();
            context.setAttribute(METAINF_FRAGMENTS, fragments);
        }
        if (dir instanceof MountedPathResource) {
            dir = context.getResourceFactory().newResource(((MountedPathResource)dir).getContainerPath());
        }
        fragments.put(dir, webFrag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added to context", (Object)webFrag);
        }
    }

    private static boolean isEmptyFragment(Resource webFrag) {
        return !Resources.isReadableFile((Resource)webFrag);
    }

    public void scanForTlds(WebAppContext context, Resource dir, ConcurrentHashMap<Resource, Collection<URL>> cache) throws Exception {
        Collection<Object> tlds;
        if (MetaInfConfiguration.isEmptyResource(dir)) {
            return;
        }
        if (cache != null && cache.containsKey(dir)) {
            Collection<URL> tmp = cache.get(dir);
            if (tmp.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no tlds", (Object)dir);
                }
                return;
            }
            tlds = tmp;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} tlds found in cache ", (Object)dir);
            }
        } else {
            tlds = new HashSet<URL>();
            tlds.addAll(this.getTlds(context, dir));
            if (cache != null) {
                Collection<Object> old;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} tld cache updated", (Object)dir);
                }
                if ((old = cache.putIfAbsent(dir, tlds)) != null) {
                    tlds = old;
                }
            }
            if (tlds.isEmpty()) {
                return;
            }
        }
        HashSet<Object> metaInfTlds = (HashSet<Object>)context.getAttribute(METAINF_TLDS);
        if (metaInfTlds == null) {
            metaInfTlds = new HashSet<Object>();
            context.setAttribute(METAINF_TLDS, metaInfTlds);
        }
        metaInfTlds.addAll(tlds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tlds added to context");
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute("org.eclipse.jetty.resources", null);
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_TLDS, null);
    }

    private Collection<URL> getTlds(WebAppContext context, Resource dir) throws IOException {
        HashSet<URL> tlds = new HashSet<URL>();
        Resource metaInf = dir.resolve("META-INF");
        if (MetaInfConfiguration.isEmptyResource(metaInf)) {
            return tlds;
        }
        try (Stream<Path> stream = Files.walk(metaInf.getPath(), new FileVisitOption[0]);){
            Iterator it = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(FileID::isTld).iterator();
            while (it.hasNext()) {
                Path entry = (Path)it.next();
                tlds.add(entry.toUri().toURL());
            }
        }
        return tlds;
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        if (context == null) {
            return null;
        }
        ArrayList<Resource> classDirs = new ArrayList<Resource>();
        Resource webInfClasses = this.findWebInfClassesDir(context);
        if (webInfClasses != null) {
            classDirs.add(webInfClasses);
        }
        classDirs.addAll(this.findExtraClasspathDirs(context));
        return classDirs;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        jarResources.addAll(this.findWebInfLibJars(context));
        List<Resource> extraClasspathJars = this.findExtraClasspathJars(context);
        if (extraClasspathJars != null) {
            jarResources.addAll(extraClasspathJars);
        }
        return jarResources;
    }

    protected List<Resource> findWebInfLibJars(WebAppContext context) throws Exception {
        Resource webInfLib;
        if (context == null) {
            return List.of();
        }
        Resource webInf = context.getWebInf();
        if (Resources.isReadableDirectory((Resource)webInf) && Resources.isReadableDirectory((Resource)(webInfLib = webInf.resolve("lib")))) {
            return webInfLib.list().stream().filter(lib -> FileID.isLibArchive((String)lib.getFileName())).sorted(ResourceCollators.byName((boolean)true)).collect(Collectors.toList());
        }
        return List.of();
    }

    protected List<Resource> findExtraClasspathJars(WebAppContext context) throws Exception {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        return context.getExtraClasspath().stream().filter(this::isFileSupported).collect(Collectors.toList());
    }

    protected Resource findWebInfClassesDir(WebAppContext context) throws Exception {
        Resource classesDir;
        if (context == null) {
            return null;
        }
        Resource webInf = context.getWebInf();
        if (Resources.isReadableDirectory((Resource)webInf) && Resources.isReadableDirectory((Resource)(classesDir = webInf.resolve("classes/")))) {
            return classesDir;
        }
        return null;
    }

    protected List<Resource> findExtraClasspathDirs(WebAppContext context) {
        if (context == null || context.getExtraClasspath() == null) {
            return List.of();
        }
        return context.getExtraClasspath().stream().filter(Resource::isDirectory).collect(Collectors.toList());
    }

    private boolean isFileSupported(Resource resource) {
        return FileID.isLibArchive((URI)resource.getURI());
    }
}

