/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel.msg;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xerces.util.MessageFormatter;

public class XMLModelMessageFormatter
implements MessageFormatter {
    public static final String XML_MODEL_DOMAIN = "https://www.w3.org/TR/xml-model/";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;

    @Override
    public String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        Object msg;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != this.fLocale) {
            this.fResourceBundle = ResourceBundle.getBundle("org.eclipse.lemminx.extensions.xerces.xmlmodel.msg.XMLMessages", locale);
            this.fLocale = locale;
        }
        try {
            msg = this.fResourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format((String)msg, arguments);
                }
                catch (Exception e) {
                    msg = this.fResourceBundle.getString("FormatFailed");
                    msg = (String)msg + " " + this.fResourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = this.fResourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuilder str = new StringBuilder((String)msg);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(arguments[i]);
                }
            }
        }
        return msg;
    }
}

