/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.ext.base.Option;

public class ISequenceEventQuery {
    protected final ISequenceEvent event;

    public ISequenceEventQuery(ISequenceEvent event) {
        this.event = Objects.requireNonNull(event);
    }

    public boolean isAncestorOrSelf(ISequenceEvent child) {
        ISequenceEvent parentEvent;
        ISequenceEvent iSequenceEvent = this.event;
        boolean result = iSequenceEvent == null || child == null ? false : (iSequenceEvent.equals(child) ? true : (iSequenceEvent.equals(parentEvent = child.getParentEvent()) ? true : parentEvent != null && this.isAncestorOrSelf(parentEvent)));
        return result;
    }

    public boolean isReflectiveMessage() {
        Message message;
        ISequenceEvent iSequenceEvent = this.event;
        return iSequenceEvent instanceof Message && (message = (Message)iSequenceEvent).isReflective();
    }

    public boolean isObliqueMessage() {
        Message message;
        ISequenceEvent iSequenceEvent = this.event;
        return iSequenceEvent instanceof Message && (message = (Message)iSequenceEvent).isOblique();
    }

    public Set<ISequenceEvent> getAllDescendants() {
        return this.getAllDescendants(false, ISequenceEvent.ISEQUENCEEVENT_NOTATION_PREDICATE);
    }

    public Set<ISequenceEvent> getAllDescendants(boolean includeSelf) {
        return this.getAllDescendants(includeSelf, ISequenceEvent.ISEQUENCEEVENT_NOTATION_PREDICATE);
    }

    public Set<ISequenceEvent> getAllDescendants(boolean includeSelf, Predicate<? super View> predicate) {
        HashSet<ISequenceEvent> result = new HashSet<ISequenceEvent>();
        this.addAllDescendants(predicate, result);
        if (!includeSelf) {
            result.remove(this.event);
        }
        return result;
    }

    private void addAllDescendants(Predicate<? super View> predicate, Collection<ISequenceEvent> parts) {
        this.addAllDescendants(this.event, predicate, parts);
    }

    private void addAllDescendants(ISequenceEvent ise, Predicate<? super View> predicate, Collection<ISequenceEvent> parts) {
        Option<ISequenceEvent> iSequenceEvent;
        View element = ise.getNotationView();
        if (predicate.apply((Object)element) && (iSequenceEvent = ISequenceElementAccessor.getISequenceEvent(element)).some()) {
            parts.add((ISequenceEvent)iSequenceEvent.get());
        }
        for (ISequenceEvent childEvent : ise.getSubEvents()) {
            this.addAllDescendants(childEvent, predicate, parts);
        }
    }

    public Collection<Execution> getAllExecutions() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllDescendants(true, Execution.notationPredicate()), Execution.class));
    }

    public Set<Message> getAllMessages() {
        HashSet<Message> allMessages = new HashSet<Message>();
        allMessages.addAll(this.getAllMessagesFrom());
        allMessages.addAll(this.getAllMessagesTo());
        return allMessages;
    }

    public List<Message> getAllMessagesFrom() {
        ArrayList<Message> messagesParts = new ArrayList<Message>();
        this.addAllMessagesFrom(this.event.getNotationView(), messagesParts);
        return messagesParts;
    }

    public List<Message> getAllMessagesTo() {
        ArrayList<Message> messagesParts = new ArrayList<Message>();
        this.addAllMessagesTo(this.event.getNotationView(), messagesParts);
        return messagesParts;
    }

    private void addAllMessagesTo(View element, Collection<Message> messages) {
        for (Edge connectionPart : Iterables.filter((Iterable)Iterables.filter((Iterable)element.getTargetEdges(), Edge.class), Message.notationPredicate())) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)connectionPart);
            if (!message.some()) continue;
            messages.add((Message)message.get());
        }
        if (element instanceof Message) {
            messages.add((Message)element);
        }
        for (View child : Iterables.filter((Iterable)element.getChildren(), Node.class)) {
            this.addAllMessagesFrom(child, messages);
        }
    }

    private void addAllMessagesFrom(View element, Collection<Message> messages) {
        for (Edge connectionPart : Iterables.filter((Iterable)Iterables.filter((Iterable)element.getSourceEdges(), Edge.class), Message.notationPredicate())) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)connectionPart);
            if (!message.some()) continue;
            messages.add((Message)message.get());
        }
        if (element instanceof Message) {
            messages.add((Message)element);
        }
        for (View child : Iterables.filter((Iterable)element.getChildren(), Node.class)) {
            this.addAllMessagesFrom(child, messages);
        }
    }

    public Range getOccupiedRange() {
        Range range = Range.emptyRange();
        for (ISequenceEvent child : this.event.getSubEvents()) {
            Message msg;
            Range childRange = child.getVerticalRange();
            if (child instanceof Message && (msg = (Message)child).isOblique() && !msg.isReflective()) {
                if (msg.getSourceElement() == this.event) {
                    childRange = new Range(childRange.getLowerBound(), childRange.getLowerBound());
                } else if (msg.getTargetElement() == this.event) {
                    childRange = new Range(childRange.getUpperBound(), childRange.getUpperBound());
                }
            }
            range = range.union(childRange);
        }
        return range;
    }

    public Set<ISequenceEvent> getAllSequenceEventToMoveWith() {
        LinkedHashSet<ISequenceEvent> entryPoints = new LinkedHashSet<ISequenceEvent>();
        return this.getAllSequenceEventToMoveWith(entryPoints);
    }

    public Set<ISequenceEvent> getAllSequenceEventToMoveWith(Collection<ISequenceEvent> additionnalEntryPoints) {
        LinkedHashSet<ISequenceEvent> entryPoints = new LinkedHashSet<ISequenceEvent>();
        entryPoints.add(this.event);
        entryPoints.addAll(additionnalEntryPoints);
        LinkedHashSet<ISequenceEvent> moved = new LinkedHashSet<ISequenceEvent>();
        for (ISequenceEvent ise : entryPoints) {
            this.populateMovedElements(ise, moved);
        }
        return moved;
    }

    private void populateMovedElements(ISequenceEvent inspectedElement, Collection<ISequenceEvent> moved) {
        moved.add(inspectedElement);
        for (ISequenceEvent subEvent : Iterables.filter(inspectedElement.getEventsToMoveWith(), (Predicate)Predicates.not((Predicate)Predicates.in(moved)))) {
            this.populateMovedElements(subEvent, moved);
        }
    }
}

