/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.internal.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class BundledImageExtensionQuery {
    public static final String CUSTOM_BUNDLED_IMAGE_SHAPE_EXTENSION_POINT = "org.eclipse.sirius.diagram.customBundledImageShape";
    private static final BundledImageExtensionQuery INSTANCE = new BundledImageExtensionQuery();
    @Deprecated
    private static final String BUNDLED_IMAGE_SHAPE_EXTENSION_POINT = "org.eclipse.sirius.diagram.bundledImageShape";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String IMAGE_PATH_ATTRIBUTE = "imagePath";
    private IConfigurationElement[] extensions;

    private BundledImageExtensionQuery() {
        this.getExtensions();
    }

    public static BundledImageExtensionQuery getInstance() {
        return INSTANCE;
    }

    public IConfigurationElement[] getExtensions() {
        if (this.extensions == null) {
            IConfigurationElement[] newExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_BUNDLED_IMAGE_SHAPE_EXTENSION_POINT);
            IConfigurationElement[] oldExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor(BUNDLED_IMAGE_SHAPE_EXTENSION_POINT);
            IConfigurationElement[] allExtensionPoints = new IConfigurationElement[newExtensionPoints.length + oldExtensionPoints.length];
            int extensionsCount = 0;
            int i = 0;
            while (i < newExtensionPoints.length) {
                allExtensionPoints[extensionsCount] = newExtensionPoints[i];
                ++extensionsCount;
                ++i;
            }
            i = 0;
            while (i < oldExtensionPoints.length) {
                allExtensionPoints[extensionsCount] = oldExtensionPoints[i];
                ++extensionsCount;
                ++i;
            }
            this.extensions = allExtensionPoints;
        }
        return this.extensions;
    }

    public String getLabel(IConfigurationElement extension) {
        return extension.getAttribute(LABEL_ATTRIBUTE);
    }

    public String getImagePath(IConfigurationElement extension) {
        return extension.getAttribute(IMAGE_PATH_ATTRIBUTE);
    }

    public String getIdentifier(IConfigurationElement extension) {
        return ((ExtensionHandle)extension.getParent()).getUniqueIdentifier();
    }

    public List<String> getExtendedLabelsForVSM() {
        ArrayList<String> labels = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            labels.add(this.getExtendedLabelForVSM(configurationElement));
            ++n2;
        }
        return labels;
    }

    public String getExtendedLabelForVSM(String providedShapeID) {
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String identifier = ((ExtensionHandle)configurationElement.getParent()).getUniqueIdentifier();
            if (identifier != null && identifier.equals(providedShapeID)) {
                return this.getExtendedLabelForVSM(configurationElement);
            }
            ++n2;
        }
        return "Unknown ID";
    }

    private String getExtendedLabelForVSM(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute(LABEL_ATTRIBUTE) + " - " + configurationElement.getNamespaceIdentifier();
    }

    public IConfigurationElement getExtensionDefiningProvidedShapeID(String providedShapeID) {
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String identifier = ((ExtensionHandle)configurationElement.getParent()).getUniqueIdentifier();
            if (identifier != null && identifier.equals(providedShapeID)) {
                return configurationElement;
            }
            ++n2;
        }
        return null;
    }

    public String findParameterInExtension(IConfigurationElement configurationElement, String parameter) {
        if (configurationElement != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren(parameter);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElementChild = iConfigurationElementArray[n2];
                if (configurationElementChild.getAttribute(parameter) != null) {
                    return configurationElementChild.getAttribute(parameter);
                }
                ++n2;
            }
        }
        return null;
    }
}

