/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.wst.json.ui.internal.ColorTypesHelper;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.json.ui.internal.contentoutline.JFaceNodeAdapter;
import org.eclipse.wst.json.ui.internal.contentoutline.RefreshStructureJob;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class JFaceNodeAdapterFactory
extends AbstractAdapterFactory
implements IJFaceNodeAdapterFactory {
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    private Set fListeners = new HashSet();
    protected INodeAdapter singletonAdapter;
    private Map<String, StyledString.Styler> stylers;

    public JFaceNodeAdapterFactory() {
        this(IJFaceNodeAdapter.class, true);
    }

    public JFaceNodeAdapterFactory(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
    }

    public synchronized void addListener(Object listener) {
        this.fListeners.add(listener);
    }

    public INodeAdapterFactory copy() {
        return new JFaceNodeAdapterFactory(this.getAdapterKey(), this.isShouldRegisterAdapter());
    }

    protected INodeAdapter createAdapter(INodeNotifier node) {
        if (this.singletonAdapter == null) {
            this.singletonAdapter = new JFaceNodeAdapter(this);
            this.initAdapter(this.singletonAdapter, node);
        }
        return this.singletonAdapter;
    }

    public synchronized Collection getListeners() {
        return new ArrayList(this.fListeners);
    }

    protected void initAdapter(INodeAdapter adapter, INodeNotifier node) {
    }

    public void release() {
        RefreshStructureJob refreshJob;
        this.unRegisterPreferenceManager();
        this.fListeners.clear();
        if (this.singletonAdapter != null && this.singletonAdapter instanceof JFaceNodeAdapter && (refreshJob = ((JFaceNodeAdapter)this.singletonAdapter).fRefreshJob) != null) {
            refreshJob.cancel();
        }
    }

    public synchronized void removeListener(Object listener) {
        this.fListeners.remove(listener);
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        ColorTypesHelper.getNewStyle(event);
    }

    private void registerPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void unRegisterPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void addStyler(String regionType) {
        String prefString;
        String[] stylePrefs;
        String colorKey = ColorTypesHelper.getColor(regionType);
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getColorPreferences().getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            RGBStyler styler = new RGBStyler(foreground, background);
            this.getStylers().put(regionType, styler);
        }
    }

    protected Map<String, StyledString.Styler> getStylers() {
        if (this.stylers == null) {
            this.stylers = new HashMap<String, StyledString.Styler>();
        }
        return this.stylers;
    }

    public StyledString.Styler getStyler(String type) {
        if (this.stylers == null) {
            this.addStyler("JSON_VALUE_BOOLEAN");
            this.addStyler("JSON_VALUE_NULL");
            this.addStyler("JSON_VALUE_NUMBER");
            this.addStyler("JSON_VALUE_STRING");
        }
        return this.stylers.get(type);
    }

    protected IPreferenceStore getColorPreferences() {
        return JSONUIPlugin.getDefault().getPreferenceStore();
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JFaceNodeAdapterFactory.this.handlePropertyChange(event);
        }
    }

    private static class RGBStyler
    extends StyledString.Styler {
        private final RGB fForegroundColorName;
        private final RGB fBackgroundColorName;

        public RGBStyler(RGB foregroundColorName, RGB backgroundColorName) {
            this.fForegroundColorName = foregroundColorName;
            this.fBackgroundColorName = backgroundColorName;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.fForegroundColorName != null) {
                textStyle.foreground = EditorUtility.getColor((RGB)this.fForegroundColorName);
            }
            if (this.fBackgroundColorName != null) {
                textStyle.background = EditorUtility.getColor((RGB)this.fBackgroundColorName);
            }
        }
    }
}

