/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import java.util.ArrayList;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RemoteUIHelper {
    public static void editConnectionDialog(IRemoteConnection connection, Shell shell) {
        if (connection == null) {
            return;
        }
        IRemoteUIConnectionService uiConnServices = (IRemoteUIConnectionService)connection.getConnectionType().getService(IRemoteUIConnectionService.class);
        IRemoteUIConnectionWizard wizard = uiConnServices.getConnectionWizard(shell);
        wizard.setConnection(connection.getWorkingCopy());
        IRemoteConnectionWorkingCopy connCopy = wizard.open();
        if (connCopy != null) {
            try {
                connCopy.save();
            }
            catch (RemoteConnectionException e) {
                RemoteUIHelper.logError((Exception)((Object)e));
            }
        }
    }

    public static void newConnectionDialog(Shell shell) {
        class NewRemoteConnectionDialog
        extends Dialog {
            private String title;
            private Combo fConnSelection;
            private IRemoteServicesManager manager;

            protected NewRemoteConnectionDialog(Shell parentShell, String windowTitle) {
                super(parentShell);
                this.title = windowTitle;
                this.manager = Activator.getService(IRemoteServicesManager.class);
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(this.title);
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Label label = new Label(composite, 64);
                label.setText(Messages.RemoteCMainTab_New_conntype_combo_label);
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
                this.fConnSelection = new Combo(composite, 12);
                ArrayList<String> suitableConnections = new ArrayList<String>();
                for (IRemoteConnectionType type : this.manager.getAllConnectionTypes()) {
                    if (!type.canAdd() || !type.getConnectionServices().contains(IRemoteCommandShellService.class.getName())) continue;
                    this.fConnSelection.setData(type.getName(), (Object)type.getId());
                    suitableConnections.add(type.getName());
                }
                this.fConnSelection.setItems(suitableConnections.toArray(new String[0]));
                this.fConnSelection.select(0);
                NewRemoteConnectionDialog.applyDialogFont((Control)composite);
                return composite;
            }

            protected void buttonPressed(int buttonId) {
                String connTypeId;
                IRemoteConnectionType connType;
                IRemoteUIConnectionService fUIConnectionManager;
                IRemoteUIConnectionWizard wizard;
                IRemoteConnectionWorkingCopy wc;
                if (buttonId == 0 && (wc = (wizard = (fUIConnectionManager = (IRemoteUIConnectionService)(connType = this.manager.getConnectionType(connTypeId = (String)this.fConnSelection.getData(this.fConnSelection.getText()))).getService(IRemoteUIConnectionService.class)).getConnectionWizard(this.getShell())).open()) != null) {
                    try {
                        wc.save();
                    }
                    catch (RemoteConnectionException e) {
                        RemoteUIHelper.logError((Exception)((Object)e));
                    }
                }
                super.buttonPressed(buttonId);
            }
        }
        NewRemoteConnectionDialog dlg = new NewRemoteConnectionDialog(shell, Messages.RemoteCMainTab_New_title);
        dlg.setBlockOnOpen(true);
        dlg.open();
    }

    public static String getConnectionProperty(IRemoteConnection connection, String property) {
        String key = "org.eclipse.cdt.launch.remote.attr." + property;
        return connection.getAttribute(key);
    }

    public static void setConnectionProperty(IRemoteConnection connection, String property, String value) {
        String key = "org.eclipse.cdt.launch.remote.attr." + property;
        IRemoteConnectionWorkingCopy wc = connection.getWorkingCopy();
        wc.setAttribute(key, value);
        try {
            wc.save();
        }
        catch (RemoteConnectionException e) {
            RemoteUIHelper.logError((Exception)((Object)e));
        }
    }

    private static void logError(Exception e) {
        Activator plugin = Activator.getDefault();
        ILog logger = plugin.getLog();
        logger.log((IStatus)new Status(4, "org.eclipse.cdt.launch.remote", e.getMessage(), (Throwable)e));
    }
}

