/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.util.HashSet;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.cdt.make.internal.ui.MakeTargetsContainer;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class MakeNavContentProvider
implements ITreeContentProvider,
IMakeTargetListener {
    private StructuredViewer viewer;

    public MakeNavContentProvider() {
        MakeCorePlugin.getDefault().getTargetManager().addListener((IMakeTargetListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            return this.getContainer(container);
        }
        if (parentElement instanceof ICContainer) {
            IContainer container = ((ICContainer)parentElement).getResource();
            return this.getContainer(container);
        }
        if (parentElement instanceof MakeTargetsContainer) {
            return ((MakeTargetsContainer)((Object)parentElement)).getTargets();
        }
        return new Object[0];
    }

    private MakeTargetsContainer[] getContainer(IContainer container) {
        try {
            IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets(container);
            if (targets != null && targets.length > 0) {
                return new MakeTargetsContainer[]{new MakeTargetsContainer(container, targets)};
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.log(e.getStatus());
        }
        return new MakeTargetsContainer[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IMakeTarget || element instanceof MakeTargetsContainer) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IContainer || element instanceof ICContainer || element instanceof MakeTargetsContainer;
    }

    public void targetChanged(MakeTargetEvent event) {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        switch (event.getType()) {
            case 1: 
            case 3: {
                HashSet<IContainer> elements = new HashSet<IContainer>();
                IMakeTarget[] iMakeTargetArray = event.getTargets();
                int n = iMakeTargetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMakeTarget target = iMakeTargetArray[n2];
                    IContainer container = target.getContainer();
                    elements.add(container);
                    ++n2;
                }
                if (elements.isEmpty()) break;
                this.viewer.getControl().getDisplay().asyncExec(() -> {
                    for (Object element : elements) {
                        this.viewer.refresh(element);
                    }
                });
            }
        }
    }
}

