/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class InsertLocation {
    private IASTNode nodeToInsertAfter;
    private IASTNode nodeToInsertBefore;
    private IASTNode parentNode;
    private ITranslationUnit tu;

    public boolean hasAnyNode() {
        return this.nodeToInsertAfter != null || this.nodeToInsertBefore != null;
    }

    public IASTNode getNodeToInsertBefore() {
        return this.nodeToInsertBefore;
    }

    public IASTNode getParentOfNodeToInsertBefore() throws CoreException {
        IASTNode node = this.nodeToInsertBefore != null ? this.nodeToInsertBefore : this.nodeToInsertAfter;
        return node != null ? node.getParent() : this.parentNode;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.tu;
    }

    public IFile getFile() {
        return this.tu != null ? (IFile)this.tu.getResource() : null;
    }

    public int getInsertPosition() {
        if (this.nodeToInsertBefore != null) {
            return this.nodeToInsertBefore.getFileLocation().getNodeOffset();
        }
        if (this.nodeToInsertAfter != null) {
            IASTFileLocation fileLocation = this.nodeToInsertAfter.getFileLocation();
            return fileLocation.getNodeOffset() + fileLocation.getNodeLength();
        }
        if (this.parentNode != null) {
            return this.parentNode.getFileLocation().getNodeOffset();
        }
        return 0;
    }

    public void setNodeToInsertAfter(IASTNode nodeToInsertAfter, ITranslationUnit tu) {
        this.nodeToInsertAfter = nodeToInsertAfter;
        this.tu = tu;
    }

    public void setNodeToInsertBefore(IASTNode nodeToInsertBefore, ITranslationUnit tu) {
        this.nodeToInsertBefore = nodeToInsertBefore;
        this.tu = tu;
    }

    public void setParentNode(IASTNode parentNode, ITranslationUnit tu) {
        this.parentNode = parentNode;
        this.tu = tu;
    }
}

