/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.QuerySelectImpl;
import org.eclipse.datatools.modelbase.sql.query.impl.QueryStatementImpl;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DeleteHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.RDBTableDropListener;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.GraphContextMenuProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.SQLRootEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.TableEditPart;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class GraphControl
extends ContentViewer {
    protected SQLDomainModel domainModel;
    protected EditDomain editDomain;
    protected Control control;
    protected ScrollingGraphicalViewer graphView;
    private SQLBuilder sqlBuilder;
    Label label = null;
    Composite labelComp;
    SQLRootEditPart currentPart = null;
    SQLQueryObject currentStatement = null;

    public GraphControl(SQLDomainModel domainModel) {
        this.domainModel = domainModel;
        this.graphView = new ScrollingGraphicalViewer();
        GraphicalViewerKeyHandler graphKeyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)this.graphView);
        this.graphView.setKeyHandler((KeyHandler)graphKeyHandler);
        this.editDomain = new DefaultEditDomain(null);
        ((DefaultEditDomain)this.editDomain).setDefaultTool((Tool)new SelectionTool());
        this.editDomain.loadDefaultTool();
        this.editDomain.addViewer((EditPartViewer)this.graphView);
        GraphContextMenuProvider menuHandler = new GraphContextMenuProvider((EditPartViewer)this.graphView, domainModel);
        this.graphView.setContextMenu((MenuManager)menuHandler);
        this.setContentProvider((IContentProvider)domainModel.createContentProvider());
    }

    public Control getControl() {
        return this.labelComp;
    }

    protected String getTextForUserPrompt() {
        return Messages._UI_GRAPH_PROMPT;
    }

    protected void giveUserPrompt() {
        List tableList = this.currentPart.getModelChildren();
        if (tableList != null && tableList.size() != 0) {
            if (this.label != null) {
                if (this.currentPart.getFigure().getChildren().contains(this.label)) {
                    this.currentPart.getFigure().remove((IFigure)this.label);
                }
                this.label = null;
                if (this.currentStatement instanceof QueryStatementImpl || this.currentStatement instanceof QuerySelectImpl) {
                    this.domainModel.setImproperStatement(null);
                }
                if (this.sqlBuilder != null) {
                    this.sqlBuilder.updateProperStatement(true);
                    this.sqlBuilder.reloadFromModel();
                }
            }
        } else if (this.label == null && this.control.isEnabled()) {
            String userPromptText = this.getTextForUserPrompt();
            this.label = new Label(userPromptText);
            this.currentPart.getFigure().add((IFigure)this.label);
            this.label.setSize(this.label.getTextBounds().getSize());
            this.label.setLocation(new Point(5, 5));
        }
    }

    public void refresh() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphControl.this.currentPart != null) {
                    GraphControl.this.giveUserPrompt();
                    GraphControl.this.currentPart.update(null, null);
                }
            }
        });
    }

    public void updateForDND() {
        if (this.label != null) {
            this.label.setText("");
        }
        this.currentPart.update(null, null);
        this.sqlBuilder.getSourceViewer().refreshSource();
        this.sqlBuilder.getSourceViewer().setTextDirty(true);
        boolean changed = this.sqlBuilder.getSourceViewer().isTextChanged();
        this.sqlBuilder.getSourceViewer().setTextChanged(false);
        this.getControl().setFocus();
        this.sqlBuilder.getSourceViewer().setTextChanged(changed);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void createControl(Composite comp) {
        this.labelComp = new Composite(comp, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.marginHeight = 0;
        compLayout.marginWidth = 0;
        this.labelComp.setLayout((Layout)compLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.labelComp.setLayoutData((Object)data);
        this.control = this.graphView.createControl(this.labelComp);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.control.setLayoutData((Object)data);
        int operations = 7;
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTarget target = new DropTarget(this.control, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new RDBTableDropListener((Viewer)this, this.domainModel));
        new HoverTrackAdapter(this.control);
        this.control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.character == '\u007f') {
                    QueryStatement statement = GraphControl.this.domainModel.getSQLStatement();
                    List selectedEditParts = GraphControl.this.graphView.getSelectedEditParts();
                    EditPart part = null;
                    Iterator iter = null;
                    if (selectedEditParts != null && !selectedEditParts.isEmpty()) {
                        part = (EditPart)selectedEditParts.get(0);
                    }
                    if (part instanceof TableEditPart) {
                        if (statement instanceof QuerySelectStatement || statement instanceof QuerySelect) {
                            iter = selectedEditParts.iterator();
                            while (iter.hasNext()) {
                                TableExpression table = (TableExpression)((TableEditPart)iter.next()).getModel();
                                TableJoined joinedTable = table.getTableJoinedLeft();
                                if (joinedTable == null) {
                                    joinedTable = table.getTableJoinedRight();
                                }
                                if (joinedTable != null) {
                                    EList fromClauseList;
                                    if (statement instanceof QuerySelect) {
                                        fromClauseList = ((QuerySelect)statement).getFromClause();
                                        JoinHelper.removeJoinsForTable((List)fromClauseList, (TableExpression)table);
                                    } else if (statement instanceof QuerySelectStatement) {
                                        QuerySelect querySelect = SelectHelper.getQuerySelect((QuerySelectStatement)statement);
                                        fromClauseList = querySelect.getFromClause();
                                        JoinHelper.removeJoinsForTable((List)fromClauseList, (TableExpression)table);
                                    }
                                }
                                StatementHelper.removeTableExpressionFromQueryStatement((TableExpression)table, (SQLQueryObject)statement);
                            }
                            SelectHelper.refresh((SQLQueryObject)statement);
                            GraphControl.this.refresh();
                        } else if (statement instanceof QueryInsertStatement) {
                            String name = statement.getName();
                            String stmtlabel = statement.getLabel();
                            InsertHelper.clearStatementContents((QueryInsertStatement)statement);
                            statement.setName(name);
                            statement.setLabel(stmtlabel);
                        } else if (statement instanceof QueryUpdateStatement) {
                            String name = statement.getName();
                            String stmtlabel = statement.getLabel();
                            UpdateHelper.clearStatementContents((QueryUpdateStatement)statement);
                            statement.setName(name);
                            statement.setLabel(stmtlabel);
                        } else if (statement instanceof QueryDeleteStatement) {
                            String name = statement.getName();
                            String stmtlabel = statement.getLabel();
                            DeleteHelper.clearStatementContents((QueryDeleteStatement)statement);
                            statement.setName(name);
                            statement.setLabel(stmtlabel);
                        }
                    }
                }
            }
        });
        this.control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IFigure fig = GraphControl.this.currentPart.getFigure();
                fig.setBorder((Border)new InFocusBorder());
                fig.repaint();
            }

            public void focusLost(FocusEvent e) {
                IFigure fig = GraphControl.this.currentPart.getFigure();
                fig.setBorder(null);
                fig.repaint();
                for (AbstractEditPart element : GraphControl.this.currentPart.getChildren()) {
                    element.setSelected(0);
                }
            }

            class InFocusBorder
            extends FocusBorder {
                InFocusBorder() {
                }

                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                    tempRect.setBounds(InFocusBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
                    Point origin = tempRect.getLocation();
                    tempRect.setLocation(origin.x + 1, origin.y + 1);
                    InFocusBorder.tempRect.width -= 3;
                    InFocusBorder.tempRect.height -= 3;
                    graphics.setXORMode(true);
                    graphics.setForegroundColor(ColorConstants.white);
                    graphics.setBackgroundColor(ColorConstants.blue);
                    graphics.drawFocus(tempRect);
                }
            }
        });
        this.hookControl(this.control);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.currentPart = null;
    }

    public void setInput(Object o) {
        super.setInput(o);
        if (o instanceof QueryStatement || o instanceof QuerySelect) {
            if (this.currentPart != null && (this.currentPart.getModel() instanceof QueryStatement && o instanceof QuerySelect || this.currentPart.getModel() instanceof QuerySelect && o instanceof QueryStatement)) {
                this.currentPart = null;
            }
            if (this.currentPart == null) {
                this.currentPart = new SQLRootEditPart(this.domainModel);
                this.currentPart.setModel(o);
                this.graphView.setContents((EditPart)this.currentPart);
                this.graphView.setSelection((ISelection)new StructuredSelection((Object)this.currentPart));
                this.currentPart.getFigure().setBounds(new Rectangle(this.graphView.getControl().getBounds()));
                this.currentStatement = (SQLQueryObject)o;
                this.refresh();
                return;
            }
            if (this.currentStatement == o) {
                this.currentPart.getFigure().invalidate();
            } else {
                this.currentPart.setModel(o);
                this.currentStatement = (SQLQueryObject)o;
            }
            this.currentPart.refresh();
        }
    }

    public void setSQLBuilder(SQLBuilder sb) {
        this.sqlBuilder = sb;
    }

    public void setEnabled(boolean enable) {
        this.control.setEnabled(enable);
        if (enable) {
            this.currentPart.getFigure().setBackgroundColor(Display.getCurrent().getSystemColor(1));
            this.refresh();
        } else {
            this.currentPart.getFigure().setBackgroundColor(this.control.getBackground());
            this.refresh();
        }
    }

    public boolean isEnabled() {
        if (this.currentPart == null) {
            return false;
        }
        return !this.currentPart.getFigure().getBackgroundColor().equals((Object)this.control.getBackground());
    }

    public class HoverTrackAdapter
    extends MouseTrackAdapter
    implements MouseMoveListener,
    MouseListener {
        protected ColumnEditPart currentColumnPart = null;
        protected Control adaptedControl;
        boolean isMouseDown = false;

        public HoverTrackAdapter(Control control) {
            this.adaptedControl = control;
            this.adaptedControl.addMouseListener((MouseListener)this);
            this.adaptedControl.addMouseTrackListener((MouseTrackListener)this);
            this.adaptedControl.addMouseMoveListener((MouseMoveListener)this);
        }

        public void mouseExit(MouseEvent e) {
            this.adaptedControl.setToolTipText(null);
            this.currentColumnPart = null;
        }

        public void mouseMove(MouseEvent e) {
            EditPart part;
            if (!(this.isMouseDown || this.currentColumnPart != null && this.currentColumnPart.getFigure().containsPoint(new Point(e.x, e.y)) || (part = GraphControl.this.graphView.findObjectAt(new Point(e.x, e.y))) == this.currentColumnPart)) {
                this.adaptedControl.setToolTipText(null);
                if (part instanceof ColumnEditPart) {
                    this.currentColumnPart = (ColumnEditPart)part;
                    String tooltip = this.currentColumnPart.getToolTip();
                    this.adaptedControl.setToolTipText(tooltip);
                } else {
                    this.currentColumnPart = null;
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            this.isMouseDown = false;
        }

        public void mouseDown(MouseEvent e) {
            this.adaptedControl.setToolTipText(null);
            this.currentColumnPart = null;
            this.isMouseDown = true;
        }
    }
}

