/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class XDoxletAnnotationUtil {
    private static final String XDOCLET_EJB_BEAN_TAG = "@ejb.bean";
    private static final String XDOCLET_WEB_TAG = "@web";

    public static boolean isXDocletAnnotatedResource(IResource resource) {
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
        return XDoxletAnnotationUtil.isXDocletAnnotated((IJavaElement)compilationUnit);
    }

    public static boolean isXDocletAnnotatedEjbClass(IJavaElement compilationUnit) {
        if (compilationUnit != null && compilationUnit.getElementType() == 5) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource((ICompilationUnit)compilationUnit);
            CompilationUnit ast = (CompilationUnit)parser.createAST(null);
            XDocletFinder docletFinder = new XDocletFinder(true);
            ast.accept((ASTVisitor)docletFinder);
            return docletFinder.isXDocletBean;
        }
        return false;
    }

    public static boolean isXDocletAnnotatedWebClass(IJavaElement compilationUnit) {
        if (compilationUnit != null && compilationUnit.getElementType() == 5) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource((ICompilationUnit)compilationUnit);
            CompilationUnit ast = (CompilationUnit)parser.createAST(null);
            XDocletFinder docletFinder = new XDocletFinder(true);
            ast.accept((ASTVisitor)docletFinder);
            return docletFinder.isXDocletWebBean;
        }
        return false;
    }

    public static boolean isXDocletAnnotated(IJavaElement compilationUnit) {
        if (compilationUnit != null && compilationUnit.getElementType() == 5) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource((ICompilationUnit)compilationUnit);
            CompilationUnit ast = (CompilationUnit)parser.createAST(null);
            XDocletFinder docletFinder = new XDocletFinder(true);
            ast.accept((ASTVisitor)docletFinder);
            return docletFinder.isXDocletWebBean || docletFinder.isXDocletBean;
        }
        return false;
    }

    public static class XDocletFinder
    extends ASTVisitor {
        boolean isXDocletBean = false;
        boolean isXDocletWebBean = false;

        public XDocletFinder(boolean visitDocTags) {
            super(visitDocTags);
        }

        public boolean visit(TypeDeclaration type) {
            if (type.getJavadoc() == null) {
                return true;
            }
            for (TagElement element : type.getJavadoc().tags()) {
                if (XDoxletAnnotationUtil.XDOCLET_EJB_BEAN_TAG.equals(element.getTagName())) {
                    this.isXDocletBean = true;
                    return false;
                }
                if (element.getTagName() == null || !element.getTagName().startsWith(XDoxletAnnotationUtil.XDOCLET_WEB_TAG)) continue;
                this.isXDocletWebBean = true;
                return false;
            }
            return true;
        }
    }
}

