/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version;

import java.util.List;
import java.util.Set;
import org.eclipse.oomph.version.IElementResolver;
import org.osgi.framework.Version;

public interface IElement {
    public Type getType();

    public String getTag();

    public String getName();

    public String getID();

    public Version getVersion();

    public Version getResolvedVersion();

    public boolean isFragment();

    public boolean isLicenseFeature();

    public List<IElement> getChildren();

    public Set<IElement> getAllChildren(IElementResolver var1, IElementResolver var2);

    public IElement getChild(IElementResolver var1, IElementResolver var2, IElement var3);

    public IElement trimVersion();

    public boolean isVersionUnresolved();

    public static enum Type {
        PRODUCT{

            @Override
            public String getTag() {
                return "products";
            }

            public String toString() {
                return "Product";
            }
        }
        ,
        FEATURE{

            @Override
            public String getTag() {
                return "includes";
            }

            public String toString() {
                return "Feature";
            }
        }
        ,
        PLUGIN{

            @Override
            public String getTag() {
                return "plugin";
            }

            public String toString() {
                return "Plug-in";
            }
        };


        public abstract String getTag();
    }
}

