/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableNetworkConfig;
import org.mandas.docker.client.messages.Ipam;

@JsonDeserialize(builder=ImmutableNetworkConfig.Builder.class)
@Value.Immutable
public interface NetworkConfig {
    @JsonProperty(value="Name")
    public String name();

    @JsonProperty(value="Driver")
    @Nullable
    public String driver();

    @JsonProperty(value="IPAM")
    @Nullable
    public Ipam ipam();

    @JsonProperty(value="Options")
    public Map<String, String> options();

    @JsonProperty(value="CheckDuplicate")
    @Nullable
    public Boolean checkDuplicate();

    @JsonProperty(value="Internal")
    @Nullable
    public Boolean internal();

    @JsonProperty(value="EnableIPv6")
    @Nullable
    public Boolean enableIPv6();

    @JsonProperty(value="Attachable")
    @Nullable
    public Boolean attachable();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    public static Builder builder() {
        return ImmutableNetworkConfig.builder();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder addOption(String var1, String var2);

        public Builder options(Map<String, ? extends String> var1);

        public Builder ipam(Ipam var1);

        public Builder driver(String var1);

        public Builder checkDuplicate(Boolean var1);

        public Builder internal(Boolean var1);

        public Builder enableIPv6(Boolean var1);

        public Builder attachable(Boolean var1);

        public Builder labels(Map<String, ? extends String> var1);

        public NetworkConfig build();
    }
}

