/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeDeclarationsIR;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Es6TypedToEs6Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType CANNOT_CONVERT_MEMBER_VARIABLES = DiagnosticType.error("JSC_CANNOT_CONVERT_FIELDS", "Can only convert class member variables (fields) in declarations or the right hand side of a simple assignment.");
    static final DiagnosticType CANNOT_CONVERT_BOUNDED_GENERICS = DiagnosticType.warning("JSC_CANNOT_CONVERT_BOUNDED_GENERICS", "Bounded generics are not yet implemented.");
    static final DiagnosticType TYPE_ALIAS_ALREADY_DECLARED = DiagnosticType.error("JSC_TYPE_ALIAS_ALREADY_DECLARED", "Type alias already declared as a variable: {0}");
    static final DiagnosticType TYPE_QUERY_NOT_SUPPORTED = DiagnosticType.warning("JSC_TYPE_QUERY_NOT_SUPPORTED", "Type query is currently not supported.");
    static final DiagnosticType UNSUPPORTED_RECORD_TYPE = DiagnosticType.error("JSC_UNSUPPORTED_RECORD_TYPE", "Currently only member variables are supported in record types, please consider using interfaces instead.");
    static final DiagnosticType COMPUTED_PROP_ACCESS_MODIFIER = DiagnosticType.warning("JSC_COMPUTED_PROP_ACCESS_MODIFIER", "Accessibility is not checked on computed properties");
    static final DiagnosticType NON_AMBIENT_NAMESPACE_NOT_SUPPORTED = DiagnosticType.error("JSC_NON_AMBIENT_NAMESPACE_NOT_SUPPORTED", "Non-ambient namespaces are not supported");
    static final DiagnosticType CALL_SIGNATURE_NOT_SUPPORTED = DiagnosticType.error("JSC_CALL_SIGNATURE_NOT_SUPPORTED", "Call signature and construct signatures are not supported yet");
    static final DiagnosticType OVERLOAD_NOT_SUPPORTED = DiagnosticType.warning("JSC_OVERLOAD_NOT_SUPPORTED", "Function and method overloads are not supported and type information might be lost");
    static final DiagnosticType SPECIALIZED_SIGNATURE_NOT_SUPPORTED = DiagnosticType.warning("JSC_SPECIALIZED_SIGNATURE_NOT_SUPPORTED", "Specialized signatures are not supported and type information might be lost");
    static final DiagnosticType DECLARE_IN_NON_EXTERNS = DiagnosticType.warning("JSC_DECLARE_IN_NON_EXTERNS", "Found a declare statement in program code.\nIf you are generating externs, this should be fine.\nIf not, make sure to pass your .d.ts file as an extern file.");
    private final AbstractCompiler compiler;
    private final Map<Node, Namespace> nodeNamespaceMap;
    private final Set<String> convertedNamespaces;
    private Namespace currNamespace;
    private final Deque<Map<String, Node>> overloadStack;
    private final Set<Node> processedOverloads;

    Es6TypedToEs6Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.nodeNamespaceMap = new HashMap<Node, Namespace>();
        this.convertedNamespaces = new HashSet<String>();
        this.overloadStack = new ArrayDeque<Map<String, Node>>();
        this.processedOverloads = new HashSet<Node>();
    }

    @Override
    public void process(Node externs, Node scriptRoot) {
        ScanNamespaces scanner = new ScanNamespaces();
        NodeTraversal.traverseEs6(this.compiler, externs, scanner);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, scanner);
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        ScanNamespaces scanner = new ScanNamespaces();
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, scanner);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 172: {
                if (this.currNamespace == null && parent.getType() != 318) {
                    this.compiler.report(JSError.make(n, NON_AMBIENT_NAMESPACE_NOT_SUPPORTED, new String[0]));
                    return false;
                }
                this.currNamespace = this.nodeNamespaceMap.get(n);
                this.pushOverloads();
                return true;
            }
            case 132: 
            case 158: 
            case 311: {
                this.pushOverloads();
                return true;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 158: {
                this.visitClass(n, parent);
                this.popOverloads();
                break;
            }
            case 311: {
                this.visitInterface(n, parent);
                this.popOverloads();
                break;
            }
            case 314: {
                this.visitEnum(n, parent);
                break;
            }
            case 38: 
            case 173: {
                this.maybeVisitColonType(n, n);
                break;
            }
            case 105: {
                this.visitFunction(n, parent);
                break;
            }
            case 317: {
                this.visitTypeAlias(t, n, parent);
                break;
            }
            case 318: {
                this.visitAmbientDeclaration(n, parent);
                break;
            }
            case 169: {
                this.visitExport(n, parent);
                break;
            }
            case 172: {
                this.visitNamespaceDeclaration(n, parent);
                this.popOverloads();
                break;
            }
            case 118: 
            case 149: 
            case 162: {
                this.visitVarInsideNamespace(n, parent);
                break;
            }
            case 132: {
                this.popOverloads();
                break;
            }
        }
    }

    private void visitNamespaceDeclaration(Node n, Node parent) {
        this.popNamespace(n, parent);
        for (Node name = NodeUtil.getRootOfQualifiedName(n.getFirstChild()); name != n; name = name.getParent()) {
            String fullName = this.maybePrependCurrNamespace(name.getQualifiedName());
            if (this.convertedNamespaces.contains(fullName)) continue;
            JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
            doc.recordConstancy();
            Node namespaceDec = NodeUtil.newQNameDeclaration(this.compiler, fullName, IR.objectlit(new Node[0]), doc.build()).useSourceInfoFromForTree(n);
            parent.addChildBefore(namespaceDec, n);
            this.convertedNamespaces.add(fullName);
        }
        this.replaceWithNodes(n, n.getLastChild().children());
    }

    private void maybeAddGenerics(Node n, Node jsDocNode) {
        Node name = n.getFirstChild();
        Node generics = (Node)name.getProp(81);
        if (generics != null) {
            JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(jsDocNode.getJSDocInfo());
            for (Node typeName : generics.children()) {
                doc.recordTemplateTypeName(typeName.getString());
                if (!typeName.hasChildren()) continue;
                this.compiler.report(JSError.make(name, CANNOT_CONVERT_BOUNDED_GENERICS, new String[0]));
                typeName.removeChildren();
            }
            name.removeProp(81);
            jsDocNode.setJSDocInfo(doc.build());
        }
    }

    private void visitClass(Node n, Node parent) {
        Node superType;
        Node newSuperType;
        this.maybeAddGenerics(n, n);
        JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        Node interfaces = (Node)n.getProp(82);
        if (interfaces != null) {
            for (Node child : interfaces.children()) {
                Node type = this.convertWithLocation(child);
                doc.recordImplementedInterface(new JSTypeExpression(type, n.getSourceFileName()));
            }
            n.removeProp(82);
        }
        if ((newSuperType = this.maybeGetQualifiedNameNode(superType = n.getSecondChild())) != superType) {
            n.replaceChild(superType, newSuperType);
        }
        Node classMembers = n.getLastChild();
        Es6ToEs3Converter.ClassDeclarationMetadata metadata = Es6ToEs3Converter.ClassDeclarationMetadata.create(n, parent);
        for (Node member : classMembers.children()) {
            if (member.isCallSignature()) {
                this.compiler.report(JSError.make(n, CALL_SIGNATURE_NOT_SUPPORTED, new String[0]));
                continue;
            }
            if (member.isIndexSignature()) {
                doc.recordImplementedInterface(this.createIObject(member));
                continue;
            }
            if (!member.isMemberVariableDef() && !member.getBooleanProp(75)) {
                this.maybeAddVisibility(member);
                continue;
            }
            if (metadata == null) {
                this.compiler.report(JSError.make(n, CANNOT_CONVERT_MEMBER_VARIABLES, new String[0]));
                return;
            }
            metadata.insertNodeAndAdvance(this.createPropertyDefinition(member, metadata.fullClassName));
            this.compiler.reportCodeChange();
        }
        n.setJSDocInfo(doc.build());
        this.maybeCreateQualifiedDeclaration(n, parent);
    }

    private void visitInterface(Node n, Node parent) {
        this.maybeAddGenerics(n, n);
        Node name = n.getFirstChild();
        Node superTypes = name.getNext();
        JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        doc.recordInterface();
        if (!superTypes.isEmpty()) {
            for (Node child : superTypes.children()) {
                Node type = this.convertWithLocation(child);
                doc.recordExtendedInterface(new JSTypeExpression(type, n.getSourceFileName()));
            }
        }
        Node insertionPoint = n;
        Node members = n.getLastChild();
        for (Node member : members.children()) {
            if (member.isCallSignature()) {
                this.compiler.report(JSError.make(n, CALL_SIGNATURE_NOT_SUPPORTED, new String[0]));
            }
            if (member.isIndexSignature()) {
                doc.recordExtendedInterface(this.createIObject(member));
            }
            if (member.isMemberFunctionDef()) {
                Node function = member.getFirstChild();
                if (function.isOptionalEs6Typed()) {
                    member = this.convertMemberFunctionToMemberVariable(member);
                } else {
                    function.getLastChild().setType(125);
                }
            }
            if (!member.isMemberVariableDef()) continue;
            Node newNode = this.createPropertyDefinition(member, name.getString());
            insertionPoint.getParent().addChildAfter(newNode, insertionPoint);
            insertionPoint = newNode;
        }
        n.setJSDocInfo(doc.build());
        n.setType(158);
        Node empty = new Node(124).useSourceInfoIfMissingFrom(n);
        n.replaceChild(superTypes, empty);
        members.setType(159);
        this.maybeCreateQualifiedDeclaration(n, parent);
        this.compiler.reportCodeChange();
    }

    private JSTypeExpression createIObject(Node indexSignature) {
        Node indexType = this.convertWithLocation(indexSignature.getFirstChild().getDeclaredTypeExpression());
        Node declaredType = this.convertWithLocation(indexSignature.getDeclaredTypeExpression());
        Node block = new Node(125, indexType, declaredType);
        Node iObject = IR.string("IObject");
        iObject.addChildrenToFront(block);
        JSTypeExpression bang = new JSTypeExpression(new Node(306, iObject).useSourceInfoIfMissingFromForTree(indexSignature), indexSignature.getSourceFileName());
        indexSignature.detachFromParent();
        this.compiler.reportCodeChange();
        return bang;
    }

    private Node createPropertyDefinition(Node member, String className) {
        member.detachFromParent();
        className = this.maybePrependCurrNamespace(className);
        Node nameAccess = NodeUtil.newQName(this.compiler, className);
        Node prototypeAccess = NodeUtil.newPropertyAccess(this.compiler, nameAccess, "prototype");
        Node qualifiedMemberAccess = Es6TypedToEs6Converter.getQualifiedMemberAccess(this.compiler, member, nameAccess, prototypeAccess);
        this.maybeVisitColonType(member, member);
        this.maybeAddVisibility(member);
        qualifiedMemberAccess.setJSDocInfo(member.getJSDocInfo());
        Node newNode = NodeUtil.newExpr(qualifiedMemberAccess);
        return newNode.useSourceInfoIfMissingFromForTree(member);
    }

    private static Node getQualifiedMemberAccess(AbstractCompiler compiler, Node member, Node staticAccess, Node instanceAccess) {
        Node context = member.isStaticMember() ? staticAccess : instanceAccess;
        context = context.cloneTree();
        if (member.isComputedProp()) {
            return IR.getelem(context, member.removeFirstChild());
        }
        return NodeUtil.newPropertyAccess(compiler, context, member.getString());
    }

    private void visitEnum(Node n, Node parent) {
        Node name = n.getFirstChild();
        Node members = n.getLastChild();
        double nextValue = 0.0;
        Node[] stringKeys = new Node[members.getChildCount()];
        for (int i = 0; i < members.getChildCount(); ++i) {
            Node child = members.getChildAtIndex(i);
            if (child.hasChildren()) {
                nextValue = child.getFirstChild().getDouble() + 1.0;
            } else {
                double d = nextValue;
                nextValue = d + 1.0;
                child.addChildToFront(IR.number(d));
            }
            stringKeys[i] = child;
        }
        for (Node child : stringKeys) {
            child.detachFromParent();
        }
        String oldName = name.getString();
        String qName = this.maybePrependCurrNamespace(oldName);
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordEnumParameterType(new JSTypeExpression(IR.string("number"), n.getSourceFileName()));
        Node newDec = NodeUtil.newQNameDeclaration(this.compiler, qName, IR.objectlit(stringKeys), builder.build()).useSourceInfoFromForTree(n);
        n.setJSDocInfo(null);
        parent.replaceChild(n, newDec);
        this.compiler.reportCodeChange();
    }

    private void visitFunction(Node n, Node parent) {
        String name;
        boolean isMemberFunctionDef = parent.isMemberFunctionDef();
        String string = name = isMemberFunctionDef ? parent.getString() : n.getFirstChild().getString();
        if (!name.isEmpty() && this.overloadStack.peek().containsKey(name)) {
            this.compiler.report(JSError.make(n, OVERLOAD_NOT_SUPPORTED, new String[0]));
            if (isMemberFunctionDef) {
                parent.detachFromParent();
            } else {
                n.detachFromParent();
            }
            if (!this.processedOverloads.contains(this.overloadStack)) {
                Node original = this.overloadStack.peek().get(name);
                this.processedOverloads.add(original);
                Node paramList = original.getSecondChild();
                paramList.removeChildren();
                Node originalParent = original.getParent();
                Node originalJsDocNode = originalParent.isMemberFunctionDef() || originalParent.isAssign() ? originalParent : original;
                JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
                builder.recordType(new JSTypeExpression(this.convertWithLocation(TypeDeclarationsIR.namedType("Function")), n.getSourceFileName()));
                originalJsDocNode.setJSDocInfo(builder.build());
            }
            this.compiler.reportCodeChange();
            return;
        }
        this.overloadStack.peek().put(name, n);
        Node jsDocNode = isMemberFunctionDef ? parent : n;
        this.maybeAddGenerics(n, jsDocNode);
        if (!isMemberFunctionDef || !n.isOptionalEs6Typed()) {
            this.maybeVisitColonType(n, jsDocNode);
        }
        if (n.getLastChild().isEmpty()) {
            n.replaceChild(n.getLastChild(), IR.block().useSourceInfoFrom(n));
        }
        if (!isMemberFunctionDef) {
            this.maybeCreateQualifiedDeclaration(n, parent);
        }
    }

    private void maybeAddVisibility(Node n) {
        JSDocInfo.Visibility access = (JSDocInfo.Visibility)((Object)n.getProp(84));
        if (access != null) {
            if (n.isComputedProp()) {
                this.compiler.report(JSError.make(n, COMPUTED_PROP_ACCESS_MODIFIER, new String[0]));
            }
            JSDocInfoBuilder memberDoc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
            memberDoc.recordVisibility(access);
            n.setJSDocInfo(memberDoc.build());
            n.removeProp(84);
        }
    }

    private void maybeVisitColonType(Node n, Node jsDocNode) {
        boolean hasColonType;
        Node type = n.getDeclaredTypeExpression();
        boolean bl = hasColonType = type != null;
        if (n.isRest() && hasColonType) {
            type = new Node(305, this.convertWithLocation(type.removeFirstChild()));
        } else if (n.isMemberVariableDef()) {
            if (type != null) {
                type = this.maybeProcessOptionalProperty(n, type);
            }
        } else {
            type = this.maybeProcessOptionalParameter(n, type);
        }
        if (type == null) {
            return;
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(jsDocNode.getJSDocInfo());
        JSTypeExpression typeExpression = new JSTypeExpression(type, n.getSourceFileName());
        switch (n.getType()) {
            case 105: {
                builder.recordReturnType(typeExpression);
                break;
            }
            case 319: {
                builder.recordType(typeExpression);
                break;
            }
            default: {
                builder.recordType(typeExpression);
                builder.recordInlineType();
            }
        }
        jsDocNode.setJSDocInfo(builder.build());
        if (hasColonType) {
            n.setDeclaredTypeExpression(null);
            this.compiler.reportCodeChange();
        }
    }

    private void visitTypeAlias(NodeTraversal t, Node n, Node parent) {
        String alias = n.getString();
        if (t.getScope().isDeclared(alias, true)) {
            this.compiler.report(JSError.make(n, TYPE_ALIAS_ALREADY_DECLARED, alias));
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordTypedef(new JSTypeExpression(this.convertWithLocation(n.getFirstChild()), n.getSourceFileName()));
        Node newName = this.maybeGetQualifiedNameNode(IR.name(n.getString())).useSourceInfoIfMissingFromForTree(n);
        Node newDec1 = NodeUtil.newQNameDeclaration(this.compiler, newName.getQualifiedName(), null, builder.build()).useSourceInfoFromForTree(n);
        parent.replaceChild(n, newDec1);
        this.compiler.reportCodeChange();
    }

    private void visitAmbientDeclaration(Node n, Node parent) {
        boolean insideExport;
        if (!n.isFromExterns()) {
            this.compiler.report(JSError.make(n, DECLARE_IN_NON_EXTERNS, new String[0]));
        }
        Node insertionPoint = n;
        Node topLevel = parent;
        boolean bl = insideExport = parent.getType() == 169;
        if (insideExport) {
            insertionPoint = parent;
            topLevel = parent.getParent();
        }
        for (Node c : n.children()) {
            if (c.getType() == 149) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(c.getJSDocInfo());
                builder.recordConstancy();
                c.setType(118);
                c.setJSDocInfo(builder.build());
            }
            Node toAdd = c.detachFromParent();
            if (insideExport && !toAdd.isExprResult()) {
                toAdd = new Node(169, toAdd).srcref(parent);
            }
            topLevel.addChildBefore(toAdd, insertionPoint);
        }
        insertionPoint.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitExport(Node n, Node parent) {
        if (this.currNamespace != null) {
            this.replaceWithNodes(n, n.children());
        } else if (n.hasMoreThanOneChild()) {
            Node insertPoint = n;
            for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
                Node toAdd;
                if (!c.isExprResult()) {
                    toAdd = n.cloneNode();
                    toAdd.addChildToFront(c.detachFromParent());
                } else {
                    toAdd = c.detachFromParent();
                }
                parent.addChildAfter(toAdd, insertPoint);
                insertPoint = toAdd;
            }
            this.compiler.reportCodeChange();
        }
    }

    private void replaceWithNodes(Node n, Iterable<Node> replacements) {
        Node insertPoint = n;
        for (Node c : replacements) {
            Node detached = c.detachFromParent();
            n.getParent().addChildAfter(detached, insertPoint);
            insertPoint = detached;
        }
        n.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitVarInsideNamespace(Node n, Node parent) {
        if (this.currNamespace != null) {
            Node insertPoint = n;
            Iterator<Node> iterator = n.children().iterator();
            while (iterator.hasNext()) {
                Node child;
                Node name = child = iterator.next();
                String oldName = name.getString();
                String qName = this.maybePrependCurrNamespace(oldName);
                JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(child.getJSDocInfo());
                if (n.isConst()) {
                    builder.recordConstancy();
                }
                Node newDec = NodeUtil.newQNameDeclaration(this.compiler, qName, child.removeFirstChild(), builder.build()).useSourceInfoFromForTree(n);
                parent.addChildAfter(newDec, insertPoint);
                insertPoint = newDec;
            }
            n.detachFromParent();
            this.compiler.reportCodeChange();
        }
    }

    private Node maybeCreateAnyType(Node n, Node type) {
        return type == null ? TypeDeclarationsIR.anyType().useSourceInfoIfMissingFrom(n) : type;
    }

    private Node maybeProcessOptionalParameter(Node n, Node type) {
        if (n.isOptionalEs6Typed()) {
            n.putBooleanProp(80, false);
            type = this.maybeCreateAnyType(n, type);
            return new Node(307, this.convertWithLocation(type));
        }
        return type == null ? null : this.convertWithLocation(type);
    }

    private Node maybeProcessOptionalProperty(Node n, Node type) {
        if (n.isOptionalEs6Typed()) {
            n.putBooleanProp(80, false);
            Node.TypeDeclarationNode baseType = (Node.TypeDeclarationNode)this.maybeCreateAnyType(n, type);
            type = TypeDeclarationsIR.unionType((Iterable<Node.TypeDeclarationNode>)ImmutableList.of((Object)baseType, (Object)TypeDeclarationsIR.undefinedType()));
            type.useSourceInfoIfMissingFromForTree(baseType);
        } else {
            type = this.maybeCreateAnyType(n, type);
        }
        return this.convertWithLocation(type);
    }

    private Node convertWithLocation(Node type) {
        return this.convertDeclaredTypeToJSDoc(type).useSourceInfoIfMissingFrom(type);
    }

    private Node convertDeclaredTypeToJSDoc(Node type) {
        Preconditions.checkArgument((boolean)(type instanceof Node.TypeDeclarationNode));
        switch (type.getType()) {
            case 200: {
                return IR.string("string");
            }
            case 201: {
                return IR.string("boolean");
            }
            case 202: {
                return IR.string("number");
            }
            case 209: {
                return IR.string("void");
            }
            case 214: {
                return IR.string("undefined");
            }
            case 206: {
                return new Node(304);
            }
            case 211: {
                return this.convertNamedType(type);
            }
            case 215: {
                Node arrayType = IR.string("Array");
                Node memberType = this.convertWithLocation(type.getFirstChild());
                arrayType.addChildToFront(new Node(125, memberType).useSourceInfoIfMissingFrom(type));
                return new Node(306, arrayType);
            }
            case 204: {
                Node namedType = type.getFirstChild();
                Node result = this.convertWithLocation(namedType);
                Node typeParameterTarget = result.getType() == 306 ? result.getFirstChild() : result;
                Node parameters = IR.block().useSourceInfoIfMissingFrom(type);
                typeParameterTarget.addChildToFront(parameters);
                for (Node param = namedType.getNext(); param != null; param = param.getNext()) {
                    parameters.addChildToBack(this.convertWithLocation(param));
                }
                return result;
            }
            case 203: {
                Node returnType = type.getFirstChild();
                Node paramList = new Node(83);
                for (Node param = returnType.getNext(); param != null; param = param.getNext()) {
                    Node paramType = param.getDeclaredTypeExpression();
                    paramType = param.isRest() ? (paramType == null ? new Node(305, new Node(304)) : new Node(305, this.convertWithLocation(paramType.getFirstChild()))) : this.maybeProcessOptionalParameter(param, this.maybeCreateAnyType(param, paramType));
                    paramList.addChildToBack(paramType);
                }
                Node function = new Node(105);
                if (paramList.hasChildren()) {
                    function.addChildToBack(paramList);
                }
                function.addChildToBack(this.convertWithLocation(returnType));
                return function;
            }
            case 205: {
                Node pipe = new Node(301);
                for (Node child : type.children()) {
                    pipe.addChildToBack(this.convertWithLocation(child));
                }
                return pipe;
            }
            case 213: {
                Node lb = new Node(308);
                for (Node member : type.children()) {
                    if (member.isMemberFunctionDef()) {
                        member = this.convertMemberFunctionToMemberVariable(member);
                    } else if (!member.isMemberVariableDef()) {
                        this.compiler.report(JSError.make(type, UNSUPPORTED_RECORD_TYPE, new String[0]));
                        continue;
                    }
                    Node colon = new Node(310);
                    member.setType(154);
                    Node memberType = this.maybeProcessOptionalProperty(member, member.getDeclaredTypeExpression());
                    member.setDeclaredTypeExpression(null);
                    colon.addChildToBack(member.detachFromParent());
                    colon.addChildToBack(memberType);
                    lb.addChildrenToBack(colon);
                }
                return new Node(309, lb);
            }
            case 32: {
                this.compiler.report(JSError.make(type, TYPE_QUERY_NOT_SUPPORTED, new String[0]));
                return new Node(304);
            }
            case 40: {
                this.compiler.report(JSError.make(type, SPECIALIZED_SIGNATURE_NOT_SUPPORTED, new String[0]));
                return new Node(304);
            }
        }
        throw new IllegalArgumentException("Unexpected node type for type conversion: " + type.getType());
    }

    private Node convertNamedType(Node type) {
        Node oldNameNode = type.getFirstChild();
        Node newNameNode = this.maybeGetQualifiedNameNode(oldNameNode);
        if (newNameNode != oldNameNode) {
            type.replaceChild(oldNameNode, newNameNode);
        }
        Node propTree = type.getFirstChild();
        String dotted = propTree.getQualifiedName();
        return new Node(306, IR.string(dotted));
    }

    private void maybeCreateQualifiedDeclaration(Node n, Node parent) {
        if (this.currNamespace != null) {
            Node name = n.getFirstChild();
            String oldName = name.getString();
            String qName = this.maybePrependCurrNamespace(oldName);
            Node newName = n.isFunction() ? IR.name("") : IR.empty();
            newName.useSourceInfoFrom(n);
            n.replaceChild(name, newName);
            Node placeHolder = IR.empty();
            parent.replaceChild(n, placeHolder);
            Node newDec = NodeUtil.newQNameDeclaration(this.compiler, qName, n, n.getJSDocInfo()).useSourceInfoFromForTree(n);
            n.setJSDocInfo(null);
            parent.replaceChild(placeHolder, newDec);
            this.compiler.reportCodeChange();
        }
    }

    private Node convertMemberFunctionToMemberVariable(Node member) {
        Node function = member.getFirstChild();
        Node memberVariable = Node.newString(319, member.getString());
        memberVariable.useSourceInfoFrom(member);
        if (!this.processedOverloads.contains(function)) {
            Node returnType = this.maybeCreateAnyType(function, function.getDeclaredTypeExpression());
            LinkedHashMap<String, Node.TypeDeclarationNode> required = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            LinkedHashMap<String, Node.TypeDeclarationNode> optional = new LinkedHashMap<String, Node.TypeDeclarationNode>();
            String restName = null;
            Node.TypeDeclarationNode restType = null;
            for (Node param : function.getSecondChild().children()) {
                if (param.isName()) {
                    if (param.isOptionalEs6Typed()) {
                        optional.put(param.getString(), param.getDeclaredTypeExpression());
                        continue;
                    }
                    required.put(param.getString(), param.getDeclaredTypeExpression());
                    continue;
                }
                if (!param.isRest()) continue;
                restName = param.getFirstChild().getString();
                restType = param.getDeclaredTypeExpression();
            }
            Node.TypeDeclarationNode type = TypeDeclarationsIR.functionType(returnType, required, optional, restName, restType);
            memberVariable.setDeclaredTypeExpression(type);
        } else {
            memberVariable.setDeclaredTypeExpression(TypeDeclarationsIR.namedType("Function"));
        }
        memberVariable.putBooleanProp(80, function.isOptionalEs6Typed());
        member.getParent().replaceChild(member, memberVariable);
        return memberVariable;
    }

    private Node maybeGetQualifiedNameNode(Node oldNameNode) {
        if (oldNameNode.isName()) {
            String oldName = oldNameNode.getString();
            Namespace definitionNamespace = this.currNamespace;
            while (definitionNamespace != null) {
                if (definitionNamespace.typeNames.contains(oldName)) {
                    return NodeUtil.newQName(this.compiler, definitionNamespace.name + "." + oldName).useSourceInfoFromForTree(oldNameNode);
                }
                definitionNamespace = definitionNamespace.parent;
            }
        }
        return oldNameNode;
    }

    private void pushOverloads() {
        this.overloadStack.push(new HashMap());
    }

    private void popOverloads() {
        this.overloadStack.pop();
    }

    private String maybePrependCurrNamespace(String oldName) {
        return this.currNamespace == null ? oldName : this.currNamespace.name + "." + oldName;
    }

    private void popNamespace(Node n, Node parent) {
        if (n.getType() == 172) {
            Node parentModuleRoot;
            Node grandParent = parent.getParent();
            switch (parent.getType()) {
                case 169: 
                case 318: {
                    if (parent.getParent().getType() == 169) {
                        parentModuleRoot = grandParent.getGrandparent();
                        break;
                    }
                    parentModuleRoot = grandParent.getParent();
                    break;
                }
                default: {
                    parentModuleRoot = grandParent;
                }
            }
            this.currNamespace = this.nodeNamespaceMap.get(parentModuleRoot);
        }
    }

    private static class Namespace {
        private final String name;
        private Set<String> typeNames;
        private Namespace parent;

        private Namespace(String name, Namespace parent) {
            this.name = name;
            this.parent = parent;
            this.typeNames = new HashSet<String>();
        }
    }

    private class ScanNamespaces
    implements NodeTraversal.Callback {
        private Map<String, Namespace> namespaces = new HashMap<String, Namespace>();

        private ScanNamespaces() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 132: 
                case 322: {
                    return true;
                }
                case 125: {
                    return n.getFirstChild() != null && n.getFirstChild().isScript();
                }
                case 318: {
                    return n.getFirstChild().getType() == 172;
                }
                case 169: {
                    switch (n.getFirstChild().getType()) {
                        case 158: 
                        case 172: 
                        case 311: 
                        case 314: 
                        case 317: 
                        case 318: {
                            return true;
                        }
                    }
                    return false;
                }
                case 172: {
                    String[] segments;
                    for (String s : segments = n.getFirstChild().getQualifiedName().split("\\.")) {
                        String currName = Es6TypedToEs6Converter.this.maybePrependCurrNamespace(s);
                        if (!this.namespaces.containsKey(currName)) {
                            Es6TypedToEs6Converter.this.currNamespace = new Namespace(currName, Es6TypedToEs6Converter.this.currNamespace);
                            this.namespaces.put(currName, Es6TypedToEs6Converter.this.currNamespace);
                        }
                        Es6TypedToEs6Converter.this.currNamespace = this.namespaces.get(currName);
                    }
                    Es6TypedToEs6Converter.this.nodeNamespaceMap.put(n, Es6TypedToEs6Converter.this.currNamespace);
                    return true;
                }
                case 158: 
                case 311: 
                case 314: {
                    if (Es6TypedToEs6Converter.this.currNamespace != null) {
                        Es6TypedToEs6Converter.this.currNamespace.typeNames.add(n.getFirstChild().getString());
                    }
                    return true;
                }
                case 317: {
                    if (Es6TypedToEs6Converter.this.currNamespace != null) {
                        Es6TypedToEs6Converter.this.currNamespace.typeNames.add(n.getString());
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Es6TypedToEs6Converter.this.popNamespace(n, parent);
        }
    }
}

