/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.editors;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.editors.CoverageSessionInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.data.SessionInfoStore;

class ExecutionDataContent {
    private ExecutionDataStore executionData;
    private SessionInfoStore sessionData;
    private final List<IPropertyListener> listeners;

    public ExecutionDataContent() {
        this.clear();
        this.listeners = new ArrayList<IPropertyListener>();
    }

    public void load(IEditorInput input) {
        this.clear();
        try {
            if (input instanceof CoverageSessionInput) {
                CoverageSessionInput csi = (CoverageSessionInput)input;
                csi.getSession().accept((IExecutionDataVisitor)this.executionData, (ISessionInfoVisitor)this.sessionData);
            } else {
                InputStream stream = this.openStream(input);
                ExecutionDataReader reader = new ExecutionDataReader(stream);
                reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionData);
                reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionData);
                while (reader.read()) {
                }
            }
        }
        catch (CoreException e) {
            EclEmmaUIPlugin.log(e);
        }
        catch (IOException e) {
            EclEmmaUIPlugin.log(e);
        }
        this.fireChangedEvent();
    }

    private InputStream openStream(IEditorInput input) throws CoreException, IOException {
        if (input instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)input).getStorage();
            return storage.getContents();
        }
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            return uri.toURL().openStream();
        }
        throw new IOException("Unsupported input type: " + input.getClass());
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangedEvent() {
        for (IPropertyListener l : this.listeners) {
            l.propertyChanged((Object)this, 0);
        }
    }

    public ExecutionData[] getExecutionData() {
        Collection data = this.executionData.getContents();
        return data.toArray(new ExecutionData[data.size()]);
    }

    public SessionInfo[] getSessionInfos() {
        List infos = this.sessionData.getInfos();
        return infos.toArray(new SessionInfo[infos.size()]);
    }

    private void clear() {
        this.executionData = new ExecutionDataStore();
        this.sessionData = new SessionInfoStore();
    }
}

