/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.exporter.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.ecore.xcore.exporter.XcoreExporter;
import org.eclipse.emf.ecore.xcore.exporter.XcoreExporterPlugin;
import org.eclipse.emf.exporter.ui.contribution.base.ModelExporterDirectoryURIPage;
import org.eclipse.emf.exporter.ui.contribution.base.ModelExporterOptionsPage;
import org.eclipse.emf.exporter.ui.contribution.base.ModelExporterPackagePage;
import org.eclipse.emf.exporter.ui.contribution.base.ModelExporterWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XcoreExporterWizard
extends ModelExporterWizard {
    @Inject
    protected Provider<XcoreExporter> xcoreExporterProvider;
    protected boolean retry;

    protected ModelConverter createModelConverter() {
        return (ModelConverter)this.xcoreExporterProvider.get();
    }

    public void addPages() {
        ModelExporterDirectoryURIPage directoryURIPage = new ModelExporterDirectoryURIPage(this.getModelExporter(), "XcoreExporterBaseLocationPage");
        directoryURIPage.setTitle(XcoreExporterPlugin.INSTANCE.getString("_UI_XcoreImport_title"));
        this.addPage((IWizardPage)directoryURIPage);
        ModelExporterPackagePage packagePage = new ModelExporterPackagePage(this.getModelExporter(), "XcoreExporterGenModelDetailPage");
        packagePage.setTitle(XcoreExporterPlugin.INSTANCE.getString("_UI_XcoreImport_title"));
        this.addPage((IWizardPage)packagePage);
        ModelExporterOptionsPage optionsPage = new ModelExporterOptionsPage(this.getModelExporter(), "XcoreExporterOptionsPage");
        optionsPage.setTitle(XcoreExporterPlugin.INSTANCE.getString("_UI_XcoreImport_title"));
        this.addPage((IWizardPage)optionsPage);
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (this.retry) {
            result = super.performFinish();
        }
        Shell shell = this.getShell();
        shell.setEnabled(false);
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ((XcoreExporter)XcoreExporterWizard.this.getModelConverter()).waitForSaveJob();
            }
        });
        return result;
    }

    protected void handleConvertDiagnostic(Diagnostic diagnostic) {
        if (diagnostic == XcoreExporter.RETRY) {
            this.retry = true;
        } else {
            super.handleConvertDiagnostic(diagnostic);
        }
    }
}

